/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.util;

import cn.remex.core.util.Combination;
import cn.remex.core.util.Number;
import cn.remex.core.util.Numeric;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class Arith {
    public static final BigDecimal one = new BigDecimal("1");
    private static final int DEF_DIV_SCALE = 10;

    private Arith() {
    }

    public static void main(String ... strings) {
        double[] source = new double[]{5.0, 2.0, 4.0, 6.0, 7.0, 9.0, 11.0, 3.0, 12.0, 22.0};
        List<Combination<Numeric>> a = Arith.findCombination(source, 10.0, 5.0, -0.8, 0.0);
        System.out.println(a.size());
        for (Combination<Numeric> n : a) {
            System.out.println(n);
        }
    }

    public static List<Combination<Numeric>> findCombination(double[] source, double targetValue, double positiveDeviation, double negativeDeviation, double permittedDeviation) {
        ArrayList<Number> sourceList = new ArrayList<Number>();
        for (double n : source) {
            sourceList.add(new Number(n));
        }
        return Arith.findCombination(sourceList, targetValue, positiveDeviation, negativeDeviation, permittedDeviation);
    }

    public static <T extends Numeric> List<Combination<T>> findCombination(List<T> source, double targetValue, double positiveDeviation, double negativeDeviation, double permittedDeviation) {
        if (source == null || source.size() == 0) {
            return null;
        }
        Comparator<Numeric> comparator = new Comparator<Numeric>(){

            @Override
            public int compare(Numeric o1, Numeric o2) {
                double diff = o1.getValue() - o2.getValue();
                return diff >= 0.0 ? 1 : -1;
            }
        };
        ArrayList<Combination<T>> resultList = new ArrayList<Combination<T>>();
        Collections.sort(source, comparator);
        int length = source.size();
        int count = 0;
        int[] subscriptArray = new int[length];
        for (int i = 0; i < length; ++i) {
            subscriptArray[i] = 0;
        }
        subscriptArray[0] = 1;
        int arrayLocationIndex = 1;
        int tempNumber = 1;
        while (subscriptArray[0] != length + 1) {
            boolean ok;
            double curCombinationValue = 0.0;
            for (int i = 0; i < subscriptArray.length; ++i) {
                if (subscriptArray[i] == 0) continue;
                curCombinationValue += ((Numeric)source.get(subscriptArray[i] - 1)).getValue();
            }
            double diff = (curCombinationValue - targetValue) / targetValue;
            boolean bl = ok = diff >= negativeDeviation && diff <= positiveDeviation;
            if (ok) {
                ++count;
                ArrayList<Numeric> combinationItems = new ArrayList<Numeric>();
                for (int i = 0; i < subscriptArray.length; ++i) {
                    if (subscriptArray[i] == 0) continue;
                    Numeric bj = (Numeric)source.get(subscriptArray[i] - 1);
                    combinationItems.add(bj);
                }
                resultList.add(new Combination(diff, combinationItems));
                if (permittedDeviation != 0.0 && Math.abs(diff) < permittedDeviation) {
                    return resultList;
                }
                if (count > 1000000) {
                    throw new RuntimeException("\u7ec4\u5408\u7684\u53ef\u80fd\u6027\u592a\u591a\uff0c\u8d85\u8fc7100W\u79cd\u7ec4\u5408\u5747\u7b26\u5408\u6761\u4ef6\uff0c\u7ec8\u6b62\u8ba1\u7b97\uff01");
                }
            }
            if (diff == positiveDeviation) {
                if (arrayLocationIndex == 1) {
                    subscriptArray[0] = subscriptArray[0] + 1;
                    continue;
                }
                if (tempNumber < length) {
                    int n = arrayLocationIndex - 1;
                    subscriptArray[n] = subscriptArray[n] + 1;
                    tempNumber = subscriptArray[arrayLocationIndex - 1];
                    continue;
                }
                subscriptArray[arrayLocationIndex - 1] = 0;
                int n = arrayLocationIndex - 2;
                subscriptArray[n] = subscriptArray[n] + 1;
                tempNumber = subscriptArray[arrayLocationIndex - 2];
                --arrayLocationIndex;
                continue;
            }
            if (diff < positiveDeviation) {
                if (tempNumber < length) {
                    subscriptArray[arrayLocationIndex] = ++tempNumber;
                    ++arrayLocationIndex;
                    continue;
                }
                if (arrayLocationIndex == 1) break;
                subscriptArray[arrayLocationIndex - 1] = 0;
                int n = arrayLocationIndex - 2;
                subscriptArray[n] = subscriptArray[n] + 1;
                tempNumber = subscriptArray[arrayLocationIndex - 2];
                --arrayLocationIndex;
                continue;
            }
            if (!(diff > positiveDeviation)) continue;
            if (tempNumber == 1 || arrayLocationIndex == 1) break;
            subscriptArray[arrayLocationIndex - 1] = 0;
            int n = arrayLocationIndex - 2;
            subscriptArray[n] = subscriptArray[n] + 1;
            tempNumber = subscriptArray[arrayLocationIndex - 2];
            --arrayLocationIndex;
        }
        Collections.sort(resultList, new Comparator<Combination<T>>(){

            @Override
            public int compare(Combination<T> o1, Combination<T> o2) {
                double diff = Math.abs(o1.getDeviation()) - Math.abs(o2.getDeviation());
                return diff > 0.0 ? 1 : (diff < 0.0 ? -1 : (o1.getDeviation() < 0.0 ? 1 : (o1.getDeviation() > 0.0 ? -1 : 0)));
            }
        });
        return resultList;
    }

    public static double add(Object v1, Object v2) {
        BigDecimal b1 = new BigDecimal(String.valueOf(v1));
        BigDecimal b2 = new BigDecimal(String.valueOf(v2));
        return b1.add(b2).doubleValue();
    }

    public static double div(Object v1, Object v2) {
        return Arith.div(v1, v2, 10);
    }

    public static double div(Object v1, Object v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(String.valueOf(v1));
        BigDecimal b2 = new BigDecimal(String.valueOf(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double mul(Object v1, Object v2) {
        BigDecimal b1 = new BigDecimal(String.valueOf(v1));
        BigDecimal b2 = new BigDecimal(String.valueOf(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double round(Object v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(String.valueOf(v));
        return b.divide(one, scale, 4).doubleValue();
    }

    public static String round(String numbericString, int scale) {
        BigDecimal b = new BigDecimal(numbericString);
        if (0 == scale) {
            return String.valueOf(b.divide(one, scale, 4).intValue());
        }
        return String.valueOf(b.divide(one, scale, 4).doubleValue());
    }

    public static double sub(Object v1, Object v2) {
        BigDecimal b1 = new BigDecimal(String.valueOf(v1));
        BigDecimal b2 = new BigDecimal(String.valueOf(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double parse(String v1) {
        return new BigDecimal(String.valueOf(v1)).doubleValue();
    }

    public static double abs(Object v1) {
        return Math.abs(new BigDecimal(String.valueOf(v1)).doubleValue());
    }
}

