/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core.aop;

import cn.remex.RemexConstants;
import cn.remex.core.aop.AOPAspect;
import cn.remex.core.aop.AOPPoint;
import cn.remex.core.util.Assert;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class AOPCaller
implements MethodInterceptor,
RemexConstants,
Serializable {
    private static final long serialVersionUID = -4610552176621251394L;
    private Class<? extends Annotation> annotationClass;
    private AOPAspect Iaop;
    private boolean interceptorAllMethod = true;

    public AOPCaller(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
        this.interceptorAllMethod = null == this.annotationClass;
    }

    public AOPAspect getIaop() {
        return this.Iaop;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = null;
        AOPPoint aopPoint = new AOPPoint(obj, method, args, proxy);
        if (this.interceptorAllMethod || method.isAnnotationPresent(this.annotationClass) || obj.getClass().getSuperclass().isAnnotationPresent(this.annotationClass)) {
            try {
                this.Iaop.beforeMethod(aopPoint);
                result = this.Iaop.aroundMethod(aopPoint);
                this.Iaop.afterMethod(aopPoint);
            }
            catch (Exception e) {
                this.Iaop.afterThrowing(aopPoint, e);
            }
            return result;
        }
        return this.invokeMethod(obj, args, proxy);
    }

    public void setIaop(AOPAspect iaop) {
        Assert.notNull(iaop, "ERROR", "\u5904\u7406\u5207\u9762\u7684\u65b9\u6cd5\u5bf9\u8c61AOPAspect\u4e0d\u80fd\u4e3anull\uff01");
        this.Iaop = iaop;
    }

    private Object invokeMethod(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public boolean isInterceptorAllMethod() {
        return this.interceptorAllMethod;
    }

    public void setInterceptorAllMethod(boolean interceptorAllMethod) {
        this.interceptorAllMethod = interceptorAllMethod;
    }
}

