/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.core;

import cn.remex.RemexConstants;
import cn.remex.core.RemexEvent;
import cn.remex.core.RemexRefreshable;
import cn.remex.core.RemexStartupEvent;
import cn.remex.core.cache.DataCachePool;
import cn.remex.core.reflect.ReflectConfigure;
import cn.remex.core.util.Judgment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RemexApplication
implements ApplicationContextAware,
ApplicationEventPublisherAware,
DisposableBean,
RemexConstants {
    public static List<RemexRefreshable> refreshables = new ArrayList<RemexRefreshable>();
    private static boolean isStarted = false;
    private static ApplicationContext context;
    private static ApplicationEventPublisher EventPublisher;

    public static <T> T getBean(String name) {
        try {
            return (T)RemexApplication.getContext().getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static String getMapValue(String name, String key) {
        Map map = (Map)RemexApplication.getBean(name);
        return map == null ? null : (String)map.get(key);
    }

    public static String getConfig(String name, String defaultValue) {
        return null == RemexApplication.getBean("CONFIG") ? defaultValue : (String)((Map)RemexApplication.getBean("CONFIG")).get(name);
    }

    public static void init() {
        RemexApplication.getContext();
        RemexApplication.refresh();
    }

    public static ApplicationContext getContext() {
        if (null == context) {
            String defaultConfig = "classpath:applicationContext.xml";
            context = new ClassPathXmlApplicationContext(defaultConfig);
            RemexApplication.publishRemexStartupEvent();
            RemexConstants.logger.info((Object)("Remex Spring\u6a21\u5757\u5de5\u4f5c\u5728[ \u672c\u5730 ]\u6a21\u5f0f\uff1a" + context.getDisplayName()));
        }
        return context;
    }

    public static <T> T getBean(Class<T> clazz, String ... scope) {
        return RemexApplication.getBean(clazz, null == scope || scope.length == 0 ? "prototype" : scope[0], new Object[0], new String[0]);
    }

    public static <T> T getBean(Class<T> clazz, String scope, Object[] PropertyValues, String[] PropertyReferences) {
        return RemexApplication.getBean(clazz.getName(), clazz, scope, PropertyValues, PropertyReferences);
    }

    public static <T> T getBean(String beanName, Class<T> clazz, String scope, Object[] PropertyValues, String[] PropertyReferences) {
        String className = beanName;
        if (RemexApplication.getContext().containsBean(beanName)) {
            return (T)RemexApplication.getContext().getBean(beanName);
        }
        RemexApplication.registerBeanDefinition(beanName, clazz, scope, PropertyValues, PropertyReferences);
        return (T)RemexApplication.getContext().getBean(className);
    }

    public static <T> void registerBeanDefinitionWithClassName(Class<T> clazz, String scope, Object[] PropertyValues, String[] PropertyReferences) {
        RemexApplication.registerBeanDefinition(clazz.getName(), clazz, scope, PropertyValues, PropertyReferences);
    }

    public static <T> void registerBeanDefinition(String beanName, Class<T> clazz, String scope, Object[] PropertyValues, String[] PropertyReferences) {
        int i;
        int l;
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.rootBeanDefinition((String)clazz.getName());
        bdb.setScope(Judgment.nullOrBlank(scope) ? "prototype" : scope);
        if (null != PropertyValues) {
            l = PropertyValues.length;
            for (i = 0; i < l; i += 2) {
                bdb.addPropertyValue((String)PropertyValues[i], PropertyValues[i + 1]);
            }
        }
        if (null != PropertyReferences) {
            l = PropertyReferences.length;
            for (i = 0; i < l; i += 2) {
                bdb.addPropertyReference(PropertyReferences[i], PropertyReferences[i + 1]);
            }
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)RemexApplication.getContext()).getBeanFactory();
        beanFactory.registerBeanDefinition(beanName, (BeanDefinition)bdb.getBeanDefinition());
    }

    public static void refresh() {
        for (RemexRefreshable remexRefreshable : refreshables) {
            remexRefreshable.refresh();
            logger.info((Object)("RemexRefreshable executing:" + remexRefreshable.getClass()));
        }
        logger.info((Object)"RemexRefreshables\u5237\u65b0\u914d\u7f6e\u5b8c\u6210!");
        if (isStarted) {
            ((AbstractRefreshableConfigApplicationContext)RemexApplication.getContext()).stop();
            ((AbstractRefreshableConfigApplicationContext)RemexApplication.getContext()).refresh();
            logger.info((Object)"\u5237\u65b0Spring\u914d\u7f6e\u5b8c\u6210\uff01");
            ReflectConfigure.clearCache();
            logger.info((Object)"\u6e05\u9664FieldMapperMap\u7f13\u5b58\u5b8c\u6210\uff01");
            DataCachePool.reset();
            logger.info((Object)"\u6e05\u9664DataCachePool\u7f13\u5b58\u5b8c\u6210\uff01");
        }
        RemexApplication.publishRemexStartupEvent();
        logger.info((Object)"Remex\u521d\u6b21\u542f\u52a8\u5b8c\u6210!");
    }

    private static void publishRemexStartupEvent() {
        if (!RemexApplication.getContext().containsBean(RemexApplication.class.getName())) {
            EventPublisher = context;
        }
        if (!isStarted) {
            EventPublisher.publishEvent((ApplicationEvent)new RemexStartupEvent("RemexStartup"));
        }
        isStarted = true;
        logger.info((Object)"Spring RemexStartup\u4e8b\u4ef6\u9996\u6b21\u901a\u77e5\u5b8c\u6210!");
    }

    public static void publishEvent(RemexEvent remexEvent) {
        EventPublisher.publishEvent((ApplicationEvent)remexEvent);
    }

    public void destroy() throws Exception {
    }

    public void setApplicationContext(ApplicationContext contex) throws BeansException {
        context = contex;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher paramApplicationEventPublisher) {
        EventPublisher = paramApplicationEventPublisher;
    }

    public void setRemexRefreshTarget(RemexRefreshable remexRefreshable) {
        refreshables.add(remexRefreshable);
    }
}

