/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.contrib.service;

import cn.remex.RemexConstants;
import cn.remex.contrib.appbeans.DataCvo;
import cn.remex.contrib.appbeans.DataRvo;
import cn.remex.contrib.auth.AuthenticateBtx;
import cn.remex.core.CoreSvo;
import cn.remex.core.RemexApplication;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.db.Database;
import cn.remex.db.DbRvo;
import cn.remex.db.model.cert.AuthUser;
import cn.remex.db.sql.WhereGroupOp;
import cn.remex.db.sql.WhereRuleOper;
import cn.remex.web.service.BsRvo;
import cn.remex.web.service.BusinessService;
import cn.remex.web.service.appbeans.AsyncCvo;
import cn.remex.web.service.appbeans.AsyncRvo;
import cn.remex.wechat.WeChat;
import cn.remex.wechat.beans.WeChatUserInfo;
import cn.remex.wechat.beans.messages.TemplateMessage;
import cn.remex.wechat.beans.messages.TemplateMsg;
import cn.remex.wechat.config.WeChatApp;
import cn.remex.wechat.event.WeChatClickEvent;
import cn.remex.wechat.event.WeChatEvent;
import cn.remex.wechat.event.WeChatScanEvent;
import cn.remex.wechat.event.WeChatSubscribeEvent;
import cn.remex.wechat.event.WeChatTextEvent;
import cn.remex.wechat.event.WeChatUnsubscribeEvent;
import cn.remex.wechat.models.WeChatMsg;
import cn.remex.wechat.models.WeChatNotify;
import cn.remex.wechat.models.WeChatUser;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;

@BusinessService
@Component
@EnableAsync
public class WeiXinService {
    public static final String weixinLoginQrcodeUrl_SceneId = "100";

    @BusinessService(authLevel=RemexConstants.UserType.ADMIN)
    public Object wechatApps() {
        HashMap wechatApps = new HashMap();
        WeChat.getWeChatAppConfigMap().forEach((appid, app) -> wechatApps.put(Judgment.nullOrBlank(app.getAppName()) ? appid : app.getAppName(), appid));
        return wechatApps;
    }

    @BusinessService(authLevel=RemexConstants.UserType.ADMIN)
    public Object updateWxMenu(String appid, String agentid) {
        WeChatApp curApp = WeChat.getWeChatApp(appid, Judgment.nullOrBlank(agentid) ? "0" : agentid);
        Assert.notNullAndEmpty(curApp, "FAIL", "\u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684wxapp,appid=" + appid + ";agentid=" + agentid);
        return curApp.menuCreate(null);
    }

    @BusinessService(needAuth=false)
    public BsRvo redirectWxMenu(String code, String state, String quickCheck) {
        Assert.notNullAndEmpty(state, "FAIL", "\u5fae\u4fe1OAuth2.0\u9a8c\u8bc1\u63a5\u53e3URL\u8df3\u8f6c\u65f6state\u4e0d\u5f97\u4e3a\u7a7a");
        String[] orginStates = state.split(";");
        state = orginStates[0];
        String appid = orginStates.length > 1 ? orginStates[1] : null;
        String agentid = orginStates.length > 2 ? orginStates[2] : null;
        WeChatApp curAppConfig = WeChat.getWeChatApp(appid, agentid);
        String orgin_redirect = curAppConfig.obtainStateRedirect(state);
        if (Judgment.nullOrBlank(code) && "true".equals(quickCheck)) {
            if (AuthenticateBtx.obtainCurUser() != null) {
                RemexConstants.logger.info((Object)("===================\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\uff0c\u7f13\u5b58\u5b58\u5728\u5feb\u901f\u8df3\u8f6c,state_redirect=" + orgin_redirect + ",=================="));
                return new BsRvo("SUCCESS", "\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\u670d\u52a1\u6b63\u5e38\uff0c\u7ed1\u5b9a\u7528\u6237\u767b\u5f55\u6210\u529f", null, RemexConstants.ResponseContentType.redirect, orgin_redirect);
            }
            String redirectUrl = curAppConfig.oauth2_authorize("http%3a%2f%2f" + curAppConfig.getRedirectDomain() + "%2fsmvc%2fWeiXinService%2fredirectWxMenu.json", state + ";" + appid + ";" + agentid);
            RemexConstants.logger.info((Object)("===================\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\uff0c\u5feb\u901f\u8df3\u8f6c\u672a\u901a\u8fc7,state_redirect=" + orgin_redirect + ",\u5fae\u4fe1url" + redirectUrl + "=================="));
            return new BsRvo("SUCCESS", "\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\u670d\u52a1\u6b63\u5e38\uff0c\u5feb\u901f\u9a8c\u8bc1\u672a\u901a\u8fc7", null, RemexConstants.ResponseContentType.redirect, redirectUrl);
        }
        RemexConstants.logger.info((Object)("===================\u5fae\u4fe1\u83dc\u5355\u56de\u8c03,code=" + code + ";state=" + state + ",=================="));
        Assert.notNullAndEmpty(code, "FAIL", "\u5fae\u4fe1OAuth2.0\u9a8c\u8bc1\u63a5\u53e3URL\u8df3\u8f6c\u65f6code\u4e0d\u5f97\u4e3a\u7a7a");
        WeChatUser weChatUser = curAppConfig.obtainAuthUserByCode(code);
        if (Judgment.nullOrBlank(weChatUser.getAuthUser())) {
            String state_redirect = curAppConfig.obtainStateRedirect("WX_LOGIN") + "?redirectUri=" + orgin_redirect;
            CoreSvo.putCookie("openId", weChatUser.getOpenid());
            RemexConstants.logger.info((Object)("===================\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\uff0c\u9700\u8981\u767b\u5f55,state_redirect=" + state_redirect + ",=================="));
            return new BsRvo("SUCCESS", "\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\u670d\u52a1\u6b63\u5e38\uff0c\u8be5\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\uff0c\u9700\u8981\u767b\u5f55\u7ed1\u5b9a", null, RemexConstants.ResponseContentType.redirect, state_redirect);
        }
        AuthenticateBtx.placeToken(weChatUser.getAuthUser());
        RemexConstants.logger.info((Object)("===================\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\uff0c\u6b63\u5e38\u8df3\u8f6c,state_redirect=" + orgin_redirect + ",=================="));
        return new BsRvo("SUCCESS", "\u5fae\u4fe1\u83dc\u5355\u56de\u8c03\u670d\u52a1\u6b63\u5e38\uff0c\u7ed1\u5b9a\u7528\u6237\u767b\u5f55\u6210\u529f", null, RemexConstants.ResponseContentType.redirect, orgin_redirect);
    }

    @BusinessService(authLevel=RemexConstants.UserType.ADMIN)
    public BsRvo weixinUsers(DataCvo dataCvo) {
        DbRvo<WeChatUser> userInfos = dataCvo.obtainDbCvo(WeChatUser.class).ready().query();
        return new DataRvo(userInfos);
    }

    @BusinessService(type=BusinessService.ServiceType.AsyncService)
    public BsRvo updateAllUserInfoWithWeChat(AsyncCvo asyncCvo) {
        return new AsyncRvo().start(asyncRvo -> {
            WeChat.getWeChatAppExt().everyWeChatUserOpenId(this::updateUserInfoWithWeChat);
            return asyncRvo;
        });
    }

    @BusinessService
    public BsRvo updateUserInfoWithWeChatByOpenId(String openId) {
        this.updateUserInfoWithWeChat(openId);
        return new BsRvo("SUCCESS", "\u7528\u6237\u5fae\u4fe1\u4fe1\u606f\u66f4\u65b0\uff01", "");
    }

    @BusinessService
    public BsRvo sendMsgByOpenId(String openid, String msgContent) {
        AuthUser curUserInfo = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getOpenid, WhereRuleOper.eq, (Object)openid).ready().queryBean();
        return new BsRvo(WeChat.getWeChatAppExt().sendCustomWeChatMsg(openid, msgContent) ? "SUCCESS" : "FAIL", "\u6d88\u606f\u53d1\u9001");
    }

    @BusinessService
    public Object signJsApiBySHA(String url) {
        return WeChat.getWeChatApp().signJsApiBySHA(url);
    }

    @EventListener
    @Async
    public void dealWeChatEvent(WeChatEvent event) {
        RemexConstants.logger.info((Object)("\u5f02\u6b65\u5904\u7406WeChatEvent\uff0copenId=" + event.getFromUserName()));
        WeChatNotify weChatNotify = new WeChatNotify(event.getMsgType(), event.getFromUserName(), event.getToUserName(), new Date().getTime() / 1000L, event.getEvent(), event.getEventKey(), event.getTicket());
        Database.getSession().store(weChatNotify);
        AuthUser authUser = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getOpenid, WhereRuleOper.eq, (Object)event.getFromUserName()).ready().queryBean();
        if (!Judgment.nullOrBlank(authUser)) {
            authUser.setWeixinLastTime(System.currentTimeMillis() / 1000L);
            Database.getSession().store(authUser);
        }
    }

    @EventListener
    @Async
    public void dealSubscribeForBindUser(WeChatSubscribeEvent event) {
        RemexConstants.logger.info((Object)("\u5f02\u6b65\u5904\u7406WeChatSubscribeEvent\uff0copenId=" + event.getOpenId() + ";userId(sceneKey)=" + event.getSceneKey()));
        String openId = event.getOpenId();
        String userId = event.getSceneKey();
        if (!Judgment.nullOrBlank(event.getSceneKey())) {
            WeiXinService.bindUser(openId, userId);
        }
        WeChat.getWeChatAppExt().sendnewCustomWeChatMsg(openId, "MNG_oY3AIdsyPiURq506J-YNSGtIwlWtRKjBmnjaK6Q");
    }

    @EventListener
    @Async
    public void dealScanEventForBindUserOrWeChatLogin(WeChatScanEvent event) {
        RemexConstants.logger.info((Object)("\u5f02\u6b65\u5904\u7406 WeChatScanEvent\uff0copenId=" + event.getOpenId() + ";eventKey=" + event.getEventKey()));
        if (!weixinLoginQrcodeUrl_SceneId.equals(event.getEventKey()) && !Judgment.nullOrBlank(event.getEventKey())) {
            RemexConstants.logger.info((Object)("\u51c6\u5907\u7ed1\u5b9a\u7528\u6237openId=" + event.getOpenId() + ";eventKey=" + event.getEventKey()));
            WeiXinService.bindUser(event.getOpenId(), event.getEventKey());
        }
    }

    @EventListener
    @Async
    public void dealUnsubscribeForDismissUser(WeChatUnsubscribeEvent event) {
        RemexConstants.logger.info((Object)("\u5f02\u6b65\u5904\u7406 WeChatUnsubscribeEvent\uff0copenId=" + event.getOpenId() + ";userId(sceneKey)=" + event.getSceneKey()));
        WeiXinService.dismissedBindUser(event.getOpenId());
    }

    @EventListener
    @Async
    public void dealWeChatTextEvent(WeChatTextEvent event) {
        WeChatMsg msg = Database.createDbCvo(WeChatMsg.class).filterBy(WeChatMsg::getMsgId, WhereRuleOper.eq, (Object)event.getMsgId()).ready().queryBean();
        if (null == msg) {
            msg = new WeChatMsg();
            msg.setMsgId(event.getMsgId());
            msg.setWxCreateTime(event.getCreateTime() * 1000L);
            msg.setFromUserName(event.getFromUserName());
            msg.setToUserName(WeChat.getWeChatApp().getAppid());
            msg.setContent(event.getContent());
            Database.getSession().store(msg);
        }
    }

    @EventListener
    @Async
    public void dealWeChatClickEvent(WeChatClickEvent event) {
        String msg;
        String eventKey = event.getEventKey();
        if (!Judgment.nullOrBlank(eventKey) && !Judgment.nullOrBlank(msg = WeChat.getWeChatApp().obtainClickEventMsg(eventKey))) {
            WeChat.getWeChatAppExt().sendCustomWeChatMsg(event.getFromUserName(), msg);
        }
    }

    public static boolean bindUser(String openId, String userId) {
        RemexConstants.logger.info((Object)("\u7ed1\u5b9a\u5fae\u4fe1\u7528\u6237\uff0cuserId=" + userId + "\uff1bopenId=" + openId));
        AuthUser user = Database.createDbCvo(AuthUser.class).filterById(userId).ready().queryBean();
        if (null == user) {
            RemexConstants.logger.info((Object)("\u7ed1\u5b9a\u5fae\u4fe1\u7528\u6237\u65f6\uff0c\u6ca1\u6709\u67e5\u8be2\u5230\u7528\u6237\uff0cuserID=" + userId));
            return false;
        }
        return WeiXinService.bindUser(openId, user);
    }

    public static boolean bindUser(String openId, AuthUser user) {
        Assert.notNullAndEmpty(openId, "OPENID_INVALID", "\u7ed1\u5b9a\u5fae\u4fe1\u7528\u6237\u65f6openId\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            boolean openIdUsed = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getOpenid, WhereRuleOper.eq, (Object)openId).ready().query().getRecordCount() > 0;
            RemexConstants.logger.info((Object)("\u901a\u8fc7\u5fae\u4fe1\u7ed1\u5b9a\u7528\u6237\uff0copenId\u7ed1\u5b9a\u72b6\u6001 = " + openIdUsed + "; OpendId=" + openId));
            if (!Judgment.nullOrBlank(user) && !Judgment.nullOrBlank(user.getOpenid()) || openIdUsed) {
                return false;
            }
            WeChatUserInfo weChatUserInfo = WeChat.getWeChatApp().userInfo(openId);
            if (Judgment.nullOrBlank(weChatUserInfo)) {
                return false;
            }
            user.setOpenid(openId);
            user.setUnionid(weChatUserInfo.getUnionid());
            user.setNickname(weChatUserInfo.getNickname());
            user.setSex(weChatUserInfo.getSex());
            user.setCity(weChatUserInfo.getCity());
            user.setCountry(weChatUserInfo.getCountry());
            user.setProvince(weChatUserInfo.getProvince());
            user.setLanguage(weChatUserInfo.getLanguage());
            user.setHeadimgurl(weChatUserInfo.getHeadimgurl());
            user.setSubscribeTime(weChatUserInfo.getSubscribe_time());
            user.setRemark(weChatUserInfo.getRemark());
            user.setGroupid(weChatUserInfo.getGroupid());
            Database.getSession().store(user);
            return true;
        }
        catch (Throwable throwable) {
            RemexConstants.logger.error((Object)"\u7ed1\u5b9a\u7528\u4e8e\u5f02\u5e38\uff01", throwable);
            return false;
        }
    }

    public static boolean dismissedBindUser(String openId) {
        AuthUser user = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getOpenid, WhereRuleOper.eq, (Object)openId).ready().queryBean();
        if (Judgment.nullOrBlank(user)) {
            return false;
        }
        user.setOpenid("");
        user.setNickname("");
        user.setSex("");
        user.setCity("");
        user.setCountry("");
        user.setProvince("");
        user.setLanguage("");
        user.setHeadimgurl("");
        user.setSubscribeTime("");
        user.setUnionid("");
        user.setRemark("");
        user.setGroupid("");
        Database.getSession().store(user);
        return true;
    }

    private WeChatUser updateUserInfoWithWeChat(String openId) {
        WeChatUserInfo weChatUserInfo = WeChat.getWeChatApp().userInfo(openId);
        if (null != weChatUserInfo) {
            WeChatUser curUserInfo = Database.createDbCvo(WeChatUser.class).filterOper(WhereGroupOp.OR).filterBy(WeChatUser::getUnionid, WhereRuleOper.eq, (Object)weChatUserInfo.getUnionid()).filterBy(WeChatUser::getOpenid, WhereRuleOper.eq, (Object)openId).ready().queryBean();
            if (Judgment.nullOrBlank(curUserInfo)) {
                curUserInfo = new WeChatUser();
            }
            ReflectUtil.copyProperties((Object)curUserInfo, (Object)weChatUserInfo, new ReflectUtil.SPFeature[0]);
            curUserInfo.setSubscribeTime(Long.parseLong(weChatUserInfo.getSubscribe_time()));
            Database.getSession().store(curUserInfo).getStatus();
            return curUserInfo;
        }
        return null;
    }

    public static boolean sendTemplateMsg(String openId, String remarkMsg) {
        TemplateMessage templateMessage = new TemplateMessage();
        templateMessage.setTemplate_id((String)((Map)RemexApplication.getBean("weixin")).get("msgTemplate"));
        templateMessage.setTouser(openId);
        TemplateMsg first = new TemplateMsg(remarkMsg, "#8cc474");
        TemplateMsg keyword1 = new TemplateMsg("\u670d\u52a1\u6d88\u606f", "#173177");
        TemplateMsg keyword2 = new TemplateMsg(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), "#173177");
        TemplateMsg remark = new TemplateMsg("\u5982\u6709\u9700\u8981\u53ef\u5fae\u4fe1\u7559\u8a00\uff0c\u6211\u516c\u53f8\u5ba2\u670d\u5c06\u53ca\u65f6\u8054\u7cfb\u60a8\u3002", "#173177");
        LinkedHashMap<String, TemplateMsg> data = new LinkedHashMap<String, TemplateMsg>();
        data.put("first", first);
        data.put("keyword1", keyword1);
        data.put("keyword2", keyword2);
        data.put("remark", remark);
        templateMessage.setData(data);
        return WeChat.getWeChatAppExt().messageTemplateSend(templateMessage);
    }
}

