/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.contrib.service;

import cn.remex.RemexConstants;
import cn.remex.contrib.appbeans.DataCvo;
import cn.remex.contrib.appbeans.DataRvo;
import cn.remex.contrib.auth.AuthenticateBtx;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.MapHelper;
import cn.remex.db.Database;
import cn.remex.db.DbCvo;
import cn.remex.db.DbRvo;
import cn.remex.db.model.SysCode;
import cn.remex.db.model.SysMenu;
import cn.remex.db.model.SysUri;
import cn.remex.db.model.cert.AuthRole;
import cn.remex.db.model.cert.AuthUser;
import cn.remex.db.model.cert.Organization;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.connection.RDBSpaceConfig;
import cn.remex.db.sql.WhereRuleOper;
import cn.remex.web.aspect.BusinessServiceAspect;
import cn.remex.web.service.BsRvo;
import cn.remex.web.service.BusinessService;
import java.util.List;
import org.logicalcobwebs.proxool.ProxoolDataSource;

@BusinessService
public class AdminService {
    @BusinessService(name="\u91cd\u7f6e\u6743\u9650\u660e\u7ec6\u8bbe\u7f6e")
    public BsRvo resetSysUris() {
        List<SysUri> sysUris = AuthenticateBtx.resetAuthority();
        return new BsRvo("SUCCESS", "\u91cd\u6784\u9ed8\u8ba4URI\u6743\u9650\u6210\u529f,\u7cfb\u7edf\u4e0d\u4f1a\u5220\u9664\u624b\u52a8\u914d\u7f6e\u7684URI,\u4f46\u4f1a\u5c06\u7cfb\u7edf\u9ed8\u8ba4\u7684URI\u4fe1\u606f\u66f4\u65b0", sysUris);
    }

    @BusinessService(name="\u91cd\u6784\u6570\u636e\u7ed3\u6784")
    public BsRvo resetDb(boolean resetDb) {
        RDBManager.reset(resetDb);
        return new BsRvo("SUCCESS", "OK", resetDb ? "\u91cd\u6784\u6570\u636e\u5e93\u6210\u529f" : "\u6e05\u7406\u6570\u636e\u5e93\u7f13\u5b58\u6210\u529f");
    }

    @BusinessService(name="\u91cd\u7f6e\u670d\u52a1\u7f13\u5b58", authRoles={BusinessService.ServiceRole.admin})
    public BsRvo databaseInfo() {
        return new BsRvo("SUCCESS", "OK", MapHelper.toMap("driverUrl", ((ProxoolDataSource)RDBManager.getLocalSpaceConfig().getDataSource()).getDriverUrl()));
    }

    @BusinessService(name="\u91cd\u7f6e\u670d\u52a1\u7f13\u5b58", authRoles={BusinessService.ServiceRole.admin})
    public BsRvo resetBsCache() {
        BusinessServiceAspect.resetCache();
        return new BsRvo("SUCCESS", "OK");
    }

    @BusinessService(name="\u83b7\u53d6\u6570\u636ebean\u5217\u8868")
    public Object ormBeans(String spaceName) {
        RDBSpaceConfig spaceConfig = RDBManager.getLocalSpaceConfig(Judgment.nullOrBlank(spaceName) ? RDBManager.DEFAULT_SPACE : spaceName);
        return spaceConfig.getOrmBeans();
    }

    @BusinessService(name="\u83b7\u53d6\u89d2\u8272\u5217\u8868", authRoles={BusinessService.ServiceRole.admin})
    public BsRvo roles(DataCvo bsCvo) {
        DbCvo<AuthRole> dbCvo = bsCvo.obtainDbCvo(AuthRole.class).withBase();
        DbRvo<AuthRole> dbRvo = dbCvo.ready().query();
        return new DataRvo(dbRvo);
    }

    @BusinessService(name="\u4fdd\u5b58\u89d2\u8272")
    public BsRvo saveRole(AuthRole role) {
        DbRvo<AuthRole> dbRvo = Database.getSession().store(role);
        return new BsRvo("SUCCESS", "", role);
    }

    @BusinessService(name="\u5220\u9664\u89d2\u8272")
    public BsRvo delRole(AuthRole role) {
        Assert.isTrue(!Judgment.nullOrBlank(role.getName()) && !"root,user,admin".contains(role.getName().trim()), "FAIL", "\u7cfb\u7edf\u6838\u5fc3\u89d2\u8272\u4e0d\u80fd\u5220\u9664\uff01");
        DbRvo<AuthRole> dbRvo = Database.getSession().delete(role);
        return new BsRvo(dbRvo.getEffectRowCount() == 1 ? "SUCCESS" : "FAIL", dbRvo.getMsg());
    }

    @BusinessService(name="\u5220\u9664\u89d2\u8272")
    public BsRvo roleUris(String pk) {
        return new DataRvo(Database.createDbCvo(AuthRole.class).ready().queryCollectionField(AuthRole::getSysUris, pk));
    }

    @BusinessService(name="\u89d2\u8272\u7684\u83dc\u5355")
    public BsRvo roleMenus(String pk) {
        return new DataRvo(Database.createDbCvo(AuthRole.class).ready().queryCollectionField(AuthRole::getMenus, pk));
    }

    @BusinessService(name="\u89d2\u8272\u5f52\u5c5e\u7684\u7ec4\u7ec7\u673a\u6784")
    public BsRvo roleOrganizations(String pk) {
        return new DataRvo(Database.createDbCvo(AuthRole.class).ready().queryCollectionField(AuthRole::getOrganizations, pk));
    }

    @BusinessService(name="\u7ec4\u7ec7\u673a\u6784\u660e\u7ec6")
    public BsRvo organizations(DataCvo bsCvo) {
        DbCvo<Organization> dbCvo = bsCvo.obtainDbCvo(Organization.class);
        return new DataRvo(dbCvo.ready().query());
    }

    @BusinessService(name="\u529f\u80fd\u6743\u9650\u660e\u7ec6")
    public BsRvo uris(DataCvo bsCvo) {
        DbCvo<SysUri> dbCvo = bsCvo.obtainDbCvo(SysUri.class);
        return new DataRvo(dbCvo.ready().query());
    }

    @BusinessService(name="\u7528\u6237\u660e\u7ec6")
    public BsRvo users(DataCvo bsCvo) {
        DbCvo<AuthUser> dbCvo = bsCvo.obtainDbCvo(AuthUser.class);
        return new DataRvo(dbCvo.ready().query());
    }

    @BusinessService(name="\u4fdd\u5b58\u7528\u6237")
    public BsRvo saveUser(AuthUser user) {
        if (Judgment.nullOrBlank(user.getId())) {
            Assert.isNull(Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getUsername, WhereRuleOper.eq, (Object)user.getUsername()).ready().queryBean(), "FAIL", "\u8be5\u7528\u6237\u5df2\u7ecf\u88ab\u6ce8\u518c!");
        }
        if (user.getUserType() == null) {
            user.setUserType(RemexConstants.UserType.C_USER);
        }
        DbRvo<AuthUser> dbRvo = Database.getSession().store(user);
        return new BsRvo("SUCCESS", "OK", user);
    }

    @BusinessService(name="\u5220\u9664\u89d2\u8272")
    public BsRvo delUser(AuthUser role) {
        AuthUser au = Database.createDbCvo(AuthUser.class).filterById(role.getId()).ready().queryBean();
        Assert.isTrue(!"admin".equals(au.getUsername()), "FAIL", "\u7cfb\u7edf\u7528\u6237\u4e0d\u5f97\u5220\u9664\uff01");
        DbRvo<AuthUser> dbRvo = Database.getSession().delete(role);
        return new BsRvo(dbRvo.getEffectRowCount() == 1 ? "SUCCESS" : "FAIL", dbRvo.getMsg());
    }

    @BusinessService(name="\u6307\u5b9a\u7528\u6237\u7684\u89d2\u8272")
    public BsRvo rolesOfUser(String pk) {
        return new DataRvo(Database.createDbCvo(AuthUser.class).ready().queryCollectionField(AuthUser::getRoles, pk));
    }

    @BusinessService(name="\u4fdd\u5b58\u89d2\u8272")
    public BsRvo saveMenu(SysMenu menu) {
        DbRvo<SysMenu> dbRvo = Database.getSession().store(menu);
        return new BsRvo("SUCCESS", "OK", menu);
    }

    @BusinessService(name="\u5220\u9664\u83dc\u5355")
    public BsRvo delMenu(SysMenu menu) {
        DbRvo<SysMenu> dbRvo = Database.getSession().delete(menu);
        return new BsRvo(dbRvo.getEffectRowCount() == 1 ? "SUCCESS" : "FAIL", dbRvo.getMsg());
    }

    @BusinessService(name="\u83dc\u5355\u5217\u8868")
    public BsRvo menus(DataCvo bsCvo) {
        DbCvo<SysMenu> dbCvo = bsCvo.obtainDbCvo(SysMenu.class).withBase().withModel(SysMenu::getSupMenu, s -> s.withModel(SysMenu::getSupMenu, s1 -> s1.withModel(SysMenu::getSupMenu)));
        return new DataRvo(dbCvo.ready().query());
    }

    @BusinessService(name="\u6570\u636e\u5b57\u5178\u5217\u8868")
    public DataRvo sysCode(DataCvo dataCvo) {
        DbCvo<SysCode> dbCvo = dataCvo.obtainDbCvo(SysCode.class).withBase();
        return new DataRvo(dbCvo.ready().query());
    }

    @BusinessService(name="\u4fdd\u5b58\u5b57\u5178")
    public SysCode saveSysCode(SysCode sysCode) {
        DbRvo<SysCode> dbRvo = Database.getSession().store(sysCode);
        return sysCode;
    }

    @BusinessService(name="\u5220\u9664\u5b57\u5178")
    public BsRvo delSysCode(SysCode sysCode) {
        DbRvo<SysCode> dbRvo = Database.getSession().delete(sysCode);
        return new BsRvo(dbRvo.getEffectRowCount() == 1 ? "SUCCESS" : "FAIL", dbRvo.getMsg());
    }
}

