/*
 * Decompiled with CFR 0.152.
 */
package cn.remex.contrib.auth;

import cn.remex.RemexConstants;
import cn.remex.contrib.auth.LoginAuthEvent;
import cn.remex.contrib.auth.LogoutAuthEvent;
import cn.remex.contrib.service.DataService;
import cn.remex.core.CoreSvo;
import cn.remex.core.RemexApplication;
import cn.remex.core.reflect.ReflectUtil;
import cn.remex.core.util.Assert;
import cn.remex.core.util.Judgment;
import cn.remex.core.util.Param;
import cn.remex.core.util.RequestHelper;
import cn.remex.db.Database;
import cn.remex.db.model.SysUri;
import cn.remex.db.model.cert.AuthRole;
import cn.remex.db.model.cert.AuthUser;
import cn.remex.db.rsql.connection.RDBManager;
import cn.remex.db.rsql.model.ModelableImpl;
import cn.remex.db.sql.SqlColumn;
import cn.remex.db.sql.WhereRuleOper;
import cn.remex.web.service.BusinessService;
import cn.remex.web.service.ServiceFactory;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AuthenticateBtx {
    private static final String KEY_UID = "UID";
    private static final String KEY_TKN = "TKN";
    private static final String KEY_TS = "TS";
    private static Map<String, AuthUser> users = new HashMap<String, AuthUser>();
    private static Map<String, Map<String, ?>> SysUriMapToRole = null;

    public static boolean checkToken() {
        String UID = CoreSvo.valCookieValue(KEY_UID);
        String TS = CoreSvo.valCookieValue(KEY_TS);
        String TKN = CoreSvo.valCookieValue(KEY_TKN);
        return !Judgment.nullOrBlank(UID) && !Judgment.nullOrBlank(TS) && !Judgment.nullOrBlank(TKN) && TKN.equals(AuthenticateBtx.generateToken(UID, TS));
    }

    public static Map<String, String> placeToken(AuthUser authUser) {
        String username = authUser.getUsername();
        String TS = String.valueOf(LocalTime.now().hashCode());
        String UID = username;
        String TKN = AuthenticateBtx.generateToken(UID, TS);
        CoreSvo.putCookie(KEY_UID, UID);
        CoreSvo.putCookie(KEY_TS, TS);
        CoreSvo.putCookie(KEY_TKN, TKN);
        HashMap<String, String> tokeMap = new HashMap<String, String>();
        tokeMap.put(KEY_UID, UID);
        tokeMap.put(KEY_TS, TS);
        tokeMap.put(KEY_TKN, TKN);
        AuthenticateBtx.refreshCurUser(username);
        RemexApplication.publishEvent(new LoginAuthEvent("LoginAuthEvent", authUser));
        return tokeMap;
    }

    public static void clearToken() {
        AuthUser authUser = AuthenticateBtx.obtainCurUser();
        CoreSvo.putCookie(KEY_UID, null);
        CoreSvo.putCookie(KEY_TS, null);
        CoreSvo.putCookie(KEY_TKN, null);
        RemexApplication.publishEvent(new LogoutAuthEvent("LogoutAuthEvent", authUser));
    }

    private static String generateToken(String username, String TS) {
        String IP = RequestHelper.getClientIP((HttpServletRequest)CoreSvo.valLocal("CORESVO_HTTP_REQUEST"));
        return String.valueOf(KEY_UID.hashCode()) + username.hashCode() + "-" + KEY_TS.hashCode() + TS.hashCode() + "-" + IP.hashCode();
    }

    public static void refreshCurUser() {
        String username = CoreSvo.valCookieValue(KEY_UID);
        if (username != null) {
            AuthenticateBtx.refreshCurUser(username);
        }
    }

    private static void refreshCurUser(String username) {
        if (username != null) {
            AuthUser curUser = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getUsername, WhereRuleOper.eq, (Object)username).withList(AuthUser::getRoles).rowCount(100000).ready().query().obtainBean();
            users.remove(username);
            users.put(username, curUser);
        }
    }

    public static AuthUser obtainCurUser() {
        String username;
        try {
            username = CoreSvo.valCookieValue(KEY_UID);
        }
        catch (Throwable e) {
            RemexConstants.logger.error((Object)("\u4ececookie\u4e2d\u83b7\u53d6username\u5931\u8d25\uff0c\u4e00\u822c\u53d1\u751f\u518d\u6d4b\u8bd5\u7528\u4f8b\u4e2d\uff0c\u6b64\u65f6\u8fd4\u56denull\u7528\u6237\u3002msg=" + e.toString()));
            return null;
        }
        AuthUser curUser = users.get(username);
        if (null == curUser && !Judgment.nullOrBlank(username)) {
            List<AuthUser> ret = Database.createDbCvo(AuthUser.class).filterBy(AuthUser::getUsername, WhereRuleOper.eq, (Object)username).withBase().withList(AuthUser::getRoles, SqlColumn::withBase).rowCount(100000).ready().query().obtainBeans();
            Assert.isTrue(ret.size() <= 1, "FAIL", "\u7528\u6237\u6570\u636e\u51fa\u73b0\u91cd\u590d\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            if (ret.size() == 1) {
                curUser = ret.get(0);
                users.put(username, curUser);
            }
        }
        return curUser;
    }

    public static Map<String, Map<String, ?>> obtainSysUriMapToRole() {
        if (null != SysUriMapToRole) {
            return SysUriMapToRole;
        }
        AuthRole root = Database.createDbCvo(AuthRole.class).filterBy(ModelableImpl::getName, WhereRuleOper.eq, (Object)"root").ready().query().obtainBean();
        SysUriMapToRole = new HashMap();
        Database.createDbCvo(SysUri.class).withList(SysUri::getRoles).rowCount(10000).ready().query().obtainObjects(SysUri.class).forEach(sysUri -> {
            Map<String, ?> curRoles = SysUriMapToRole.get(sysUri.getUri());
            if (null == curRoles) {
                curRoles = new HashMap();
                SysUriMapToRole.put(sysUri.getUri(), curRoles);
                curRoles.put(root.getId(), null);
            }
            Map<String, ?> finalCurRoles = curRoles;
            if (null != sysUri.getRoles()) {
                sysUri.getRoles().forEach(role -> finalCurRoles.put(role.getId(), null));
            }
        });
        return SysUriMapToRole;
    }

    public static boolean isRootUser() {
        AuthUser authUser = AuthenticateBtx.obtainCurUser();
        if (authUser != null) {
            for (int i = 0; i < authUser.getRoles().size(); ++i) {
                if (!"root".equals(authUser.getRoles().get(i).getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<SysUri> resetAuthority() {
        SysUriMapToRole = new HashMap();
        users = new HashMap<String, AuthUser>();
        ArrayList<SysUri> sysUris = new ArrayList<SysUri>();
        Param<Object> bsan = new Param<Object>(null);
        ServiceFactory.getBsMap().forEach((bsName, v) -> ReflectUtil.getAllMethods(v).forEach((methodName, sameNameMethods) -> sameNameMethods.stream().filter(m -> {
            bsan.param = ReflectUtil.getAnnotation(m, BusinessService.class);
            return bsan.param != null;
        }).forEach(m -> {
            SysUri sysUri = new SysUri();
            sysUri.setUri("/" + bsName + "/" + methodName);
            sysUri.setUriName(((BusinessService)bsan.param).name());
            sysUri.setUriDesc(((BusinessService)bsan.param).desc());
            sysUris.add(sysUri);
        })));
        RDBManager.getLocalSpaceConfig().getOrmBeans().forEach((beanName, beanClass) -> ReflectUtil.getAllMethods(DataService.class).forEach((methodName, sameNameMethods) -> sameNameMethods.stream().filter(m -> {
            bsan.param = ReflectUtil.getAnnotation(m, BusinessService.class);
            return bsan.param != null;
        }).forEach(m -> {
            SysUri sysUri = new SysUri();
            sysUri.setUri("/" + DataService.class.getSimpleName() + "/" + beanName + "/" + methodName);
            sysUris.add(sysUri);
        })));
        sysUris.forEach(sysUri -> Database.createDbCvo(SysUri.class).withBase().ready().store((SysUri)sysUri));
        return sysUris;
    }

    public static SysUri saveSysUri(String uri, BusinessService bsan) {
        BusinessService.ServiceRole[] roles;
        SysUri sysUri = Database.select(SysUri.class).filterBy(SysUri::getUri, WhereRuleOper.eq, (Object)uri).withBase().execute().obtainBean();
        if (null == sysUri) {
            sysUri = new SysUri();
        }
        sysUri.setUri(uri);
        sysUri.setUriName(bsan.name());
        sysUri.setUriDesc(bsan.desc());
        sysUri.setRoles(new ArrayList<AuthRole>());
        for (BusinessService.ServiceRole role : roles = bsan.authRoles()) {
            AuthRole authRole = AuthenticateBtx.checkAndSaveRole(role);
            sysUri.getRoles().add(authRole);
        }
        Database.insertOrUpdate(SysUri.class).assignBean(sysUri).execute().assertEffectOneRow("FAIL", "\u6839\u636eBusinessService\u6ce8\u89e3\u81ea\u52a8\u751f\u6210\u8d44\u6e90\u53ca\u5176\u5bf9\u5e94\u89d2\u8272\u6743\u9650\u5173\u7cfb\u65f6\u53d1\u751f\u9519\u8bef");
        return sysUri;
    }

    public static AuthRole checkAndSaveRole(BusinessService.ServiceRole serviceRole) {
        AuthRole curRole = null;
        if (serviceRole != null) {
            int id = serviceRole.getId();
            Assert.isTrue(id >= 1000, "FAIL", "\u89d2\u8272\u7f16\u53f7\u4e0d\u80fd\u5c0f\u4e8e1000");
            curRole = Database.select(AuthRole.class).filterBy(ModelableImpl::getId, WhereRuleOper.eq, (Object)id).withBase().execute().obtainBean();
            if (null == curRole) {
                curRole = new AuthRole();
                curRole.assignNewId(String.valueOf(id));
            }
            curRole.setName(serviceRole.name());
            Database.insertOrUpdate(AuthRole.class).assignBean(curRole).execute().assertEffectOneRow("FAIL", "\u6839\u636eBusinessService\u6ce8\u89e3\u81ea\u52a8\u751f\u6210\u89d2\u8272\u65f6\u53d1\u751f\u9519\u8bef");
        }
        return curRole;
    }
}

