/*
 * Decompiled with CFR 0.152.
 */
package cn.mingfer.benchmark.reporter;

import cn.mingfer.benchmark.Benchmark;
import cn.mingfer.benchmark.reporter.ConsoleReporter;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Reporter {
    protected final AtomicLong successCounts = new AtomicLong(0L);
    protected final AtomicLong failedCounts = new AtomicLong(0L);
    protected final AtomicLong timeConsuming = new AtomicLong(0L);
    protected volatile long maxTimeConsuming = 0L;
    protected volatile long minTimeConsuming = Integer.MAX_VALUE;
    protected volatile long startTimestamp = 0L;

    public static Reporter console() {
        return ConsoleReporter.CONSOLE;
    }

    public void reportSuccess(long timeout) {
        this.successCounts.incrementAndGet();
        this.timeConsuming.addAndGet(timeout / 1000L);
        if (timeout / 1000L < this.minTimeConsuming) {
            this.minTimeConsuming = timeout / 1000L;
        }
        if (timeout / 1000L > this.maxTimeConsuming) {
            this.maxTimeConsuming = timeout / 1000L;
        }
    }

    public void reportFailed(Throwable throwable) {
        this.failedCounts.incrementAndGet();
        throwable.printStackTrace();
    }

    public void reportStart(long timestamp, Benchmark<?> benchmark) {
        this.startTimestamp = timestamp;
        this.successCounts.set(0L);
        this.failedCounts.set(0L);
        this.timeConsuming.set(0L);
        this.minTimeConsuming = Integer.MAX_VALUE;
        this.maxTimeConsuming = 0L;
    }

    public abstract void statistics(Benchmark<?> var1);
}

