/*
 * Decompiled with CFR 0.152.
 */
package cn.mingfer.benchmark;

import cn.mingfer.benchmark.Benchmark;
import cn.mingfer.benchmark.Executable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public class TimingBenchmark
extends Benchmark<TimingBenchmark> {
    private final Duration duration;
    private Duration warmUp = Duration.ZERO;

    public TimingBenchmark warmUp(Duration warmUp) {
        this.warmUp = Objects.requireNonNull(warmUp);
        return this;
    }

    protected TimingBenchmark(Duration duration, int threads, Executable executable) {
        super(threads, executable);
        this.duration = Objects.requireNonNull(duration);
    }

    @Override
    protected CountDownLatch prepare(CountDownLatch latch) {
        CountDownLatch wait = new CountDownLatch(this.threads);
        CountDownLatch warmUpWait = new CountDownLatch(this.threads);
        long ms = this.warmUp.toMillis();
        for (int i = 0; i < this.threads; ++i) {
            warmUpWait.countDown();
            this.service.execute(() -> {
                try {
                    warmUpWait.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < ms) {
                    this.execute();
                }
                try {
                    wait.countDown();
                    wait.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < this.duration.toMillis()) {
                    this.execute();
                }
                latch.countDown();
            });
        }
        return wait;
    }
}

