/*
 * Decompiled with CFR 0.152.
 */
package cn.mingfer.benchmark;

import cn.mingfer.benchmark.Args;
import cn.mingfer.benchmark.CountBenchmark;
import cn.mingfer.benchmark.Executable;
import cn.mingfer.benchmark.TimingBenchmark;
import cn.mingfer.benchmark.reporter.ConsoleReporter;
import cn.mingfer.benchmark.reporter.Reporter;
import java.time.Duration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public abstract class Benchmark<T> {
    protected final Set<Reporter> reporters = new HashSet<Reporter>();
    protected final Executable executable;
    protected final ExecutorService service;
    protected final int threads;
    private String name = "";

    public static TimingBenchmark ofTiming(Duration duration, int threads, Executable executable) {
        return new TimingBenchmark(duration, threads, executable);
    }

    public static CountBenchmark ofCount(int count, int threads, Executable executable) {
        return new CountBenchmark(count, threads, executable);
    }

    public T addReporter(Reporter reporter) {
        this.reporters.add(Objects.requireNonNull(reporter));
        return (T)this;
    }

    public void benchmark() {
        try {
            CountDownLatch downLatch = new CountDownLatch(this.threads);
            if (this.reporters.isEmpty()) {
                this.reporters.add(new ConsoleReporter());
            }
            CountDownLatch prepared = this.prepare(downLatch);
            prepared.await();
            this.reporters.forEach(reporter -> reporter.reportStart(System.currentTimeMillis(), this));
            downLatch.await();
            this.service.shutdownNow();
            this.reporters.forEach(reporter -> reporter.statistics(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String name() {
        return this.name;
    }

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public int threads() {
        return this.threads;
    }

    protected Benchmark(int threads, Executable executable) {
        this.threads = Args.positive(threads, "threads");
        this.executable = Objects.requireNonNull(executable);
        this.service = Executors.newFixedThreadPool(threads, new ThreadFactory(){
            int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "simple-benchmark-thread-" + this.count++);
            }
        });
    }

    protected abstract CountDownLatch prepare(CountDownLatch var1);

    protected void execute() {
        try {
            long start = System.nanoTime();
            this.executable.execute();
            this.reporters.forEach(reporter -> reporter.reportSuccess(System.nanoTime() - start));
        }
        catch (Throwable throwable) {
            this.reporters.forEach(reporter -> reporter.reportFailed(throwable));
        }
    }
}

