/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.opc.ua.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.UsernameProvider;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpcUaUtils.class);

    private OpcUaUtils() {
    }

    public static OpcUaClient getClient(String url, String username, String password) {
        Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "security");
        try {
            Files.createDirectories(securityTempDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create security dir: " + String.valueOf(securityTempDir), e);
        }
        Object identityProvider = username == null ? new AnonymousProvider() : new UsernameProvider(username, password);
        try {
            OpcUaClient opcUaClient = OpcUaClient.create((String)url, endpoints -> endpoints.stream().findFirst(), arg_0 -> OpcUaUtils.lambda$getClient$1((IdentityProvider)identityProvider, arg_0));
            opcUaClient.connect().get();
            return opcUaClient;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void showItemList(String url, String username, String password) {
        OpcUaUtils.showItemList(OpcUaUtils.getClient(url, username, password));
    }

    public static void showItemList(OpcUaClient client) {
        OpcUaUtils.showItemList(client, Identifiers.RootFolder);
    }

    public static void showItemList(OpcUaClient client, NodeId nodeId) {
        OpcUaUtils.showItemList(client, nodeId, "");
    }

    private static void showItemList(OpcUaClient client, NodeId nodeId, String prefix) {
        try {
            List nodes = client.getAddressSpace().browseNodes(nodeId);
            for (UaNode node : nodes) {
                QualifiedName browseName = node.getBrowseName();
                String name = prefix.isEmpty() ? browseName.getName() : prefix + "." + browseName.getName();
                String namespaceIndex = browseName.getNamespaceIndex().toString();
                log.info("{}[{}]", (Object)name, (Object)namespaceIndex);
                OpcUaUtils.showItemList(client, node.getNodeId(), name);
            }
        }
        catch (Exception e) {
            log.error("Browsing nodeId={} failed: {}", new Object[]{nodeId, e.getMessage(), e});
        }
    }

    public static void showItemTree(String url, String username, String password) {
        OpcUaUtils.showItemTree(OpcUaUtils.getClient(url, username, password));
    }

    public static void showItemTree(OpcUaClient client) {
        OpcUaUtils.showItemTree(client, Identifiers.RootFolder);
    }

    public static void showItemTree(OpcUaClient client, NodeId nodeId) {
        OpcUaUtils.showItemTree(client, nodeId, "");
    }

    private static void showItemTree(OpcUaClient client, NodeId nodeId, String prefix) {
        try {
            List nodes = client.getAddressSpace().browseNodes(nodeId);
            for (int i = 0; i < nodes.size(); ++i) {
                UaNode node = (UaNode)nodes.get(i);
                QualifiedName browseName = node.getBrowseName();
                String name = i < nodes.size() - 1 ? prefix + "\u251c\u2500\u2500 " + browseName.getName() : prefix + "\u2514\u2500\u2500 " + browseName.getName();
                String namespaceIndex = browseName.getNamespaceIndex().toString();
                log.info("{}[{}]", (Object)name, (Object)namespaceIndex);
                OpcUaUtils.showItemTree(client, node.getNodeId(), prefix + "\u2502   ");
            }
        }
        catch (Exception e) {
            log.error("Browsing nodeId={} failed: {}", new Object[]{nodeId, e.getMessage(), e});
        }
    }

    private static /* synthetic */ OpcUaClientConfig lambda$getClient$1(IdentityProvider identityProvider, OpcUaClientConfigBuilder configBuilder) {
        return configBuilder.setApplicationName(LocalizedText.english((String)"Atom Opc Ua Client")).setApplicationUri("urn:atom:opc:ua:client").setIdentityProvider(identityProvider).setRequestTimeout(UInteger.valueOf((int)5000)).build();
    }
}

