/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.opc.ua.config;

import cn.mindit.atom.core.util.JsonUtils;
import cn.mindit.atom.opc.ua.OpcUaConsumer;
import cn.mindit.atom.opc.ua.OpcUaConsumerProcessor;
import cn.mindit.atom.opc.ua.OpcUaSubscriber;
import cn.mindit.atom.opc.ua.config.OpcUaProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.UsernameProvider;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedDataItem;
import org.eclipse.milo.opcua.sdk.client.subscriptions.ManagedSubscription;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;

@Configuration
public class OpcUaConfiguration
implements ApplicationListener<ApplicationStartedEvent>,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpcUaConfiguration.class);
    private final OpcUaProperties opcUaProperties;
    private final List<OpcUaSubscriber> opcUaSubscribers;

    public void onApplicationEvent(@NonNull ApplicationStartedEvent event) {
        List<OpcUaProperties.OpcUaInstance> instances = this.opcUaProperties.getInstances();
        if (instances == null || instances.isEmpty()) {
            return;
        }
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        Map<String, List<OpcUaConsumer>> consumerMap = OpcUaConsumerProcessor.processConsumerMap(applicationContext, this.opcUaProperties, this.opcUaSubscribers);
        Path securityTempDir = this.opcUaProperties.getCertificatePath() == null ? Paths.get(System.getProperty("java.io.tmpdir"), "security") : Paths.get(this.opcUaProperties.getCertificatePath(), new String[0]);
        try {
            Files.createDirectories(securityTempDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create security dir: " + String.valueOf(securityTempDir), e);
        }
        for (OpcUaProperties.OpcUaInstance instance : instances) {
            if (!instance.getEnabled().booleanValue()) continue;
            try {
                Object identityProvider = instance.getUsername() == null ? new AnonymousProvider() : new UsernameProvider(instance.getUsername(), instance.getPassword());
                OpcUaClient opcUaClient = OpcUaClient.create((String)instance.getUrl(), endpoints -> endpoints.stream().findFirst(), arg_0 -> OpcUaConfiguration.lambda$onApplicationEvent$1((IdentityProvider)identityProvider, arg_0));
                opcUaClient.connect().get();
                List<OpcUaConsumer> consumers = consumerMap.get(instance.getId());
                if (consumers == null || consumers.isEmpty()) continue;
                ManagedSubscription subscription = ManagedSubscription.create((OpcUaClient)opcUaClient);
                for (OpcUaConsumer consumer : consumers) {
                    String[] items = consumer.getItems();
                    if (items == null || items.length == 0) continue;
                    int[] namespaceIndices = consumer.getNamespaceIndices();
                    for (int i = 0; i < items.length; ++i) {
                        int namespaceIndex = namespaceIndices[i];
                        String item = items[i];
                        NodeId nodeId = new NodeId(namespaceIndex, item);
                        ManagedDataItem dataItem = subscription.createDataItem(nodeId);
                        dataItem.addDataValueListener(dataValue -> {
                            if (log.isDebugEnabled()) {
                                log.debug("OPC UA consumer item:{}, value:{}", (Object)item, dataValue);
                            }
                            if (dataValue.getStatusCode() != null && dataValue.getStatusCode().isGood()) {
                                String value = JsonUtils.toJson((Object)dataValue.getValue().getValue());
                                consumer.getConsumer().accept(item, value);
                            }
                        });
                    }
                }
                beanFactory.registerSingleton("opcUaClient-" + instance.getId(), (Object)opcUaClient);
            }
            catch (Exception e) {
                throw new RuntimeException("OPC UA connect error: " + e.getMessage(), e);
            }
        }
    }

    public int getOrder() {
        return this.opcUaProperties.getOrder();
    }

    @Generated
    public OpcUaConfiguration(OpcUaProperties opcUaProperties, List<OpcUaSubscriber> opcUaSubscribers) {
        this.opcUaProperties = opcUaProperties;
        this.opcUaSubscribers = opcUaSubscribers;
    }

    private static /* synthetic */ OpcUaClientConfig lambda$onApplicationEvent$1(IdentityProvider identityProvider, OpcUaClientConfigBuilder configBuilder) {
        return configBuilder.setApplicationName(LocalizedText.english((String)"Atom Opc Ua Client")).setApplicationUri("urn:atom:opc:ua:client").setIdentityProvider(identityProvider).setRequestTimeout(UInteger.valueOf((int)5000)).build();
    }
}

