/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.opc.ua;

import cn.mindit.atom.core.util.JsonUtils;
import cn.mindit.atom.opc.ua.config.OpcUaProperties;
import lombok.Generated;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class OpcUaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpcUaService.class);
    private final ApplicationContext applicationContext;
    private final OpcUaProperties opcUaProperties;

    public String readItem(int namespaceIndex, String item) {
        return this.readItem(this.opcUaProperties.getId(), namespaceIndex, item);
    }

    public String readItem(String id, int namespaceIndex, String item) {
        OpcUaClient client = (OpcUaClient)this.applicationContext.getBean("opcUaClient-" + id, OpcUaClient.class);
        NodeId nodeId = new NodeId(namespaceIndex, item);
        try {
            DataValue dataValue = (DataValue)client.readValue(0.0, TimestampsToReturn.Neither, nodeId).get();
            return JsonUtils.toJson((Object)dataValue.getValue().getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeItem(int namespaceIndex, String item, Object value) {
        this.writeItem(this.opcUaProperties.getId(), namespaceIndex, item, value);
    }

    public void writeItem(String id, int namespaceIndex, String item, Object value) {
        OpcUaClient client = (OpcUaClient)this.applicationContext.getBean("opcUaClient-" + id, OpcUaClient.class);
        NodeId nodeId = new NodeId(namespaceIndex, item);
        DataValue newValue = new DataValue(new Variant(value));
        client.writeValue(nodeId, newValue);
    }

    @Generated
    public OpcUaService(ApplicationContext applicationContext, OpcUaProperties opcUaProperties) {
        this.applicationContext = applicationContext;
        this.opcUaProperties = opcUaProperties;
    }
}

