/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.opc.ua;

import cn.mindit.atom.opc.ua.OpcUaConsumer;
import cn.mindit.atom.opc.ua.OpcUaListenerProcessor;
import cn.mindit.atom.opc.ua.OpcUaSubscriber;
import cn.mindit.atom.opc.ua.config.OpcUaProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class OpcUaConsumerProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpcUaConsumerProcessor.class);

    public static Map<String, List<OpcUaConsumer>> processConsumerMap(ConfigurableApplicationContext applicationContext, OpcUaProperties properties, List<OpcUaSubscriber> subscribers) {
        HashMap<String, List<OpcUaConsumer>> consumerMap = new HashMap<String, List<OpcUaConsumer>>();
        OpcUaConsumerProcessor.processListener(consumerMap, applicationContext, properties);
        OpcUaConsumerProcessor.processSubscriber(consumerMap, subscribers, properties);
        return consumerMap;
    }

    private static void processListener(Map<String, List<OpcUaConsumer>> consumerMap, ConfigurableApplicationContext applicationContext, OpcUaProperties properties) {
        OpcUaListenerProcessor processor = (OpcUaListenerProcessor)applicationContext.getBean(OpcUaListenerProcessor.class);
        List<OpcUaConsumer> consumers = processor.getConsumers();
        if (consumers == null || consumers.isEmpty()) {
            return;
        }
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        BeanExpressionContext expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)beanFactory, null);
        BeanExpressionResolver expressionResolver = beanFactory.getBeanExpressionResolver();
        for (OpcUaConsumer consumer : consumers) {
            String id = consumer.getId();
            if (id == null || id.isEmpty()) {
                consumer.setId(properties.getId());
            }
            String[] items = OpcUaConsumerProcessor.processExpression(consumer.getItems(), beanFactory, expressionContext, expressionResolver);
            consumer.setItems(items);
            consumer.initialize();
            List list = consumerMap.computeIfAbsent(consumer.getId(), k -> new ArrayList());
            list.add(consumer);
        }
    }

    private static String[] processExpression(String[] items, ConfigurableListableBeanFactory beanFactory, BeanExpressionContext expressionContext, BeanExpressionResolver expressionResolver) {
        if (items == null || items.length == 0) {
            return null;
        }
        if (expressionResolver != null) {
            ArrayList<String> newItems = new ArrayList<String>();
            for (String item : items) {
                Object object = expressionResolver.evaluate(beanFactory.resolveEmbeddedValue(item), expressionContext);
                if (object == null) {
                    throw new IllegalArgumentException("OPC UA item must not be null");
                }
                if (object instanceof String) {
                    String str = (String)object;
                    newItems.add(str);
                    continue;
                }
                if (object instanceof String[]) {
                    String[] strs;
                    for (String str : strs = (String[])object) {
                        if (str == null) {
                            throw new IllegalArgumentException("OPC UA item must not be null");
                        }
                        newItems.add(str);
                    }
                    continue;
                }
                throw new IllegalArgumentException("OPC UA item must be String or String[]");
            }
            items = newItems.toArray(new String[0]);
        }
        return items;
    }

    private static void processSubscriber(Map<String, List<OpcUaConsumer>> consumerMap, List<OpcUaSubscriber> subscribers, OpcUaProperties properties) {
        if (subscribers == null || subscribers.isEmpty()) {
            return;
        }
        for (OpcUaSubscriber subscriber : subscribers) {
            String id = subscriber.id();
            if (id == null || id.isEmpty()) {
                id = properties.getId();
            }
            String[] items = subscriber.items();
            int[] namespaceIndices = subscriber.namespaceIndices();
            OpcUaConsumer consumer = new OpcUaConsumer(id, items, namespaceIndices, (item, value) -> {
                try {
                    subscriber.message((String)item, (String)value);
                }
                catch (Exception e) {
                    log.error("OPC UA invoke error", (Throwable)e);
                }
            });
            consumer.initialize();
            List list = consumerMap.computeIfAbsent(id, k -> new ArrayList());
            list.add(consumer);
        }
    }
}

