/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.opc.ua;

import java.util.Arrays;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.springframework.util.Assert;

public class OpcUaConsumer {
    private String id;
    private String[] items;
    private int[] namespaceIndices;
    private BiConsumer<String, String> consumer;

    public OpcUaConsumer() {
    }

    public OpcUaConsumer(String id, String[] items, int[] namespaceIndices, BiConsumer<String, String> consumer) {
        this.id = id;
        this.items = items;
        this.namespaceIndices = namespaceIndices;
        this.consumer = consumer;
    }

    public void initialize() {
        this.check();
        this.alignLength();
    }

    public void check() {
        Assert.notNull((Object)this.id, (String)"OPC UA id must not be null");
        Assert.notEmpty((Object[])this.items, (String)"OPC UA items must not be empty");
        Assert.isTrue((this.namespaceIndices != null && this.namespaceIndices.length > 0 ? 1 : 0) != 0, (String)"OPC UA namespaceIndices must not be empty");
    }

    public void alignLength() {
        if (this.namespaceIndices.length == this.items.length) {
            return;
        }
        if (this.namespaceIndices.length == 1) {
            int[] targetNamespaceIndices = new int[this.items.length];
            Arrays.fill(targetNamespaceIndices, this.namespaceIndices[0]);
            this.namespaceIndices = targetNamespaceIndices;
        }
        throw new RuntimeException("OPC UA namespaceIndices length must be 1 or equal to items length");
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String[] getItems() {
        return this.items;
    }

    @Generated
    public int[] getNamespaceIndices() {
        return this.namespaceIndices;
    }

    @Generated
    public BiConsumer<String, String> getConsumer() {
        return this.consumer;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setItems(String[] items) {
        this.items = items;
    }

    @Generated
    public void setNamespaceIndices(int[] namespaceIndices) {
        this.namespaceIndices = namespaceIndices;
    }

    @Generated
    public void setConsumer(BiConsumer<String, String> consumer) {
        this.consumer = consumer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpcUaConsumer)) {
            return false;
        }
        OpcUaConsumer other = (OpcUaConsumer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getItems(), other.getItems())) {
            return false;
        }
        if (!Arrays.equals(this.getNamespaceIndices(), other.getNamespaceIndices())) {
            return false;
        }
        BiConsumer<String, String> this$consumer = this.getConsumer();
        BiConsumer<String, String> other$consumer = other.getConsumer();
        return !(this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpcUaConsumer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        result = result * 59 + Arrays.hashCode(this.getNamespaceIndices());
        BiConsumer<String, String> $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpcUaConsumer(id=" + this.getId() + ", items=" + Arrays.deepToString(this.getItems()) + ", namespaceIndices=" + Arrays.toString(this.getNamespaceIndices()) + ", consumer=" + String.valueOf(this.getConsumer()) + ")";
    }
}

