/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.jwt.config;

import cn.mindit.atom.jwt.config.JwtProperties;
import cn.mindit.atom.jwt.service.impl.JwtServiceImpl;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import java.util.Base64;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@Import(value={JwtServiceImpl.class})
@EnableConfigurationProperties(value={JwtProperties.class})
@ConditionalOnProperty(value={"atom.jwt.enabled"}, matchIfMissing=true)
public class JwtAutoConfiguration {
    private final JwtProperties jwtProperties;

    @ConditionalOnMissingBean
    @Bean
    public JWSSigner jwsSigner() {
        String secret = this.jwtProperties.getSecret();
        if (secret == null || secret.isEmpty()) {
            throw new IllegalArgumentException("jwt secret can not be empty");
        }
        byte[] secretKey = Base64.getDecoder().decode(secret);
        try {
            return new MACSigner(secretKey);
        }
        catch (KeyLengthException e) {
            throw new RuntimeException(e);
        }
    }

    @ConditionalOnMissingBean
    @Bean
    public JWSVerifier jwsVerifier() {
        String secret = this.jwtProperties.getSecret();
        if (secret == null || secret.isEmpty()) {
            throw new IllegalArgumentException("jwt secret can not be empty");
        }
        byte[] secretKey = Base64.getDecoder().decode(secret);
        try {
            return new MACVerifier(secretKey);
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public JwtAutoConfiguration(JwtProperties jwtProperties) {
        this.jwtProperties = jwtProperties;
    }
}

