/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.core.util.json;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import cn.mindit.atom.core.util.MaskType;
import cn.mindit.atom.core.util.json.JsonMask;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;

public class MaskSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    public static final MaskSerializer instance = new MaskSerializer();
    private MaskType type;
    private Integer start;
    private Integer end;

    public MaskSerializer() {
    }

    public MaskSerializer(MaskType type, Integer start, Integer end) {
        this.type = type;
        this.start = start;
        this.end = end;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        if (valueStr.isEmpty()) {
            gen.writeString("");
            return;
        }
        switch (this.type) {
            case CUSTOM: {
                gen.writeString(StrUtil.hide((CharSequence)valueStr, (int)this.start, (int)this.end));
                break;
            }
            case NAME: {
                gen.writeString(StrUtil.hide((CharSequence)valueStr, (int)1, (int)valueStr.length()));
                break;
            }
            case PHONE: {
                gen.writeString(StrUtil.hide((CharSequence)valueStr, (int)3, (int)(valueStr.length() - 4)));
                break;
            }
            case ID_CARD: {
                gen.writeString(StrUtil.hide((CharSequence)valueStr, (int)3, (int)(valueStr.length() - 4)));
                break;
            }
            case BANK_CARD: {
                gen.writeString("**** **** **** " + valueStr.substring(valueStr.length() - 4));
                break;
            }
            case EMAIL: {
                gen.writeString(DesensitizedUtil.email((String)value.toString()));
                break;
            }
            case PASSWORD: {
                gen.writeString(DesensitizedUtil.password((String)value.toString()));
                break;
            }
            case FIXED_PHONE: {
                gen.writeString(DesensitizedUtil.fixedPhone((String)value.toString()));
                break;
            }
            case ADDRESS: {
                gen.writeString(DesensitizedUtil.address((String)value.toString(), (int)6));
                break;
            }
            case ID: {
                if (value instanceof Number) {
                    gen.writeNumber(0);
                    break;
                }
                gen.writeString("0");
                break;
            }
            case CAR_LICENSE: {
                gen.writeString(DesensitizedUtil.carLicense((String)value.toString()));
                break;
            }
            case IPV4: {
                gen.writeString(DesensitizedUtil.ipv4((String)value.toString()));
                break;
            }
            case IPV6: {
                gen.writeString(DesensitizedUtil.ipv6((String)value.toString()));
                break;
            }
        }
    }

    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, gen, serializers);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return instance;
        }
        JsonMask annotation = (JsonMask)property.getAnnotation(JsonMask.class);
        if (annotation == null) {
            annotation = (JsonMask)property.getContextAnnotation(JsonMask.class);
        }
        if (annotation != null) {
            return new MaskSerializer(annotation.value(), annotation.start(), annotation.end());
        }
        return provider.findValueSerializer(property.getType(), property);
    }
}

