/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.core.util.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import java.io.IOException;

@JacksonStdImpl
public class IntegerDeserializer
extends JsonDeserializer<Integer> {
    public static final IntegerDeserializer instance = new IntegerDeserializer();

    public Integer deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String value = parser.getText();
        if (value == null || value.isEmpty()) {
            return null;
        }
        JsonToken token = parser.getCurrentToken();
        if (token.isBoolean()) {
            return parser.getBooleanValue() ? 1 : 0;
        }
        value = value.trim();
        return Integer.parseInt(value);
    }
}

