/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.core.util;

import cn.mindit.atom.core.util.SortTreeNode;
import cn.mindit.atom.core.util.TreeNode;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TreeUtils {
    private TreeUtils() {
    }

    public static <E extends TreeNode<E, K>, K> List<E> buildTree(List<E> nodes, K rootId) {
        Map<Object, List<TreeNode>> parentMap = nodes.stream().collect(Collectors.groupingBy(TreeNode::getParentId));
        for (TreeNode node : nodes) {
            List<TreeNode> children = parentMap.get(node.getId());
            if (children == null) continue;
            node.setChildren(children);
        }
        return parentMap.get(rootId);
    }

    public static <E extends SortTreeNode<E, K, S>, K, S extends Comparable<S>> List<E> buildSortTree(List<E> nodes, K rootId) {
        Map<Object, List> parentMap = nodes.stream().collect(Collectors.groupingBy(TreeNode::getParentId, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(SortTreeNode::getSort)).collect(Collectors.toList()))));
        for (SortTreeNode node : nodes) {
            List children = parentMap.get(node.getId());
            if (children == null) continue;
            node.setChildren(children);
        }
        return parentMap.get(rootId);
    }
}

