/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.core.core;

import cn.mindit.atom.core.util.NanoIdUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class TraceIdTaskDecorator
implements TaskDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TraceIdTaskDecorator.class);

    @NonNull
    public Runnable decorate(@NonNull Runnable runnable) {
        Map context = MDC.getCopyOfContextMap();
        return () -> {
            this.setTraceIdIfAbsent(context);
            try {
                runnable.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    private void setTraceIdIfAbsent(Map<String, String> context) {
        if (context == null) {
            HashMap<String, String> ctx = new HashMap<String, String>();
            ctx.put("Trace-Id", NanoIdUtils.nanoId());
            MDC.setContextMap(ctx);
            return;
        }
        if (context.containsKey("Trace-Id")) {
            MDC.setContextMap(context);
            return;
        }
        HashMap<String, String> ctx = new HashMap<String, String>(context);
        ctx.put("Trace-Id", NanoIdUtils.nanoId());
        MDC.setContextMap(ctx);
    }
}

