/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.core.core;

import cn.mindit.atom.core.core.TraceIdTaskDecorator;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskSchedulingProperties;
import org.springframework.boot.task.ThreadPoolTaskSchedulerBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@EnableAsync
@EnableScheduling
@ConditionalOnProperty(value={"atom.core.trace"}, matchIfMissing=true)
@Configuration
public class CoreTraceConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoreTraceConfiguration.class);
    private final TaskSchedulingProperties taskSchedulingProperties;
    private final TraceIdTaskDecorator traceIdTaskDecorator;

    @Bean
    public ThreadPoolTaskScheduler threadPoolTaskScheduler() {
        TaskSchedulingProperties.Pool pool = this.taskSchedulingProperties.getPool();
        TaskSchedulingProperties.Shutdown shutdown = this.taskSchedulingProperties.getShutdown();
        String prefix = this.taskSchedulingProperties.getThreadNamePrefix();
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskSchedulerBuilder().poolSize(pool.getSize()).awaitTermination(shutdown.isAwaitTermination()).awaitTerminationPeriod(shutdown.getAwaitTerminationPeriod()).threadNamePrefix(prefix).build();
        scheduler.setTaskDecorator((TaskDecorator)this.traceIdTaskDecorator);
        scheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        scheduler.initialize();
        return scheduler;
    }

    @Generated
    public CoreTraceConfiguration(TaskSchedulingProperties taskSchedulingProperties, TraceIdTaskDecorator traceIdTaskDecorator) {
        this.taskSchedulingProperties = taskSchedulingProperties;
        this.traceIdTaskDecorator = traceIdTaskDecorator;
    }
}

