/*
 * Decompiled with CFR 0.152.
 */
package cn.mindit.atom.api.param;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.lang.NonNull;

public class PageVO<T> {
    @Schema(description="\u9875\u7801", example="1")
    private long pageNo = 1L;
    @Schema(description="\u6bcf\u9875\u7ed3\u679c\u6570", example="15")
    private long pageSize = 15L;
    @Schema(description="\u603b\u9875\u6570", example="0")
    private long totalPage = 0L;
    @Schema(description="\u603b\u7ed3\u679c\u6570", example="0")
    private long totalRow = 0L;
    @Schema(description="\u6570\u636e", example="[]")
    private List<T> items = new ArrayList<T>();

    public static <T> PageVO<T> of() {
        return new PageVO<T>();
    }

    public static <T> PageVO<T> of(@NonNull Page<T> page) {
        PageVO<T> pageResponse = new PageVO<T>();
        pageResponse.setPageNo(page.getCurrent());
        pageResponse.setPageSize(page.getSize());
        pageResponse.setTotalRow(page.getSize() < 0L ? (long)page.getRecords().size() : page.getTotal());
        pageResponse.setTotalPage(page.getPages());
        pageResponse.setItems(page.getRecords());
        return pageResponse;
    }

    public static <T, R> PageVO<R> of(@NonNull Page<T> page, Function<T, R> function) {
        PageVO pageResponse = new PageVO();
        pageResponse.setPageNo(page.getCurrent());
        pageResponse.setPageSize(page.getSize());
        pageResponse.setTotalRow(page.getSize() < 0L ? (long)page.getRecords().size() : page.getTotal());
        pageResponse.setTotalPage(page.getPages());
        pageResponse.setItems(page.getRecords().stream().map(function).collect(Collectors.toList()));
        return pageResponse;
    }

    @Generated
    public PageVO() {
    }

    @Generated
    public PageVO(long pageNo, long pageSize, long totalPage, long totalRow, List<T> items) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalPage = totalPage;
        this.totalRow = totalRow;
        this.items = items;
    }

    @Generated
    public long getPageNo() {
        return this.pageNo;
    }

    @Generated
    public long getPageSize() {
        return this.pageSize;
    }

    @Generated
    public long getTotalPage() {
        return this.totalPage;
    }

    @Generated
    public long getTotalRow() {
        return this.totalRow;
    }

    @Generated
    public List<T> getItems() {
        return this.items;
    }

    @Generated
    public void setPageNo(long pageNo) {
        this.pageNo = pageNo;
    }

    @Generated
    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    @Generated
    public void setTotalRow(long totalRow) {
        this.totalRow = totalRow;
    }

    @Generated
    public void setItems(List<T> items) {
        this.items = items;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageVO)) {
            return false;
        }
        PageVO other = (PageVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getTotalRow() != other.getTotalRow()) {
            return false;
        }
        List<T> this$items = this.getItems();
        List<T> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageVO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pageNo = this.getPageNo();
        result = result * 59 + (int)($pageNo >>> 32 ^ $pageNo);
        long $pageSize = this.getPageSize();
        result = result * 59 + (int)($pageSize >>> 32 ^ $pageSize);
        long $totalPage = this.getTotalPage();
        result = result * 59 + (int)($totalPage >>> 32 ^ $totalPage);
        long $totalRow = this.getTotalRow();
        result = result * 59 + (int)($totalRow >>> 32 ^ $totalRow);
        List<T> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageVO(pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ", totalPage=" + this.getTotalPage() + ", totalRow=" + this.getTotalRow() + ", items=" + String.valueOf(this.getItems()) + ")";
    }
}

