/*
 * Decompiled with CFR 0.152.
 */
package cn.miludeer.jsoncode.compile;

import cn.miludeer.jsoncode.compile.Common;
import cn.miludeer.jsoncode.compile.LexicalItem;
import java.util.LinkedList;

public class LexicalAnalysis {
    public static String[] key = new String[]{"listsize", "listfind", "listget"};
    public static int keyLen = 3;

    public static LinkedList<LexicalItem> parse(String line) {
        LinkedList<LexicalItem> ret = new LinkedList<LexicalItem>();
        int len = line.length();
        for (int i = 0; i < len; ++i) {
            String temp;
            int b = 0;
            int begin = 0;
            int end = 0;
            if (Common.isBlank(line.charAt(i))) continue;
            if (Common.isLetter(line.charAt(i))) {
                begin = i;
                while (++i < len && (Common.isDigit(line.charAt(i)) || Common.isLetter(line.charAt(i)))) {
                }
                end = i;
                temp = line.substring(begin, end);
                for (int a = 0; a < keyLen; ++a) {
                    if (!temp.equals(key[a])) continue;
                    b = 3;
                    break;
                }
                b = 1;
                LexicalItem item = new LexicalItem(b, temp);
                ret.addLast(item);
                --i;
                continue;
            }
            if (Common.isDigit(line.charAt(i))) {
                begin = i;
                while (i < len && Common.isDigit(line.charAt(i))) {
                    ++i;
                }
                end = i--;
                temp = line.substring(begin, end);
                LexicalItem item = new LexicalItem(2, temp);
                ret.addLast(item);
                continue;
            }
            if (Common.isDelimiter(line.charAt(i))) {
                LexicalItem item = new LexicalItem(5, String.valueOf(line.charAt(i)));
                ret.addLast(item);
                continue;
            }
            if (Common.isOperators(line.charAt(i))) {
                LexicalItem item;
                if ((line.charAt(i) == '>' || line.charAt(i) == '<') && line.charAt(i + 1) == '=') {
                    item = new LexicalItem(4, line.substring(i, i + 2));
                    ++i;
                } else {
                    item = new LexicalItem(4, line.substring(i, i + 1));
                }
                ret.addLast(item);
                continue;
            }
            if (line.charAt(i) == '$') {
                begin = i++;
                while (i < len && (Common.isDigit(line.charAt(i)) || Common.isLetter(line.charAt(i)) || line.charAt(i) == '.')) {
                    ++i;
                }
                end = i--;
                temp = line.substring(begin, end);
                LexicalItem item = new LexicalItem(6, temp);
                ret.addLast(item);
                continue;
            }
            if (!Common.isDot(line.charAt(i))) continue;
            begin = i++;
            while (i < len && (Common.isLetter(line.charAt(i)) || Common.isDot(line.charAt(i)))) {
                ++i;
            }
            end = i--;
            temp = line.substring(begin, end);
            LexicalItem item = new LexicalItem(7, temp);
            ret.addLast(item);
        }
        return ret;
    }
}

