/*
 * Decompiled with CFR 0.152.
 */
package cn.miludeer.jsoncode.fileformat;

import cn.miludeer.jsoncode.JsonCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class FileTemplate {
    private static final String END = "ERROR_END_END";
    private final List<Line> templates = new ArrayList<Line>();

    public FileTemplate(InputStream inputStream) throws Exception {
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        int index = 0;
        String line = "";
        while ((line = br.readLine()) != null) {
            this.templates.add(new Line(++index, line));
        }
        br.close();
        isr.close();
        this.init();
    }

    public FileTemplate(File file) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String s = null;
            int index = 0;
            while ((s = br.readLine()) != null) {
                this.templates.add(new Line(++index, s));
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.init();
    }

    private void init() throws Exception {
        int loop = 0;
        Stack<Integer> indexStack = new Stack<Integer>();
        Integer i = 0;
        for (Line line : this.templates) {
            if (line.type == 10) {
                indexStack.push(i);
                ++loop;
            }
            if (line.type == 11) {
                Integer index = (Integer)indexStack.pop();
                line.jump = index;
                this.templates.get((int)index.intValue()).jump = i;
                --loop;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (loop != 0) {
            throw new Exception();
        }
    }

    public String parseResult(String jsonString) {
        StringBuffer sb = new StringBuffer();
        int size = this.templates.size();
        String loopTemp = null;
        boolean isback = false;
        Stack<StackItem> stack = new Stack<StackItem>();
        block8: for (int n = 0; n < size; ++n) {
            Line line = this.templates.get(n);
            switch (line.type) {
                case 10: {
                    StackItem item;
                    if (!isback) {
                        String[] temp;
                        String path = ((Word)line.words.get(1)).content.trim();
                        if (path.startsWith("$")) {
                            temp = JsonCode.getValueList(jsonString, path);
                            stack.push(new StackItem(temp, n));
                        }
                        if (path.startsWith("@")) {
                            temp = JsonCode.getValueList(loopTemp, path.replace('@', '$'));
                            stack.push(new StackItem(temp, n));
                        }
                    }
                    if (END.equals(loopTemp = (item = (StackItem)stack.peek()).getNext())) {
                        stack.pop();
                        n = line.jump;
                    }
                    isback = false;
                    continue block8;
                }
                case 11: {
                    n = line.jump - 1;
                    isback = true;
                    continue block8;
                }
                default: {
                    for (Word word : line.words) {
                        String tempDefault2;
                        if (word.type == 0) {
                            sb.append(word.content);
                            continue;
                        }
                        if (word.content.startsWith("$")) {
                            try {
                                tempDefault2 = JsonCode.getValue(jsonString, word.content);
                                sb.append(tempDefault2);
                            }
                            catch (Exception tempDefault2) {
                                // empty catch block
                            }
                        }
                        if (!word.content.startsWith("@")) continue;
                        try {
                            tempDefault2 = JsonCode.getValue(loopTemp, word.content.replace('@', '$'));
                            sb.append(tempDefault2);
                        }
                        catch (Exception exception) {}
                    }
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    public static class Word {
        private String content;
        private int type;

        public Word(String content, int type) {
            this.content = content;
            this.type = type;
        }
    }

    public static class Line {
        private int index;
        private int type;
        public int jump;
        private List<Word> words;

        public Line(int index, String content) throws Exception {
            this.index = index;
            this.words = new ArrayList<Word>();
            int len = content.length();
            StringBuffer sb = new StringBuffer();
            boolean begin = true;
            for (int i = 0; i < len; ++i) {
                char x = content.charAt(i);
                if (x == '{') {
                    this.words.add(new Word(sb.toString(), 0));
                    sb = new StringBuffer();
                    begin = true;
                    continue;
                }
                if (x == '}') {
                    if (!begin) {
                        throw new Exception("");
                    }
                    this.words.add(new Word(sb.toString(), 1));
                    sb = new StringBuffer();
                    continue;
                }
                sb.append(x);
            }
            String temp = sb.toString();
            if (temp.length() != 0) {
                this.words.add(new Word(temp, 0));
            }
            int count = this.words.size();
            int i = 0;
            for (Word word : this.words) {
                if ("for".equals(word.content.trim().toLowerCase())) {
                    if (i > 0 || count < 2 || count > 3) {
                        throw new Exception();
                    }
                    if (this.words.get(1).type == 0) {
                        throw new Exception();
                    }
                    if (count == 3 && !"".equals(this.words.get(2).content.trim())) {
                        throw new Exception();
                    }
                    this.type = 10;
                }
                if ("end".equals(word.content.trim().toLowerCase())) {
                    if (i > 0) {
                        throw new Exception();
                    }
                    if (count != 1) {
                        throw new Exception();
                    }
                    this.type = 11;
                }
                ++i;
            }
        }
    }

    public static class StackItem {
        List<String> list;
        int beginLoop;
        int index;

        public StackItem(List<String> list, int beginLoop) {
            this.list = list;
            this.index = -1;
            this.beginLoop = beginLoop;
        }

        public StackItem(String[] list, int beginLoop) {
            this.list = Arrays.asList(list);
            this.index = -1;
            this.beginLoop = beginLoop;
        }

        public String getNext() {
            int size = this.list == null ? 0 : this.list.size();
            ++this.index;
            if (this.index > size - 1) {
                return FileTemplate.END;
            }
            return this.list.get(this.index);
        }

        public String getNow() {
            int size;
            int n = size = this.list == null ? 0 : this.list.size();
            if (this.index > size - 1) {
                return FileTemplate.END;
            }
            return this.list.get(this.index);
        }
    }
}

