package cn.miludeer.jsoncode;

import cn.miludeer.jsoncode.compile.LexicalAnalysis;
import cn.miludeer.jsoncode.compile.LexicalItem;
import cn.miludeer.jsoncode.compile.UnitCalc;
import cn.miludeer.jsoncode.element.IndexResult;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/**
 * program: jsoncode
 * description: ${description}
 * author: lujinfei
 * create: 2019-02-20 13:14
 **/
public class JsonProcess {

    public static String calExpression(String json, String expression) {
        LinkedList<LexicalItem> list = LexicalAnalysis.parse(expression);
        // todo 依次处理元素 字符常数的码为1，数字常数数为2，保留字为3，运算符为4，界符为5，json路径为6

        Stack<LexicalItem> stack = new Stack<LexicalItem>();

        int size = list.size();
        for(int i= 0 ; i< size; i++) {
            LexicalItem item = list.get(i);
            switch (item.type) {
                case 3:                // 函数的使用
                    stack.push(item);
                    break;
                case 4:
                    stack.push(item);
                    break;
                case 5:  // 目前认为只有（）
                    List<LexicalItem> param = new ArrayList<LexicalItem>();
                    if(item.cm.charAt(0) == ')') {
                        LexicalItem item2 = stack.pop();
                        if(item2.type == 1) {
                            LexicalItem item3 = stack.pop();
                            if(item3.cm.charAt(0) == '(') { // 优先级的括号
                                param.add(item2);
                            } else if(item3.cm.charAt(0) == ',') {
                                LexicalItem item4 = stack.pop();
                                LexicalItem item5 = stack.pop();
                                param.add(item2);
                                param.add(item4);
                                while (item4 != null && (item4.type == 1 || item4.type == 2)
                                        && item5.cm.charAt(0) == ',') {
                                    item4 = stack.pop();
                                    item5 = stack.pop();
                                    param.add(item4);
                                }

                            }
                            LexicalItem item6 = stack.pop();
                            if(item6 != null && item6.type==1) { // 准备调用函数
                                String bb = UnitCalc.doProcedure(item6.cm, param);
                                stack.push(new LexicalItem(1, bb));
                            } else {
                                stack.push(item6);
                                stack.push(param.get(0));
                            }
                        }
                    } else {
                        stack.push(item);
                    }
                    break;
                case 1:
                case 2:
                case 6:
                    LexicalItem th;
                    if(item.type == 6) {
                        String value = JsonCode.getValue(json, item.cm);
                        th = new LexicalItem(1, value);
                    } else {
                        th = item;
                    }
                    if(stack.empty()) {
                        stack.push(th);
                    } else {
                        LexicalItem item2 = stack.pop();
                        if(item2.type == 4) {
                            LexicalItem item3 = stack.pop();
                            String temp = UnitCalc.TwoCompare(item3.cm, th.cm, item2.cm);
                            stack.push(new LexicalItem(1, temp));
                        } else {
                            stack.push(item2);
                            stack.push(new LexicalItem(1, th.cm));
                        }
                    }
                    break;
            }
        }

        LexicalItem item2 = stack.pop();
        if(item2 != null) {
            return item2.cm;
        }else {
            return "null";
        }
    }

    public static String[] cutForList(String json) {
        List<String> list = new ArrayList<String>();

        int i = 1;
        boolean isContent2 = false;  // 引号包含的内容
        char temp = json.charAt(i);
        int floor = 0;

        IndexResult result = new IndexResult();
        result.a = i;

        while(true) {
            if(isContent2) {
                switch (temp) {
                    case '\\':
                        i++;
                        break;
                    case '"':
                        isContent2 = false;
                        break;
                }
            } else {
                switch (temp) {
                    case '"': // 如果遇到这种情况就说明有字符串
                        isContent2 = !isContent2;
                        break;
                    case ',':
                    case ']':
                        if(floor == 0) {
                            result.b = i;
                            list.add(json.substring(result.a, result.b));
                            result.a = i+1;
                        }
                        break;
                    case '{':
                        floor++;
                        break;
                    case '}':
                        floor--;
                        break;
                }
            }
            i++;

            if(i== json.length()) {
                break;
            }
            temp = json.charAt(i);
        }

        String[] ret = new String[list.size()];

        int index = 0;
        for(String a : list) {
            ret[index] = a;
            index++;
        }

        return ret;
    }

    public static IndexResult anylise(String jsonStr, int beginId, int endId, String key){
        if(jsonStr.charAt(beginId) != '{') {
            return null;
        }

        IndexResult result = new IndexResult();
        result.a = -1;

        boolean isContent = false;
        boolean isfake = false;
        boolean enterKey = true;
        boolean isMatch = false;

        for(int i=beginId + 1; i<endId; i++) {

            char temp = jsonStr.charAt(i);

            if(isfake) continue;        // 遇到转义的直接跳过去

            switch (temp) {
                case '\\':
                    isfake = true;
                    continue;
                case ':':
                    enterKey = false;
                    continue;
                case ',':
                    enterKey = true;
                    continue;
            }

            if(enterKey) {  // 如果是key，则进行匹配
                if(temp == '"') {
                    i++;
                    temp = jsonStr.charAt(i);
                }
                int j = 0;
                int keyLen = key.length();
                while(j<keyLen && temp == key.charAt(j)) {
                    j++;
                    i++;
                    temp = jsonStr.charAt(i);
                    if(temp == '"' || temp == ':') {
                        break;
                    }
                }
                if(j == key.length() && jsonStr.charAt(i) == '"') { // 匹配上
                    isMatch = true;
                    continue;
                } else { // 没有匹配上

                }
            }

            if(!enterKey && isMatch) {   // 到了value，且是内容，且是匹配上的
                if (temp == '"') { // 值是string
                    i++;
                    result.a = i;
                    temp = jsonStr.charAt(i);
                    while (temp != '"') {
                        i++;
                        temp = jsonStr.charAt(i);
                        if (temp == '\\') {
                            i += 2;
                            temp = jsonStr.charAt(i);
                        }
                    }
                    result.b = i;
                    return result;
                } else if(temp == '[') {  // 数组的方式。
                    result.a = i;
                    i++;
                    boolean isCintent2 = false;
                    temp = jsonStr.charAt(i);
                    int floor = 0;
                    floor++;
                    cycle2:             while(true) {
                        if(isCintent2) {
                            switch (temp) {
                                case '\\':
                                    i++;
                                    break;
                                case '"':
                                    isCintent2 = false;
                                    break;
                            }
                        } else {
                            switch (temp) {
                                case '[':
                                    floor ++;
                                    break;
                                case ']':
                                    floor--;
                                    if(floor == 0) {
                                        result.b = i+1;
                                        break cycle2;
                                    }
                                    break;
                                case '"':
                                    isCintent2 = !isCintent2;
                                    break;
                                case '\\':
                                    i++; // 跳过下一个
                                    break;
                            }
                        }
                        i++;
                        temp = jsonStr.charAt(i);
                    }
                    return result;
                } else{  // 值里面可能是int或还是一个json
                    result.a = i;
                    int floor = 0;
                    boolean isCintent2 = false;
                    cycle:              while(true) {
                        if (isCintent2) {
                            switch (temp) {
                                case '\\':
                                    i++; // 跳过下一个
                                    break;
                                case '"':
                                    isCintent2 = false;
                                    break;
                            }
                        } else {
                            switch (temp) {
                                case '\\':
                                    i++; // 跳过下一个
                                    break;
                                case '"':
                                    isCintent2 = !isCintent2;
                                    break;
                                case '{':
                                    floor++;
                                    break;
                                case '}':
                                    if(floor == 0) {
                                        result.b = i;
                                        break cycle;
                                    } else {
                                        floor--;
                                    }
                                    break;
                                case ',':
                                    if (floor == 0) { // 这里就结束了，返回
                                        result.b = i;
                                        break cycle;
                                    }
                            }
                        }
                        i++;
                        temp = jsonStr.charAt(i);
                    }
                    return result;
                }
            }
        }
        return result;
    }


}
