/*
 * Decompiled with CFR 0.152.
 */
package cn.meddb.core.model;

import cn.meddb.core.model.IDataBufferHandler;
import cn.meddb.core.model.IPageInfo;
import cn.meddb.core.model.ISearchBean;
import cn.meddb.core.model.POJOPageInfo;
import java.util.ArrayList;
import java.util.List;

public class DataBufferUtil<T> {
    private List<T> bufferList;
    private IDataBufferHandler<T> handler;
    private ISearchBean searchBean;
    private IPageInfo<T> pageInfo;
    private int page = 1;

    public DataBufferUtil(IDataBufferHandler<T> handler, ISearchBean searchBean, int buffer) {
        this.handler = handler;
        this.pageInfo = new POJOPageInfo(buffer, this.page);
        this.searchBean = searchBean;
    }

    public T next() {
        T obj = null;
        if (this.needData()) {
            this.setBufferData();
        }
        if (this.bufferList.size() > 0) {
            obj = this.bufferList.remove(0);
        }
        return obj;
    }

    private void setBufferData() {
        if (this.handler == null) {
            return;
        }
        if (this.page == 1 || this.pageInfo.getCount() > this.pageInfo.getStart()) {
            this.pageInfo = this.handler.getNextList(this.searchBean, new POJOPageInfo(this.pageInfo.getLimit(), this.page++));
            this.bufferList = this.pageInfo.getItems();
        }
    }

    public boolean hasNext() {
        if (this.needData()) {
            this.setBufferData();
        }
        return !this.needData();
    }

    private boolean needData() {
        return this.getBufferCurrentNum() == 0;
    }

    private int getBufferCurrentNum() {
        if (this.bufferList == null) {
            this.bufferList = new ArrayList<T>();
        }
        return this.bufferList.size();
    }
}

