/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.openapi.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class MapwayOpenApiWebMvcConfig
implements WebMvcConfigurer {
    private static Logger log = LoggerFactory.getLogger(MapwayOpenApiWebMvcConfig.class);
    private final String baseUrl;

    public MapwayOpenApiWebMvcConfig(String baseUrl) {
        this.baseUrl = baseUrl;
        log.info("OPENAPI \u93c2\u56e8\u3002UARL\u95b0\u5d87\u7586\u9352\u6fc6\ue750\u9356\u6704{}", (Object)this.baseUrl);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String baseUrl = StringUtils.trimTrailingCharacter((String)this.baseUrl, (char)'/');
        registry.addResourceHandler(new String[]{baseUrl + "/**"}).addResourceLocations(new String[]{"classpath:/META-INF/viewer/"}).resourceChain(false);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController(this.baseUrl).setViewName("redirect:" + this.baseUrl + "/index.html?l=" + this.baseUrl);
    }
}

