/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.spring.tools;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.nutz.castor.Castors;
import org.nutz.lang.Strings;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static String getParameter(String name) {
        return ServletUtils.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        String parameter = ServletUtils.getParameter(name);
        if (Strings.isBlank((CharSequence)parameter)) {
            return defaultValue;
        }
        return (String)Castors.me().castTo((Object)defaultValue, String.class);
    }

    public static Integer getParameterToInt(String name) {
        return ServletUtils.getParameterToInt(name, 0);
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        String parameter = ServletUtils.getParameter(name);
        if (Strings.isBlank((CharSequence)parameter)) {
            return defaultValue;
        }
        return (Integer)Castors.me().castTo((Object)defaultValue, Integer.class);
    }

    public static HttpServletRequest getRequest() {
        return ServletUtils.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtils.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession(true);
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static String renderString(HttpServletResponse response, String string) {
        try {
            response.setStatus(200);
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String readToken() {
        return ServletUtils.readHeader("Authorization");
    }

    public static String readHeader(String headerKey) {
        String header = ServletUtils.getRequest().getHeader(headerKey);
        if (Strings.isNotBlank((CharSequence)header) && header.startsWith("Bearer ")) {
            return header.replace("Bearer ", "");
        }
        return "";
    }
}

