/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.spring.processor.module;

import cn.mapway.spring.processor.module.ApiModuleDefine;
import cn.mapway.spring.processor.module.FieldDefine;
import cn.mapway.spring.processor.module.StringTools;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Logs;

public class AllModules {
    private static final AllModules INSTANCE = new AllModules();
    private final Map<String, ApiModuleDefine> modules = new HashMap<String, ApiModuleDefine>();
    private static Map<String, TypeName> translatePattern = new HashMap<String, TypeName>();

    public static AllModules getInstance() {
        return INSTANCE;
    }

    public static boolean isPredefinedType(String qname) {
        boolean b = translatePattern.containsKey(qname);
        if (b) {
            return true;
        }
        for (TypeName typeName : translatePattern.values()) {
            if (!typeName.toString().equals(qname)) continue;
            return true;
        }
        return false;
    }

    public ApiModuleDefine getModule(String qname) {
        return this.modules.get(qname);
    }

    public void put(ApiModuleDefine define) {
        this.modules.put(define.qname, define);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ApiModuleDefine define : this.modules.values()) {
            sb.append("\r\n");
            sb.append(define.toString());
        }
        return sb.toString();
    }

    private void info(String msg) {
        Logs.getLog((String)"MG").info((Object)msg);
    }

    public void emitToPath(String outputPath) {
        for (ApiModuleDefine define : this.modules.values()) {
            TypeSpec.Builder tb;
            if (define.translateName == null) {
                this.info("ERROR: " + define.qname + " is not transformed");
                continue;
            }
            this.info("Process : " + define.translateName.toString());
            if (define.translateName instanceof ParameterizedTypeName) {
                ParameterizedTypeName p = (ParameterizedTypeName)define.translateName;
                tb = define.isInterface ? TypeSpec.interfaceBuilder((String)p.rawType.simpleName()) : TypeSpec.classBuilder((String)p.rawType.simpleName());
                for (TypeName arg : p.typeArguments) {
                    if (!(arg instanceof TypeVariableName)) continue;
                    tb.addTypeVariable((TypeVariableName)arg);
                }
            } else {
                String name = AllModules.getSimpleName(define.translateName.toString());
                tb = define.isInterface ? TypeSpec.interfaceBuilder((String)name) : TypeSpec.classBuilder((String)name);
            }
            if (define.getTranslateSuper() != null) {
                tb.superclass(define.getTranslateSuper());
            }
            if (Lang.isNotEmpty(define.translateImpls)) {
                for (TypeName typeName : define.translateImpls) {
                    if (typeName.toString().contains("Serializable")) continue;
                    tb.addSuperinterface(typeName);
                }
            }
            tb.addModifiers(new Modifier[]{Modifier.PUBLIC});
            AnnotationSpec.Builder jsTypeBuild = AnnotationSpec.builder(JsType.class);
            jsTypeBuild.addMember("isNative", "$L", new Object[]{"true"});
            jsTypeBuild.addMember("namespace", "$T.GLOBAL", new Object[]{JsPackage.class});
            jsTypeBuild.addMember("name", "$S", new Object[]{"Object"});
            tb.addAnnotation(jsTypeBuild.build());
            for (FieldDefine fieldDefine : define.fields) {
                FieldSpec.Builder fb;
                TypeName storeTypeName;
                String toNumberType = "";
                if (fieldDefine.tType.isPrimitive() || fieldDefine.tType.isBoxedPrimitive()) {
                    TypeName temp = fieldDefine.tType.unbox();
                    if (temp.equals((Object)TypeName.FLOAT)) {
                        toNumberType = "float";
                        storeTypeName = TypeName.DOUBLE.box();
                    } else if (temp.equals((Object)TypeName.INT)) {
                        toNumberType = "int";
                        storeTypeName = TypeName.DOUBLE.box();
                    } else if (temp.equals((Object)TypeName.LONG)) {
                        toNumberType = "long";
                        storeTypeName = TypeName.DOUBLE.box();
                    } else if (temp.equals((Object)TypeName.BYTE)) {
                        toNumberType = "byte";
                        storeTypeName = TypeName.DOUBLE.box();
                    } else if (temp.equals((Object)TypeName.SHORT)) {
                        toNumberType = "short";
                        storeTypeName = TypeName.DOUBLE.box();
                    } else {
                        storeTypeName = fieldDefine.tType;
                    }
                } else {
                    storeTypeName = fieldDefine.tType;
                }
                if (fieldDefine.isStatic) {
                    fb = FieldSpec.builder((TypeName)fieldDefine.tType, (String)fieldDefine.name, (Modifier[])new Modifier[0]);
                    fb.addModifiers(new Modifier[]{Modifier.STATIC}).addModifiers(new Modifier[]{Modifier.PUBLIC});
                    if (Strings.isNotBlank((CharSequence)fieldDefine.initValue)) {
                        fb.initializer("$L", new Object[]{fieldDefine.initValue});
                    }
                    if (Strings.isNotBlank((CharSequence)fieldDefine.summary)) {
                        fb.addJavadoc("$L", new Object[]{fieldDefine.summary});
                    }
                    tb.addField(fb.build());
                    continue;
                }
                fb = FieldSpec.builder((TypeName)storeTypeName, (String)fieldDefine.name, (Modifier[])new Modifier[0]);
                fb.addModifiers(new Modifier[]{Modifier.PRIVATE});
                tb.addField(fb.build());
                MethodSpec.Builder methodGetterBuilder = MethodSpec.methodBuilder((String)("get" + Strings.upperFirst((CharSequence)fieldDefine.name)));
                methodGetterBuilder.returns(fieldDefine.tType);
                methodGetterBuilder.addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
                if (Strings.isNotBlank((CharSequence)fieldDefine.summary)) {
                    fb.addJavadoc("$L", new Object[]{fieldDefine.summary});
                }
                if (Strings.isBlank((CharSequence)toNumberType)) {
                    methodGetterBuilder.addCode("\treturn this.$L==null?null:this.$L;", new Object[]{fieldDefine.name, fieldDefine.name});
                } else {
                    methodGetterBuilder.addCode("\treturn this.$L==null?null:this.$L.$LValue();", new Object[]{fieldDefine.name, fieldDefine.name, toNumberType});
                }
                AnnotationSpec.Builder jsOverlay1 = AnnotationSpec.builder(JsOverlay.class);
                methodGetterBuilder.addAnnotation(jsOverlay1.build());
                tb.addMethod(methodGetterBuilder.build());
                MethodSpec.Builder methodSetterBuilder = MethodSpec.methodBuilder((String)("set" + Strings.upperFirst((CharSequence)fieldDefine.name)));
                methodSetterBuilder.addParameter(fieldDefine.tType, "value", new Modifier[0]);
                methodSetterBuilder.returns(TypeName.VOID);
                methodSetterBuilder.addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC});
                if (Strings.isBlank((CharSequence)toNumberType)) {
                    methodSetterBuilder.addCode("\t this.$L=value;", new Object[]{fieldDefine.name});
                } else {
                    methodSetterBuilder.addCode("\t this.$L=(value==null)?null:value.doubleValue();", new Object[]{fieldDefine.name});
                }
                AnnotationSpec.Builder jsOverlay = AnnotationSpec.builder(JsOverlay.class);
                methodSetterBuilder.addAnnotation(jsOverlay.build());
                tb.addMethod(methodSetterBuilder.build());
            }
            JavaFile javaFile = JavaFile.builder((String)define.packageName, (TypeSpec)tb.build()).build();
            try {
                javaFile.writeTo(new File(outputPath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSimpleName(String name) {
        if (Strings.isBlank((CharSequence)name)) {
            return "";
        }
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    public static TypeName getTranslatePattern(String sourceTarget) {
        return translatePattern.get(sourceTarget);
    }

    public static void addTranslatePattern(String sourceType, String targetType) {
        if (translatePattern.get(sourceType) == null) {
            String[] parts = StringTools.splitLast(targetType, '.');
            ClassName typeName = ClassName.get((String)parts[0], (String)parts[1], (String[])new String[0]);
            translatePattern.put(sourceType, (TypeName)typeName);
        }
    }
}

