/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.spring.processor;

import cn.mapway.spring.processor.AnnotationHolder;
import cn.mapway.spring.processor.RpcIgnore;
import cn.mapway.spring.processor.RpcPackage;
import cn.mapway.spring.processor.TypeMirrorVisitor;
import cn.mapway.spring.processor.module.AllModules;
import cn.mapway.ui.server.code.RpcEntry;
import cn.mapway.ui.server.code.RpcProxy;
import cn.mapway.util.console.Ansi;
import cn.mapway.util.console.AnsiColor;
import com.google.auto.common.MoreElements;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Logs;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@AutoService(value={Processor.class})
public class ClientRpcStubGenerator
extends AbstractProcessor {
    private static Ansi BLUE = Ansi.from((AnsiColor)AnsiColor.FG_BLUE);
    private static Ansi GREEN = Ansi.from((AnsiColor)AnsiColor.FG_CYAN);
    private static Ansi RED = Ansi.from((AnsiColor)AnsiColor.FG_GREEN);
    private static Ansi WARNING = Ansi.from((AnsiColor)AnsiColor.FG_YELLOW);
    private final List<String> exceptionStacks = Collections.synchronizedList(new ArrayList());

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add(RpcPackage.class.getName());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processImpl(annotations, roundEnv);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.exceptionStacks.add(e.getMessage());
            this.fatalError(e.getMessage());
        }
        return true;
    }

    private void processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log("Processing " + annotations.size());
        this.processAnnotations(annotations, roundEnv);
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(RpcPackage.class);
        for (Element element : elements) {
            PackageElement p = (PackageElement)element;
            this.processPackage(p, roundEnv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processPackage(PackageElement packageElement, RoundEnvironment roundEnv) {
        void var8_11;
        String string;
        AnnotationHolder rpcPackage = AnnotationHolder.createFromElement(packageElement, RpcPackage.class);
        List<String> maps = rpcPackage.getStrings("maps");
        for (String map : maps) {
            String[] mapStrings = Strings.split((String)map, (boolean)false, (boolean)false, (char[])new char[]{','});
            if (mapStrings.length != 2) continue;
            AllModules.addTranslatePattern(mapStrings[0], mapStrings[1]);
        }
        List<? extends Element> enclosedElements = packageElement.getEnclosedElements();
        if (Lang.isEmpty(enclosedElements)) {
            return;
        }
        ArrayList<Element> exportClazz = new ArrayList<Element>();
        for (Element element : enclosedElements) {
            if (!element.getKind().equals((Object)ElementKind.CLASS) || !this.isController(rpcPackage, element)) continue;
            exportClazz.add(element);
        }
        String outputPath = this.processingEnv.getOptions().get("RPC_OUT_PATH");
        if (Strings.isBlank((CharSequence)outputPath)) {
            outputPath = rpcPackage.getString("localPath");
        }
        if (Strings.isBlank((CharSequence)outputPath)) {
            outputPath = rpcPackage.getString("localPath");
        }
        if (Strings.isBlank((CharSequence)(string = rpcPackage.getString("packageName")))) {
            String string2 = packageElement.getQualifiedName().toString();
        }
        if (rpcPackage.getBoolean("merge").booleanValue()) {
            String interfaceName = rpcPackage.getString("name");
            if (Strings.isBlank((CharSequence)interfaceName)) {
                interfaceName = Strings.upperFirst((CharSequence)packageElement.getSimpleName().toString()) + "Client";
            }
            this.exportTo(rpcPackage, outputPath, (String)var8_11, interfaceName, exportClazz);
        } else {
            for (Element e : exportClazz) {
                String interfaceName = "I" + Strings.upperFirst((CharSequence)e.getSimpleName().toString()) + "Client";
                this.exportTo(rpcPackage, outputPath, (String)var8_11, interfaceName, Lang.list((Object[])new Element[]{e}));
            }
        }
        this.info(Ansi.from((AnsiColor)AnsiColor.BG_CYAN).set(AnsiColor.FG_BLACK).val("===================EMIT FILE================"));
        AllModules.getInstance().emitToPath(outputPath);
    }

    private void exportTo(AnnotationHolder rpcPackageHolder, String outputPath, String packageName, String interfaceName, List<Element> list) {
        AnnotationSpec.Builder rpcInterfaceAnnotationBuilder;
        String modulePackagename = packageName + ".module";
        TypeSpec.Builder typeSpecBuilder = TypeSpec.interfaceBuilder((String)interfaceName);
        typeSpecBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        String oldJavaFilePath = outputPath + "/" + packageName.replaceAll("\\.", "/") + "/" + interfaceName + ".java";
        File file = new File(oldJavaFilePath);
        String proxyPackage = rpcPackageHolder.getString("proxyPackage");
        String url = "";
        String proxyName = rpcPackageHolder.getString("proxyName");
        boolean enabled = true;
        if (file.exists()) {
            String oldSource = Files.read((File)file);
            Pattern pn = Pattern.compile("packageName\\s=\\s\"(.*)\"");
            Pattern cn = Pattern.compile("className\\s=\\s\"(.*)\"");
            Pattern un = Pattern.compile("url\\s*=\\s*\"(.*)\"");
            Pattern enabledpat = Pattern.compile("enabled\\s*=\\s*(.*)\\s");
            Matcher matcher = pn.matcher(oldSource);
            if (matcher.find()) {
                proxyPackage = matcher.group(1);
            }
            if ((matcher = cn.matcher(oldSource)).find()) {
                proxyName = matcher.group(1);
            }
            if ((matcher = un.matcher(oldSource)).find()) {
                url = matcher.group(1);
            }
            if ((matcher = enabledpat.matcher(oldSource)).find()) {
                enabled = Boolean.parseBoolean(matcher.group(1));
            }
        }
        if (rpcPackageHolder.getBoolean("merge").booleanValue()) {
            rpcInterfaceAnnotationBuilder = AnnotationSpec.builder(RpcProxy.class);
            rpcInterfaceAnnotationBuilder.addMember("url", "$S", new Object[]{url});
            rpcInterfaceAnnotationBuilder.addMember("packageName", "$S", new Object[]{proxyPackage});
            rpcInterfaceAnnotationBuilder.addMember("className", "$S", new Object[]{proxyName});
            rpcInterfaceAnnotationBuilder.addMember("enabled", "$L", new Object[]{enabled + ""});
            typeSpecBuilder.addAnnotation(rpcInterfaceAnnotationBuilder.build());
        } else {
            rpcInterfaceAnnotationBuilder = AnnotationSpec.builder(RpcProxy.class);
            rpcInterfaceAnnotationBuilder.addMember("url", "$S", new Object[]{url});
            rpcInterfaceAnnotationBuilder.addMember("packageName", "$S", new Object[]{proxyPackage});
            rpcInterfaceAnnotationBuilder.addMember("className", "$S", new Object[]{proxyName});
            rpcInterfaceAnnotationBuilder.addMember("enabled", "$L", new Object[]{enabled + ""});
            typeSpecBuilder.addAnnotation(rpcInterfaceAnnotationBuilder.build());
        }
        ArrayList<String> allMethods = new ArrayList<String>();
        int index = 0;
        this.info("Total classes :" + list.size());
        for (Element e : list) {
            this.processClazz(++index, modulePackagename, allMethods, typeSpecBuilder, e);
        }
        try {
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpecBuilder.build()).build();
            if (Strings.isBlank((CharSequence)outputPath)) {
                javaFile.writeTo(this.processingEnv.getFiler());
            } else {
                javaFile.writeTo(new File(outputPath));
            }
        }
        catch (Exception e) {
            this.info("Failed to export Interface ");
            e.printStackTrace();
        }
    }

    private void processClazz(int index, String packageName, List<String> allMethods, TypeSpec.Builder typeSpecBuilder, Element e) {
        AnnotationHolder rootRestController;
        String rootPath = "";
        String rootMethod = "GET";
        String acceptContent = "text/plain";
        this.info(BLUE.val("Parse Class " + index + "\t" + e.asType().toString()));
        AnnotationHolder rootMapping = AnnotationHolder.createFromElement(e, RequestMapping.class);
        List<String> paths = rootMapping.getStrings("value");
        List<VariableElement> methods = rootMapping.getEnums("method");
        if (paths.size() > 0) {
            rootPath = paths.get(0);
        }
        if (methods.size() > 0) {
            rootMethod = methods.get(0).getSimpleName().toString();
        }
        if ((rootRestController = AnnotationHolder.createFromElement(e, RestController.class)).isPresent()) {
            acceptContent = "application/json";
        }
        for (Element element : e.getEnclosedElements()) {
            List<String> _paths;
            if (!element.getKind().equals((Object)ElementKind.METHOD) || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            String name = element.getSimpleName().toString();
            this.info(RED.val("\tMethod " + name));
            String method = rootMethod;
            String content = acceptContent;
            String path = rootPath;
            boolean haspc = MoreElements.isAnnotationPresent((Element)element, RpcIgnore.class);
            if (haspc) {
                this.info(WARNING.val("Ignore Method " + name));
                continue;
            }
            AnnotationHolder getMapping = AnnotationHolder.createFromElement(element, GetMapping.class);
            AnnotationHolder postMapping = AnnotationHolder.createFromElement(element, PostMapping.class);
            AnnotationHolder requestMapping = AnnotationHolder.createFromElement(element, RequestMapping.class);
            AnnotationHolder responseBody = AnnotationHolder.createFromElement(element, ResponseBody.class);
            if (responseBody.isPresent()) {
                content = "application/json";
            }
            if (getMapping.isPresent()) {
                method = "GET";
                _paths = getMapping.getStrings("value");
                if (_paths.size() > 0) {
                    path = path + "/" + _paths.get(0);
                }
            } else if (postMapping.isPresent()) {
                method = "POST";
                _paths = postMapping.getStrings("value");
                if (_paths.size() > 0) {
                    path = path + "/" + _paths.get(0);
                }
            } else {
                List<String> _paths2;
                if (!requestMapping.isPresent()) continue;
                List<VariableElement> _methods = requestMapping.getEnums("method");
                if (_methods.size() > 0) {
                    method = _methods.get(0).getSimpleName().toString();
                }
                if ((_paths2 = requestMapping.getStrings("value")).size() > 0) {
                    path = path + "/" + _paths2.get(0);
                }
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name);
            ExecutableElement executableElement = (ExecutableElement)element;
            this.info(GREEN.val("\t\t Return " + executableElement.getReturnType().toString()));
            this.processReturnValueType(packageName, methodBuilder, executableElement.getReturnType());
            List<? extends VariableElement> parameters = executableElement.getParameters();
            VariableElement bodyElement = null;
            for (int i = 0; i < parameters.size(); ++i) {
                VariableElement variableElement = parameters.get(i);
                this.info(GREEN.val("\t\t Parameter " + variableElement.asType().toString()));
                AnnotationHolder requestBody = AnnotationHolder.createFromElement(variableElement, RequestBody.class);
                if (requestBody.isPresent()) {
                    bodyElement = variableElement;
                    continue;
                }
                String pname = variableElement.getSimpleName().toString();
                String packName = variableElement.asType().toString();
                if (packName.startsWith("javax.servlet") || packName.startsWith("org.spring")) continue;
                AnnotationHolder pathVariable = AnnotationHolder.createFromElement(variableElement, PathVariable.class);
                if (pathVariable.isPresent() && pathVariable.getString("value").length() > 0) {
                    pname = pathVariable.getString("value");
                }
                TypeName paramTypeName = this.parseParameter(packageName, variableElement);
                methodBuilder.addParameter(paramTypeName, pname, new Modifier[0]);
            }
            if (bodyElement != null) {
                String pname = bodyElement.getSimpleName().toString();
                AnnotationHolder pathVariable = AnnotationHolder.createFromElement(bodyElement, PathVariable.class);
                if (pathVariable.isPresent() && pathVariable.getString("value").length() > 0) {
                    pname = pathVariable.getString("value");
                }
                TypeName paramTypeName = this.parseParameter(packageName, bodyElement);
                methodBuilder.addParameter(paramTypeName, pname, new Modifier[0]);
            }
            path = path.replaceAll("[/]{2,}", "/");
            AnnotationSpec.Builder rpcEntryBuilder = AnnotationSpec.builder(RpcEntry.class);
            rpcEntryBuilder.addMember("path", "$S", new Object[]{path});
            if (!method.equals("POST")) {
                rpcEntryBuilder.addMember("method", "$S", new Object[]{method});
            }
            if (!content.equals("application/json")) {
                rpcEntryBuilder.addMember("contentType", "$S", new Object[]{content});
            }
            methodBuilder.addAnnotation(rpcEntryBuilder.build());
            methodBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
            typeSpecBuilder.addMethod(methodBuilder.build());
        }
    }

    private TypeName parseParameter(String packageName, VariableElement variableElement) {
        TypeMirrorVisitor visitor = new TypeMirrorVisitor(this.processingEnv);
        TypeName typeName = visitor.parse(packageName, variableElement.asType());
        return typeName;
    }

    private void processReturnValueType(String packageName, MethodSpec.Builder methodBuilder, TypeMirror returnType) {
        TypeMirrorVisitor visitor = new TypeMirrorVisitor(this.processingEnv);
        TypeName typeName = visitor.parse(packageName, returnType);
        methodBuilder.returns(typeName);
    }

    private boolean isController(AnnotationHolder rpcPackage, Element element) {
        boolean hasController = MoreElements.isAnnotationPresent((Element)element, Controller.class);
        boolean hasRestController = MoreElements.isAnnotationPresent((Element)element, RestController.class);
        boolean haspc = MoreElements.isAnnotationPresent((Element)element, RpcIgnore.class);
        if (!hasController && !hasRestController || haspc) {
            return false;
        }
        List<DeclaredType> includes = rpcPackage.getClasses("includes");
        for (DeclaredType clazz : includes) {
            if (!clazz.asElement().getSimpleName().toString().equals(element.getSimpleName().toString())) continue;
            return true;
        }
        List<DeclaredType> excludes = rpcPackage.getClasses("excludes");
        for (DeclaredType clazz : excludes) {
            if (!clazz.asElement().getSimpleName().toString().equals(element.getSimpleName().toString())) continue;
            return false;
        }
        return true;
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private void info(String msg) {
        Logs.getLog((String)"MG").info((Object)msg);
    }

    private void warning(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg, element, annotation);
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    public static void main(String[] args) {
        String oldSource;
        String file = "E:\\dev\\mapway-gwt-test\\src\\main\\java\\cn\\mapway\\test\\client\\code\\IHelloWorld.java";
        Pattern un = Pattern.compile("url\\s*=\\s*\"(.*)\"");
        Matcher matcher = un.matcher(oldSource = Files.read((String)file));
        if (matcher.find()) {
            System.out.println("found old source pn: " + matcher.group(1));
        } else {
            System.out.println("not match");
        }
    }
}

