/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.spring.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.AnnotationValues;
import com.google.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;

public class AnnotationHolder {
    Map<ExecutableElement, AnnotationValue> valuesWithDefaults = new HashMap<ExecutableElement, AnnotationValue>();
    boolean hasValues = false;

    public static AnnotationHolder createFromElement(Element element, Class<? extends Annotation> annotation) {
        AnnotationHolder annotationHolder = new AnnotationHolder();
        com.google.common.base.Optional rpcPackage = MoreElements.getAnnotationMirror((Element)element, annotation);
        if (!rpcPackage.isPresent()) {
            annotationHolder.hasValues = false;
            return annotationHolder;
        }
        annotationHolder.hasValues = true;
        annotationHolder.valuesWithDefaults = AnnotationMirrors.getAnnotationValuesWithDefaults((AnnotationMirror)((AnnotationMirror)rpcPackage.get()));
        return annotationHolder;
    }

    public boolean isPresent() {
        return this.hasValues;
    }

    public Boolean getBoolean(String fieldName) {
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getBoolean((AnnotationValue)annotationValue);
        }
        return false;
    }

    public String getString(String fieldName) {
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getString((AnnotationValue)annotationValue);
        }
        return "";
    }

    public List<String> getStrings(String fieldName) {
        ArrayList<String> result = new ArrayList<String>();
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getStrings((AnnotationValue)annotationValue);
        }
        return result;
    }

    public List<VariableElement> getEnums(String fieldName) {
        ArrayList<VariableElement> result = new ArrayList<VariableElement>();
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getEnums((AnnotationValue)annotationValue);
        }
        return result;
    }

    public List<Integer> getIntegers(String fieldName) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getInts((AnnotationValue)annotationValue);
        }
        return result;
    }

    public Integer getInteger(String fieldName) {
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getInt((AnnotationValue)annotationValue);
        }
        return 0;
    }

    public List<Boolean> getBooleans(String fieldName) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getBooleans((AnnotationValue)annotationValue);
        }
        return result;
    }

    public List<DeclaredType> getClasses(String fieldName) {
        ArrayList<DeclaredType> result = new ArrayList<DeclaredType>();
        Optional<ExecutableElement> includes = this.valuesWithDefaults.keySet().stream().filter(key -> key.getSimpleName().toString().equals(fieldName)).findAny();
        if (includes.isPresent()) {
            AnnotationValue annotationValue = this.valuesWithDefaults.get(includes.get());
            return AnnotationValues.getTypeMirrors((AnnotationValue)annotationValue);
        }
        return result;
    }
}

