package cn.mapway.maven;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import java.io.File;

/**
 * 输出构建信息类
 */
@Mojo(name = BuildInformation.MOJO_NAME)
public class BuildInformation extends AbstractMojo {
    public final static String MOJO_NAME="build-information";

    /**
     * The path.
     */
    @Parameter(defaultValue = "${project.basedir}/src/main/java", property = "path", required = true)
    private String path;
    /**
     * The package name.
     */
    @Parameter(defaultValue = "cn.mapway.dynamic", property = "packageName", required = true)
    private String packageName;


    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log logger = getLog();

        String targeFileName=makePathFile(path,packageName,"BuildData");
        
    }

    /**
     * 构造文件路径.
     *
     * @param javaConnectorSourcePath the java connector source path
     * @param packageName             the package name
     * @param className               the class name
     * @return the string
     */
    public static String makePathFile(String javaConnectorSourcePath, String packageName,
                                      String className) {
        String p = packageName.replace(".", File.separator);
        return javaConnectorSourcePath + File.separator + p + File.separator + className + ".java";
    }
}
