/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.maven;

import cn.mapway.document.helper.GwtConnextorExport;
import cn.mapway.document.helper.JavaClassContent;
import cn.mapway.document.helper.JavaConnextorExport;
import cn.mapway.document.module.ApiDoc;
import java.io.File;
import java.io.Reader;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nutz.http.Http;
import org.nutz.http.Response;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.lang.Strings;

@Mojo(name="genconnector", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenConnector
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/java", property="path", required=true)
    private String path;
    @Parameter(defaultValue="", property="apiUrl", required=true)
    private String apiUrl;
    @Parameter(defaultValue="", property="packageName", required=true)
    private String packageName;
    @Parameter(defaultValue="Connector", property="className", required=true)
    private String className;
    @Parameter(defaultValue="gwt", property="contype", required=true)
    private String contype;

    public void execute() throws MojoExecutionException {
        Log logger = this.getLog();
        if (this.contype.compareTo("gwt") == 0) {
            this.exportGwtConnector(logger);
        } else if (this.contype.compareToIgnoreCase("java") == 0) {
            this.exportJavaConnector(logger);
        } else {
            logger.error((CharSequence)("unsupport connection type " + this.contype + " ,current support gwt java"));
        }
    }

    private void exportJavaConnector(Log logger) {
        JavaConnextorExport exportJava = new JavaConnextorExport();
        if (Strings.isBlank((CharSequence)this.apiUrl)) {
            logger.info((CharSequence)"apiurl \u914d\u7f6e\u4e3a\u7a7a\u5b57\u7b26\u4e32,\u53d6\u6d88\u672c\u6b21\u8bbf\u95ee\u4ee3\u7801\u751f\u6210");
            return;
        }
        Response res = Http.get((String)this.apiUrl);
        if (!res.isOK()) {
            logger.info((CharSequence)("\u83b7\u53d6API\u6587\u6863\u4fe1\u606f" + this.apiUrl + "\u9519\u8bef:" + res.getStatus()));
            return;
        }
        ApiDoc doc = (ApiDoc)Json.fromJson(ApiDoc.class, (Reader)res.getReader());
        if (doc == null) {
            logger.info((CharSequence)("\u83b7\u53d6API\u6587\u6863\u4fe1\u606f" + this.apiUrl + "\u9519\u8bef:" + res.getContent()));
            return;
        }
        List codes = exportJava.export2(doc, this.packageName, this.className);
        for (JavaClassContent jcc : codes) {
            String fileName = GenConnector.makePathFile(this.path, jcc.packageName, jcc.className);
            logger.info((CharSequence)("\u751f\u6210JavaAPI\u7684\u4ee3\u7406\u63a5\u53e3" + this.className + "-->" + fileName));
            Files.write((String)fileName, (Object)jcc.body);
        }
    }

    private void exportGwtConnector(Log logger) {
        GwtConnextorExport exportJava = new GwtConnextorExport();
        if (Strings.isBlank((CharSequence)this.apiUrl)) {
            logger.info((CharSequence)"apiurl \u914d\u7f6e\u4e3a\u7a7a\u5b57\u7b26\u4e32,\u53d6\u6d88\u672c\u6b21\u8bbf\u95ee\u4ee3\u7801\u751f\u6210");
            return;
        }
        Response res = Http.get((String)this.apiUrl);
        if (!res.isOK()) {
            logger.info((CharSequence)("\u83b7\u53d6API\u6587\u6863\u4fe1\u606f" + this.apiUrl + "\u9519\u8bef:" + res.getStatus()));
            return;
        }
        ApiDoc doc = (ApiDoc)Json.fromJson(ApiDoc.class, (Reader)res.getReader());
        if (doc == null) {
            logger.info((CharSequence)("\u83b7\u53d6API\u6587\u6863\u4fe1\u606f" + this.apiUrl + "\u9519\u8bef:" + res.getContent()));
            return;
        }
        List codes = exportJava.export2(doc, this.packageName, this.className);
        for (JavaClassContent jcc : codes) {
            String fileName = GenConnector.makePathFile(this.path, jcc.packageName, jcc.className);
            logger.info((CharSequence)("\u751f\u6210API\u7684\u4ee3\u7406\u63a5\u53e3" + this.className + "-->" + fileName));
            Files.write((String)fileName, (Object)jcc.body);
        }
    }

    public static String makePathFile(String javaConnectorSourcePath, String packageName, String className) {
        String p = packageName.replace(".", File.separator);
        return javaConnectorSourcePath + File.separator + p + File.separator + className + ".java";
    }
}

