/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.test;

import cn.mapway.document.ui.client.main.storage.LocalStorage;
import cn.mapway.document.ui.client.test.HistoryData;
import cn.mapway.document.ui.client.test.HistoryItem;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;

public class InputHistoryPanel
extends Composite
implements HasSelectionHandlers<HistoryData>,
HasValueChangeHandlers<Integer> {
    private static InputHistoryPanelUiBinder uiBinder = (InputHistoryPanelUiBinder)GWT.create(InputHistoryPanelUiBinder.class);
    HistoryItem current = null;
    @UiField
    HTMLPanel content;
    private ClickHandler itemClick = new ClickHandler(){

        public void onClick(ClickEvent event) {
            HistoryItem item = (HistoryItem)((Object)event.getSource());
            SelectionEvent.fire((HasSelectionHandlers)InputHistoryPanel.this, (Object)item.getData());
        }
    };
    private CloseHandler<HistoryData> itemDelete = new CloseHandler<HistoryData>(){

        public void onClose(CloseEvent<HistoryData> closeEvent) {
            InputHistoryPanel.this.saveCurrentHistory();
        }
    };
    private String mRelativePath = "";

    public HandlerRegistration addSelectionHandler(SelectionHandler<HistoryData> selectionHandler) {
        return this.addHandler((EventHandler)selectionHandler, SelectionEvent.getType());
    }

    public String get(int i) {
        if (i >= 0 && i < this.getHistoryCount()) {
            HistoryItem item = (HistoryItem)this.content.getWidget(i);
            return item.mData.value;
        }
        return "";
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Integer> valueChangeHandler) {
        return this.addHandler((EventHandler)valueChangeHandler, ValueChangeEvent.getType());
    }

    public InputHistoryPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    private void saveCurrentHistory() {
        String fullData = "";
        for (int i = 0; i < this.getHistoryCount(); ++i) {
            HistoryItem item = (HistoryItem)this.content.getWidget(i);
            fullData = i == 0 ? item.mData.title + "`" + item.mData.value : "|" + item.mData.title + "`" + item.mData.value;
        }
        LocalStorage.save(this.mRelativePath, fullData);
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getHistoryCount());
    }

    public void cleatContent() {
        this.content.clear();
    }

    public void addItem(String title, String value) {
        HistoryItem item = new HistoryItem();
        HistoryData hd = new HistoryData(title, value);
        item.render(hd);
        item.addClickHandler(this.itemClick);
        item.addCloseHandler(this.itemDelete);
        this.content.add((Widget)item);
    }

    public int getHistoryCount() {
        return this.content.getWidgetCount();
    }

    public void render(String relativePath) {
        this.content.clear();
        this.mRelativePath = relativePath;
        String v = LocalStorage.val(relativePath);
        if (v == null || v.length() == 0) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)0);
            return;
        }
        String[] vs = v.split("\\|");
        for (int index = 0; index < vs.length; ++index) {
            String[] itemdata = vs[index].split("`");
            if (itemdata.length > 1) {
                this.addItem(itemdata[0], itemdata[1]);
                continue;
            }
            this.addItem(itemdata[0], "");
        }
        if (vs.length > 10) {
            String fulldata = "";
            for (int i = 0; i < 10; ++i) {
                fulldata = i == 0 ? vs[i] : "|" + vs[i];
            }
            LocalStorage.save(relativePath, fulldata);
        }
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getHistoryCount());
    }

    static interface InputHistoryPanelUiBinder
    extends UiBinder<Widget, InputHistoryPanel> {
    }
}

