/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.component.ace;

import cn.mapway.document.ui.client.component.ace.AceEditor;
import com.google.gwt.core.client.JavaScriptObject;

public class AceCommandDescription {
    private final String name;
    private final ExecAction exec;
    private KeyBinding bindKey = null;
    private boolean readOnly = false;
    private boolean passEvent = false;
    private ScrollIntoView scrollIntoView = null;
    private MultiSelectAction multiSelectAction = null;
    private String aceCommandGroup = null;

    public AceCommandDescription(String name, ExecAction exec) {
        this.name = name;
        this.exec = exec;
    }

    public String getName() {
        return this.name;
    }

    public ExecAction getExec() {
        return this.exec;
    }

    public KeyBinding getBindKey() {
        return this.bindKey;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isPassEvent() {
        return this.passEvent;
    }

    public ScrollIntoView getScrollIntoView() {
        return this.scrollIntoView;
    }

    public MultiSelectAction getMultiSelectAction() {
        return this.multiSelectAction;
    }

    public String getAceCommandGroup() {
        return this.aceCommandGroup;
    }

    public AceCommandDescription withBindKey(KeyBinding bindKey) {
        this.bindKey = bindKey;
        return this;
    }

    public AceCommandDescription withBindKey(String bindKeyForAllPlatforms) {
        this.bindKey = new KeyBinding(bindKeyForAllPlatforms);
        return this;
    }

    public AceCommandDescription withBindKey(String bindKeyForAllPlatformsExceptMac, String bindKeyForMac) {
        this.bindKey = new KeyBinding(bindKeyForAllPlatformsExceptMac, bindKeyForMac);
        return this;
    }

    public AceCommandDescription withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public AceCommandDescription withPassEvent(boolean passEvent) {
        this.passEvent = passEvent;
        return this;
    }

    public AceCommandDescription withScrollIntoView(ScrollIntoView scrollIntoView) {
        this.scrollIntoView = scrollIntoView;
        return this;
    }

    public AceCommandDescription withMultiSelectAction(MultiSelectAction multiSelectAction) {
        this.multiSelectAction = multiSelectAction;
        return this;
    }

    public AceCommandDescription withAceCommandGroup(String aceCommandGroup) {
        this.aceCommandGroup = aceCommandGroup;
        return this;
    }

    public String toString() {
        return "AceCommandDescription [name=" + this.name + ", exec=" + this.exec + ", bindKey=" + this.bindKey + ", readOnly=" + this.readOnly + ", passEvent=" + this.passEvent + ", scrollIntoView=" + (Object)((Object)this.scrollIntoView) + ", multiSelectAction=" + (Object)((Object)this.multiSelectAction) + ", aceCommandGroup=" + this.aceCommandGroup + "]";
    }

    public static native AceCommandDescription fromJavaScript(JavaScriptObject var0);

    private static ExecAction createJavaScriptWrapper(final Object jsFunction) {
        return new ExecAction(){

            @Override
            public Object exec(AceEditor editor) {
                return AceCommandDescription.invokeJavaScriptCommand(jsFunction, editor);
            }

            public String toString() {
                return "ExecAction [javascript=" + jsFunction + "]";
            }
        };
    }

    private static native Object invokeJavaScriptCommand(Object var0, AceEditor var1);

    public native JavaScriptObject toJavaScript(AceEditor var1);

    public static enum MultiSelectAction {
        forEach,
        forEachLine,
        single;


        public static MultiSelectAction fromString(String value) {
            for (MultiSelectAction ret : MultiSelectAction.values()) {
                if (!ret.name().equals(value)) continue;
                return ret;
            }
            return null;
        }
    }

    public static enum ScrollIntoView {
        animate,
        center,
        cursor,
        selectionPart;


        public static ScrollIntoView fromString(String value) {
            for (ScrollIntoView ret : ScrollIntoView.values()) {
                if (!ret.name().equals(value)) continue;
                return ret;
            }
            return null;
        }
    }

    public static interface ExecAction {
        public Object exec(AceEditor var1);
    }

    public static class KeyBinding {
        private final String allPlatforms;
        private final String mac;
        private final String exceptMac;

        public KeyBinding(String allPlatforms) {
            this.allPlatforms = allPlatforms;
            this.mac = null;
            this.exceptMac = null;
        }

        public KeyBinding(String exceptMac, String mac) {
            this.allPlatforms = null;
            this.mac = mac;
            this.exceptMac = exceptMac;
        }

        public String getAllPlatforms() {
            return this.allPlatforms;
        }

        public String getMac() {
            return this.mac;
        }

        public String getExceptMac() {
            return this.exceptMac;
        }

        public String toString() {
            if (this.allPlatforms != null) {
                return "KeyBinding [allPlatforms=" + this.allPlatforms + "]";
            }
            return "KeyBinding [mac=" + this.mac + ", exceptMac=" + this.exceptMac + "]";
        }

        private static native KeyBinding fromJavaScript(Object var0);

        private native Object toJavaScript();
    }
}

