/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.test;

import cn.mapway.document.ui.client.component.Clients;
import cn.mapway.document.ui.client.main.JsonPanel;
import cn.mapway.document.ui.client.main.storage.LocalStorage;
import cn.mapway.document.ui.client.module.Entry;
import cn.mapway.document.ui.client.module.ObjectInfo;
import cn.mapway.document.ui.client.resource.SysResource;
import cn.mapway.document.ui.client.rpc.ApiDocProxy;
import cn.mapway.document.ui.client.rpc.IOnData;
import cn.mapway.document.ui.client.rpc.RpcContext;
import cn.mapway.document.ui.client.test.HistoryData;
import cn.mapway.document.ui.client.test.InputHistoryPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;

public class TestPanel
extends Composite
implements HasCloseHandlers<Void> {
    public static final String GWT_USER_HEADER = "gwt_user_token";
    private static TestPanelUiBinder uiBinder = (TestPanelUiBinder)GWT.create(TestPanelUiBinder.class);
    @UiField
    Label lbTitle;
    @UiField
    Label lbUrl;
    @UiField
    TextArea txtInput;
    @UiField
    JsonPanel txtOutput;
    Entry mEntry;
    @UiField
    Button btnExecute;
    @UiField
    Button btnClose;
    @UiField
    Image imgLoadding;
    @UiField
    Image btnHistory;
    @UiField
    TextBox txtHeader;
    @UiField
    TextBox txtHeaderValue;
    PopupPanel pop = null;
    InputHistoryPanel historyPanel;
    private CloseHandler<HistoryData> itemSelected = new CloseHandler<HistoryData>(){

        public void onClose(CloseEvent<HistoryData> event) {
            TestPanel.this.txtInput.setValue((Object)((HistoryData)event.getTarget()).value);
            TestPanel.this.pop.hide();
        }
    };

    public TestPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.btnExecute.setStyleName(SysResource.INSTANCE.getCss().btn());
        this.btnClose.setStyleName(SysResource.INSTANCE.getCss().btn());
        this.imgLoadding.setUrl(SysResource.INSTANCE.loading().getSafeUri());
        this.btnHistory.setUrl(SysResource.INSTANCE.history().getSafeUri());
        this.txtHeader.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                TestPanel.this.saveHeader();
            }
        });
        this.txtHeaderValue.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                TestPanel.this.saveHeader();
            }
        });
    }

    protected void saveHeader() {
        String key = this.txtHeader.getValue();
        String value = this.txtHeaderValue.getValue();
        if (key != null && key.length() > 0 && value != null && value.length() > 0) {
            RpcContext context = RpcContext.get();
            context.KEY = key;
            context.VALUE = value;
            LocalStorage.save(GWT_USER_HEADER, context.KEY);
            LocalStorage.save(context.KEY, value);
        }
    }

    private void loadHeader() {
        String key = LocalStorage.val(GWT_USER_HEADER);
        if (key != null && key.length() > 0) {
            this.txtHeader.setValue((Object)key);
            this.txtHeaderValue.setValue((Object)LocalStorage.val(key));
        }
    }

    public void invoke(Entry entry) {
        this.loadHeader();
        this.mEntry = entry;
        this.lbTitle.setText(entry.title());
        this.lbUrl.setText(Clients.getHostPort() + entry.url());
        String his = this.readHistory();
        if (his.length() == 0) {
            his = ((ObjectInfo)entry.input().get(0)).json();
        }
        this.txtInput.setValue((Object)his);
        this.txtOutput.setString("");
    }

    private String readHistory() {
        String r = "";
        String v = LocalStorage.val(this.mEntry.relativePath());
        if (v == null || v.length() == 0) {
            return "";
        }
        String[] vs = v.split("\\|");
        if (vs.length > 0) {
            String[] itemdata = vs[0].split("`");
            r = itemdata[1];
            return r;
        }
        return r;
    }

    @UiHandler(value={"btnExecute"})
    void onExecute(ClickEvent ev) {
        this.imgLoadding.setVisible(true);
        this.txtOutput.setText("");
        String v = LocalStorage.val(this.mEntry.relativePath());
        Date d = new Date();
        String key = d.getYear() + 1900 + "-" + (d.getMonth() + 1) + "-" + d.getDate() + " " + d.getHours() + ":" + d.getMinutes() + ":" + d.getSeconds();
        String va = this.txtInput.getValue();
        if (v == null || v.length() == 0) {
            LocalStorage.save(this.mEntry.relativePath(), key + "`" + va);
        } else {
            LocalStorage.save(this.mEntry.relativePath(), key + "`" + va + "|" + v);
        }
        try {
            ApiDocProxy.fetchString(this.mEntry.url(), this.txtInput.getValue(), "", this.mEntry.invokeMethods().get(0), new IOnData<String>(){

                @Override
                public void onError(String url, String error) {
                    TestPanel.this.txtOutput.setString(error);
                    TestPanel.this.imgLoadding.setVisible(false);
                }

                @Override
                public void onSuccess(String url, String data) {
                    JavaScriptObject jso = JsonUtils.unsafeEval((String)data);
                    TestPanel.this.txtOutput.setJson(JsonUtils.stringify((JavaScriptObject)jso, (String)"   "));
                    TestPanel.this.imgLoadding.setVisible(false);
                    TestPanel.this.processToken(url, data);
                }
            });
        }
        catch (RequestException e) {
            this.txtOutput.setString(e.getMessage());
            this.imgLoadding.setVisible(false);
        }
    }

    protected void processToken(String url, String data) {
    }

    @UiHandler(value={"btnClose"})
    void onClose(ClickEvent ev) {
        CloseEvent.fire((HasCloseHandlers)this, null);
    }

    public HandlerRegistration addCloseHandler(CloseHandler<Void> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    @UiHandler(value={"btnHistory"})
    void onHistory(ClickEvent e) {
        if (this.pop == null) {
            this.pop = new PopupPanel(true, true);
            this.historyPanel = new InputHistoryPanel();
            this.historyPanel.addCloseHandler(this.itemSelected);
            this.pop.add((Widget)this.historyPanel);
        }
        this.pop.showRelativeTo((UIObject)this.btnHistory);
        this.historyPanel.render(this.mEntry.relativePath());
    }

    static interface TestPanelUiBinder
    extends UiBinder<Widget, TestPanel> {
    }
}

