/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.test;

import cn.mapway.document.ui.client.main.storage.LocalStorage;
import cn.mapway.document.ui.client.test.HistoryData;
import cn.mapway.document.ui.client.test.HistoryItem;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;

public class InputHistoryPanel
extends Composite
implements HasCloseHandlers<HistoryData> {
    private static InputHistoryPanelUiBinder uiBinder = (InputHistoryPanelUiBinder)GWT.create(InputHistoryPanelUiBinder.class);
    HistoryItem current = null;
    @UiField
    HTMLPanel content;
    private ClickHandler itemClick = new ClickHandler(){

        public void onClick(ClickEvent event) {
            HistoryItem item = (HistoryItem)((Object)event.getSource());
            CloseEvent.fire((HasCloseHandlers)InputHistoryPanel.this, (Object)item.getData());
        }
    };

    public InputHistoryPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void cleatContent() {
        this.content.clear();
    }

    public void addItem(String title, String value) {
        HistoryItem item = new HistoryItem();
        HistoryData hd = new HistoryData(title, value);
        item.render(hd);
        item.addClickHandler(this.itemClick);
        this.content.add((Widget)item);
    }

    public HandlerRegistration addCloseHandler(CloseHandler<HistoryData> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    public void render(String relativePath) {
        this.content.clear();
        String v = LocalStorage.val(relativePath);
        if (v == null || v.length() == 0) {
            return;
        }
        String[] vs = v.split("\\|");
        for (int index = 0; index < vs.length; ++index) {
            String[] itemdata = vs[index].split("`");
            this.addItem(itemdata[0], itemdata[1]);
        }
        if (vs.length > 10) {
            String fulldata = "";
            for (int i = 0; i < 10; ++i) {
                fulldata = i == 0 ? vs[i] : "|" + vs[i];
            }
            LocalStorage.save(relativePath, fulldata);
        }
    }

    static interface InputHistoryPanelUiBinder
    extends UiBinder<Widget, InputHistoryPanel> {
    }
}

