/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.main;

import cn.mapway.document.ui.client.component.CustomButton;
import cn.mapway.document.ui.client.main.ApiTree;
import cn.mapway.document.ui.client.main.EntryListPanel;
import cn.mapway.document.ui.client.main.EntryPanel;
import cn.mapway.document.ui.client.module.ApiDoc;
import cn.mapway.document.ui.client.module.Entry;
import cn.mapway.document.ui.client.module.Group;
import cn.mapway.document.ui.client.module.JarInfo;
import cn.mapway.document.ui.client.resource.SysResource;
import cn.mapway.document.ui.client.rpc.ApiDocProxy;
import cn.mapway.document.ui.client.rpc.IOnData;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;

public class MainFrame
extends Composite {
    private static MainFrameUiBinder uiBinder = (MainFrameUiBinder)GWT.create(MainFrameUiBinder.class);
    TreeItem currentItem = null;
    EntryPanel entryPanel;
    private SelectionHandler<TreeItem> treeSelect = new SelectionHandler<TreeItem>(){

        public void onSelection(SelectionEvent<TreeItem> arg0) {
            TreeItem item = (TreeItem)arg0.getSelectedItem();
            if (MainFrame.this.currentItem != null) {
                MainFrame.this.currentItem.removeStyleName(SysResource.INSTANCE.getCss().entrySelected());
            }
            MainFrame.this.handleItem(item);
            MainFrame.this.currentItem = item;
            MainFrame.this.currentItem.addStyleName(SysResource.INSTANCE.getCss().entrySelected());
        }
    };
    EntryListPanel list;
    ApiDoc doc;
    private ClickHandler gotoWordHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            Window.open((String)MainFrame.this.doc.wordUrl(), (String)"wordExport", (String)"");
        }
    };
    private ClickHandler downloadLinkHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            CustomButton btn = (CustomButton)((Object)event.getSource());
            JarInfo jar = (JarInfo)((Object)btn.getData());
            Window.open((String)jar.link(), (String)"Connecgtor \u4e0b\u8f7d", (String)"");
        }
    };
    @UiField
    Label apiVersion;
    @UiField
    ApiTree apiTree;
    @UiField
    ScrollPanel content;
    @UiField
    Label lbTitle;
    @UiField
    Image logo;
    @UiField
    HorizontalPanel tools;
    @UiField
    Label lbSubtitle;
    @UiField
    HTML lbCopy;
    @UiField
    Anchor anchorDomain;
    @UiField
    HorizontalPanel topBar;
    @UiField
    DockLayoutPanel root;

    private void handleItem(TreeItem item) {
        if (item.getTitle().length() == 0) {
            Group group = (Group)((Object)item.getUserObject());
            this.showEntryList(group);
        } else {
            Entry e = (Entry)((Object)item.getUserObject());
            this.showEntry(e);
        }
    }

    private void showEntry(Entry e) {
        if (this.entryPanel == null) {
            this.entryPanel = new EntryPanel();
        }
        if (!this.entryPanel.isAttached()) {
            this.content.clear();
            this.content.add((Widget)this.entryPanel);
        }
        this.entryPanel.parse(e);
        this.content.scrollToTop();
    }

    protected void showEntryList(Group group) {
        if (this.list == null) {
            this.list = new EntryListPanel();
        }
        if (!this.list.isAttached()) {
            this.content.clear();
            this.content.add((Widget)this.list);
        }
        this.list.parse(group, "");
        this.content.scrollToTop();
    }

    public MainFrame() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.logo.setUrl(SysResource.INSTANCE.logo().getSafeUri());
        this.apiTree.addSelectionHandler(this.treeSelect);
        this.adjustUI();
    }

    private void adjustUI() {
        String showTop = Window.Location.getParameter((String)"showTop");
        if (showTop != null && showTop.length() != 0) {
            this.root.setWidgetHidden((Widget)this.topBar, true);
        }
    }

    private final native ApiDoc findDocData();

    public void init(String target) {
        ApiDoc doc = this.findDocData();
        if (doc == null) {
            ApiDocProxy.fetchData(target, new IOnData<ApiDoc>(){

                @Override
                public void onError(String url, String error) {
                    Window.alert((String)error);
                }

                @Override
                public void onSuccess(String url, ApiDoc data) {
                    MainFrame.this.parseData(data);
                }
            });
        } else {
            this.parseData(doc);
        }
    }

    void parseData(final ApiDoc doc) {
        this.doc = doc;
        JsArray<JarInfo> jars = doc.getDownloads();
        if (jars.length() > 0) {
            for (int index = 0; index < jars.length(); ++index) {
                JarInfo jar = (JarInfo)jars.get(index);
                CustomButton btn = new CustomButton(jar.summary());
                btn.setData((Object)jar);
                btn.addClickHandler(this.downloadLinkHandler);
                this.tools.add((Widget)btn);
            }
        }
        this.lbTitle.setText(doc.title());
        this.apiTree.parseData(doc);
        this.lbSubtitle.setText(doc.summary());
        if (doc.homeUrl().length() > 0) {
            this.logo.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            this.logo.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Window.Location.assign((String)doc.homeUrl());
                }
            });
        } else {
            this.logo.getElement().getStyle().setCursor(Style.Cursor.AUTO);
        }
        this.handleItem(this.apiTree.getItem(0));
        if (doc.logo() != null) {
            this.logo.setUrl(doc.logo());
        }
        this.apiVersion.setText("\u7248\u672c:" + doc.apiVersion());
        if (doc.domain() != null) {
            this.anchorDomain.setText(doc.domain());
        }
        if (doc.copyright() != null) {
            this.lbCopy.setHTML("&copy; " + doc.copyright());
        }
    }

    static interface MainFrameUiBinder
    extends UiBinder<Widget, MainFrame> {
    }
}

