/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.word;

import cn.mapway.document.helper.DocHelper;
import cn.mapway.document.helper.ParseType;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.module.Entry;
import cn.mapway.document.module.Group;
import cn.mapway.document.module.ObjectInfo;
import cn.mapway.document.parser.GenContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class WordExport {
    public void toWord(ApiDoc api, String fileName) throws IOException {
        XWPFDocument doc = new XWPFDocument();
        this.createCover(doc, api);
        this.createEntries(doc, api);
        FileOutputStream out = new FileOutputStream(fileName);
        doc.write((OutputStream)out);
        out.close();
        doc.close();
    }

    private void createEntries(XWPFDocument doc, ApiDoc api) {
        this.exportGroup(doc, api.root);
    }

    private void exportGroup(XWPFDocument doc, Group root) {
        for (Entry e : root.entries) {
            this.exportEntry(doc, e);
        }
        for (Group g : root.subGroups) {
            this.exportGroup(doc, g);
        }
    }

    private void exportEntry(XWPFDocument doc, Entry e) {
        XWPFParagraph p = doc.createParagraph();
        p.setStyle("\u6807\u98982");
        p.createRun().setText(e.title);
        doc.createParagraph();
        p = doc.createParagraph();
        p.setStyle("\u6b63\u6587");
        XWPFRun r = p.createRun();
        r.setText(e.summary);
        if (e.input.size() > 0) {
            doc.createParagraph().createRun().setText("\u8f93\u5165\u53c2\u6570");
            this.descript(doc, e.input.get(0));
        }
        doc.createParagraph().createRun().setText("\u8f93\u51fa\u53c2\u6570");
        this.descript(doc, e.output);
    }

    private void descript(XWPFDocument doc, ObjectInfo objectInfo) {
        int nRows = objectInfo.fields.size() + 2;
        int nCols = 5;
        doc.createParagraph();
        XWPFTable table = doc.createTable(nRows, nCols);
        table.setCellMargins(5, 5, 5, 5);
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        CTTblWidth w = tblPr.addNewTblW();
        w.setW(BigInteger.valueOf(5000L));
        w.setType(STTblWidth.PCT);
        List rows = table.getRows();
        int row = 0;
        int col = 0;
        XWPFTableRow r = (XWPFTableRow)rows.get(row++);
        List cells = r.getTableCells();
        XWPFTableCell cell = (XWPFTableCell)cells.get(col++);
        this.header(cell, "\u540d\u79f0");
        cell = (XWPFTableCell)cells.get(col++);
        this.header(cell, "\u7c7b\u578b");
        cell = (XWPFTableCell)cells.get(col++);
        this.header(cell, "\u957f\u5ea6");
        cell = (XWPFTableCell)cells.get(col++);
        this.header(cell, "\u9009\u9879");
        cell = (XWPFTableCell)cells.get(col++);
        this.header(cell, "\u8bf4\u660e");
        for (ObjectInfo obj : objectInfo.fields) {
            col = 0;
            r = (XWPFTableRow)rows.get(row++);
            cells = r.getTableCells();
            ((XWPFTableCell)cells.get(col++)).setText(obj.name);
            ((XWPFTableCell)cells.get(col++)).setText(obj.type);
            ((XWPFTableCell)cells.get(col++)).setText(obj.length + "");
            ((XWPFTableCell)cells.get(col++)).setText(obj.manditary ? "\u5fc5\u586b" : "\u9009\u586b");
            ((XWPFTableCell)cells.get(col++)).setText(obj.title);
        }
        doc.createParagraph();
    }

    private void header(XWPFTableCell cell, String text) {
        XWPFRun run = cell.addParagraph().createRun();
        run.setBold(true);
        run.setText(text);
        CTShd shd = cell.getCTTc().addNewTcPr().addNewShd();
        shd.setFill((Object)"F0F0F0");
        cell.removeParagraph(0);
    }

    private void createCover(XWPFDocument doc, ApiDoc api) {
        for (int i = 0; i < 10; ++i) {
            doc.createParagraph();
        }
        XWPFParagraph p1 = doc.createParagraph();
        p1.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun r1 = p1.createRun();
        r1.setBold(true);
        r1.setText(api.title + "API\u63a5\u53e3\u6587\u6863");
        r1.setBold(true);
        r1.setFontSize(34);
        r1.setFontFamily("\u9ed1\u4f53");
        r1.setTextPosition(100);
        doc.createParagraph();
        p1 = doc.createParagraph();
        p1.setAlignment(ParagraphAlignment.CENTER);
        r1 = p1.createRun();
        r1.setText("\u5f20\u5efa\u8bbe");
        p1 = doc.createParagraph();
        p1.setAlignment(ParagraphAlignment.CENTER);
        r1 = p1.createRun();
        Date d = new Date();
        r1.setText(d.toLocaleString());
        r1.addBreak(BreakType.PAGE);
    }

    public static void main(String[] args) throws IOException {
        WordExport export = new WordExport();
        DocHelper helper = new DocHelper();
        GenContext context = new GenContext();
        ApiDoc api = helper.toDoc(ParseType.PT_SPRING, context, "cn.mapway.document.test");
        export.toWord(api, "d:\\out\\1.docx");
    }
}

