/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.processor;

import cn.mapway.document.annotation.Code;
import cn.mapway.document.annotation.Codes;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"cn.mapway.document.annotation.Codes", "cn.mapway.document.annotation.Code"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
public class CodesGeneratorProcessor
extends AbstractProcessor {
    Elements utils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.utils = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, Code> codes = new HashMap<String, Code>();
        Set<? extends Element> listCodes = roundEnv.getElementsAnnotatedWith(Codes.class);
        Set<? extends Element> listCode = roundEnv.getElementsAnnotatedWith(Code.class);
        for (Element element : listCodes) {
            Codes cs = element.getAnnotation(Codes.class);
            String scope = cs.scope();
            if (scope == null) {
                scope = "";
            }
            for (Code c : cs.value()) {
                this.processCoder(codes, c, "");
            }
        }
        for (Element element : listCode) {
            Code c = element.getAnnotation(Code.class);
            this.processCoder(codes, c, "");
        }
        String className = this.processingEnv.getOptions().get("className");
        if (className == null || className.length() == 0) {
            className = "Coders";
        }
        String string = this.processingEnv.getOptions().get("packageName");
        PackageElement pkgElement = null;
        if (string != null && string.length() > 0) {
            pkgElement = this.processingEnv.getElementUtils().getPackageElement(string);
        }
        String data = this.generateCodes(codes, pkgElement, className);
        this.writeToFile(data, pkgElement, className);
        return true;
    }

    private void processCoder(Map<String, Code> codes, Code c, String scope) {
        if (c.name() == null || c.name().length() == 0) {
            return;
        }
        String key = this.buildKey(scope, c);
        if (codes.get(key) == null) {
            codes.put(key, c);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "repeat coder " + c.name());
        }
    }

    private String buildKey(String scope, Code c) {
        String key = "";
        key = c.scope() == null || c.scope().length() == 0 ? c.name() : c.scope() + "_" + c.name();
        if (scope != null && scope.length() > 0) {
            key = scope + "_" + key;
        }
        return key;
    }

    private void writeToFile(String data, PackageElement pe, String className) {
        try {
            JavaFileObject generationForPath = this.processingEnv.getFiler().createSourceFile(pe.getQualifiedName() + "." + className, new Element[0]);
            Writer writer = generationForPath.openWriter();
            writer.write(data);
            writer.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private String generateCodes(Map<String, Code> codes, PackageElement pkgElement, String className) {
        StringBuilder sb = new StringBuilder();
        sb.append("/**\r\n  *\u7f16\u8bd1\u5668\u81ea\u52a8\u751f\u6210\u6b64\u4ee3\u7801\uff0c\u8bf7\u52ff\u7f16\u8f91\u6b64\u6587\u4ef6 contact to :15910868680@163.com\r\n*/\r\n");
        if (pkgElement != null) {
            sb.append("package " + pkgElement.getQualifiedName() + ";\r\n");
        }
        sb.append("import cn.mapway.document.coder.Coder;\r\n");
        sb.append("/**\r\n");
        sb.append("* \u81ea\u52a8\u751f\u6210\u7684\u4ee3\u7801\u7c7b\r\n");
        sb.append("*/\r\n");
        sb.append("public class " + className + "{\r\n");
        for (String key : codes.keySet()) {
            Code c = codes.get(key);
            if (c.name().length() <= 0) continue;
            sb.append("\t public final static Coder " + key + " = new Coder(\"" + c.value() + "\",\"" + c.desc() + "\");\r\n");
        }
        sb.append("}\r\n");
        return sb.toString();
    }
}

