/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import cn.mapway.document.helper.ParseType;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.parser.GenContext;
import cn.mapway.document.parser.SpringParser;
import cn.mapway.document.resource.Template;
import java.io.IOException;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;

public class DocHelper {
    public ApiDoc toDoc(ParseType pt, GenContext context, String ... packages) {
        if (pt == ParseType.PT_SPRING) {
            SpringParser parser = new SpringParser();
            ApiDoc doc = new ApiDoc();
            try {
                doc = parser.parse(context, packages);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return doc;
        }
        return new ApiDoc();
    }

    public String genHTML(ParseType pt, GenContext context, String ... packages) {
        ApiDoc doc = this.toDoc(pt, context, packages);
        try {
            String template = Template.readTemplate("/cn/mapway/document/resource/doctemplate.html");
            String ui = Template.readTemplate("/cn/mapway/document/resource/apidoc.nocache.js");
            String json = Json.toJson((Object)doc, (JsonFormat)JsonFormat.full());
            template = template.replace("API_DOC_DATA", json);
            template = template.replace("API_DOC_UI", ui);
            return template;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

