/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import cn.mapway.document.helper.ParseType;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.parser.GenContext;
import cn.mapway.document.parser.SpringParser;
import cn.mapway.document.resource.Template;
import cn.mapway.document.word.WordExport;
import java.io.IOException;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;

public class DocHelper {
    private static byte[] gifdata = new byte[]{71, 73, 70, 56, 57, 97, 1, 0, 1, 0, -128, 0, 0, -1, -1, -1, -1, -1, -1, 33, -7, 4, 1, 10, 0, 1, 0, 44, 0, 0, 0, 0, 1, 0, 1, 0, 0, 2, 2, 76, 1, 0, 59};

    public void toWord(ApiDoc api, String fileName) throws IOException {
        WordExport export = new WordExport();
        export.toWord(api, fileName);
    }

    public ApiDoc toDoc(ParseType pt, GenContext context, String ... packages) {
        if (pt == ParseType.PT_SPRING) {
            SpringParser parser = new SpringParser();
            ApiDoc doc = new ApiDoc();
            try {
                doc = parser.parse(context, packages);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return doc;
        }
        return new ApiDoc();
    }

    public String genHTML(ParseType pt, GenContext context, String ... packages) {
        ApiDoc doc = this.toDoc(pt, context, packages);
        try {
            String template = Template.readTemplate("/cn/mapway/document/resource/doctemplate.html");
            String ui = Template.readTemplate("/cn/mapway/document/resource/apidoc.nocache.js");
            String json = Json.toJson((Object)doc, (JsonFormat)JsonFormat.tidy());
            template = template.replace("API_DOC_DATA", json);
            template = template.replace("API_DOC_UI", ui);
            return template;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] getClearGifData() {
        return gifdata;
    }

    public String genDoc(ParseType pt, GenContext context, String ... packages) {
        ApiDoc doc = this.toDoc(pt, context, packages);
        String wordFile = "";
        return wordFile;
    }
}

