/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.database;

import com.mapway.database2java.database.IConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class GeneratorPool
implements IConnectionPool {
    private static GeneratorPool m_pool;
    private int checkedOut;
    private Vector freeConnections = new Vector();
    private String driverName;
    private String passwd;
    private String username;
    private String jdbcURL;
    private String database;
    private int maxConnections;
    private String pack;
    private String path;

    public GeneratorPool getInstance() {
        return m_pool;
    }

    public GeneratorPool(String drivername, String jdbcurl, String username, String password, String packagename, String path, int connectionSize) {
        this.driverName = drivername;
        this.jdbcURL = jdbcurl;
        this.username = username;
        this.passwd = password;
        this.pack = packagename;
        this.path = path;
        this.maxConnections = connectionSize;
        try {
            Class.forName(this.driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        m_pool = this;
    }

    public void log(String msg) {
        System.out.println(msg);
    }

    @Override
    public Connection getConnection() {
        Connection con = null;
        if (this.freeConnections.size() > 0) {
            con = (Connection)this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            try {
                if (con.isClosed()) {
                    con = this.getConnection();
                }
            }
            catch (SQLException e) {
                this.log("\ufffd\ufffd\ufffd\ufffd\ufffd\u04f3\ufffd\u027e\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u0427\ufffd\ufffd\ufffd\ufffd");
                con = this.getConnection();
            }
        } else if (this.maxConnections == 0 || this.checkedOut < this.maxConnections) {
            con = this.createConnection();
        }
        if (con != null) {
            ++this.checkedOut;
        }
        return con;
    }

    @Override
    public synchronized void releaseConnection(Connection con) {
        this.freeConnections.addElement(con);
        --this.checkedOut;
        this.notifyAll();
    }

    public synchronized Connection getConnection(long timeout) {
        Connection con;
        long startTime = new Date().getTime();
        while ((con = this.getConnection()) == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (new Date().getTime() - startTime < timeout) continue;
            return null;
        }
        return con;
    }

    public synchronized void close() {
        Enumeration allConnections = this.freeConnections.elements();
        while (allConnections.hasMoreElements()) {
            Connection con = (Connection)allConnections.nextElement();
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        }
        this.freeConnections.removeAllElements();
    }

    private Connection createConnection() {
        Connection con = null;
        try {
            con = this.username == null ? DriverManager.getConnection(this.jdbcURL) : DriverManager.getConnection(this.jdbcURL, this.username, this.passwd);
            this.log("" + this.jdbcURL + ":" + this.username + ":" + this.passwd);
        }
        catch (SQLException e) {
            this.log(" " + this.jdbcURL);
            this.log("" + e.getMessage());
            return null;
        }
        return con;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getNetPath() {
        return null;
    }

    @Override
    public String getPackage() {
        return this.pack;
    }

    @Override
    public String getGwtbase() {
        return this.pack;
    }
}

