/*
 * Decompiled with CFR 0.152.
 */
package com.bethecoder.ascii_table.impl;

import com.bethecoder.ascii_table.ASCIITableHeader;
import com.bethecoder.ascii_table.spec.IASCIITableAware;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CollectionASCIITableAware<T>
implements IASCIITableAware {
    private List<ASCIITableHeader> headers = null;
    private List<List<Object>> data = null;

    public CollectionASCIITableAware(List<T> objList, String ... properties) {
        this(objList, Arrays.asList(properties), Arrays.asList(properties));
    }

    public CollectionASCIITableAware(List<T> objList, List<String> properties, List<String> title) {
        if (objList != null && !objList.isEmpty() && properties != null && !properties.isEmpty()) {
            String header = null;
            this.headers = new ArrayList<ASCIITableHeader>(properties.size());
            for (int i = 0; i < properties.size(); ++i) {
                header = i < title.size() ? title.get(i) : properties.get(i);
                this.headers.add(new ASCIITableHeader(String.valueOf(header).toUpperCase()));
            }
            this.data = new ArrayList<List<Object>>();
            ArrayList<Object> rowData = null;
            Class<?> dataClazz = objList.get(0).getClass();
            HashMap<String, Method> propertyMethodMap = new HashMap<String, Method>();
            for (int j = 0; j < objList.size(); ++j) {
                rowData = new ArrayList<Object>();
                for (int k = 0; k < properties.size(); ++k) {
                    rowData.add(this.getProperty(propertyMethodMap, dataClazz, objList.get(j), properties.get(k)));
                }
                this.data.add(rowData);
            }
        }
    }

    private Object getProperty(Map<String, Method> propertyMethodMap, Class<?> dataClazz, T obj, String property) {
        Object cellValue = null;
        try {
            Method method = null;
            if (propertyMethodMap.containsKey(property)) {
                method = propertyMethodMap.get(property);
            } else {
                String methodName = "get" + this.capitalize(property);
                method = this.getMethod(dataClazz, methodName);
                if (method == null) {
                    methodName = "is" + this.capitalize(property);
                    method = this.getMethod(dataClazz, methodName);
                }
                if (method != null) {
                    propertyMethodMap.put(property, method);
                }
            }
            cellValue = method.invoke(obj, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cellValue;
    }

    private Method getMethod(Class<?> dataClazz, String methodName) {
        Method method = null;
        try {
            method = dataClazz.getMethod(methodName, new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private String capitalize(String property) {
        return property.length() == 0 ? property : String.valueOf(property.substring(0, 1).toUpperCase()) + property.substring(1).toLowerCase();
    }

    @Override
    public List<List<Object>> getData() {
        return this.data;
    }

    @Override
    public List<ASCIITableHeader> getHeaders() {
        return this.headers;
    }

    @Override
    public String formatData(ASCIITableHeader header, int row, int col, Object data) {
        try {
            BigDecimal bd = new BigDecimal(data.toString());
            return NumberFormat.getInstance().format(bd);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

