/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.database;

import com.mapway.database2java.database.IConnectionPool;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.servlet.jsp.jstl.sql.Result;
import javax.servlet.jsp.jstl.sql.ResultSupport;

public class AccessBase {
    protected IConnectionPool ConnectionPool;
    public static final String ERROR_DATABASE = "Database Access Error";
    public ArrayList<String> m_SQLs;

    public IConnectionPool getConnectionPool() {
        return this.ConnectionPool;
    }

    public void setConnectionPool(IConnectionPool pool) {
        this.ConnectionPool = pool;
    }

    public AccessBase(IConnectionPool pool) {
        this.ConnectionPool = pool;
    }

    public Result execute(String sql) throws SQLException {
        Result r = null;
        Connection con = this.ConnectionPool.getConnection();
        if (con == null) {
            return null;
        }
        Statement statement = null;
        try {
            statement = con.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            r = ResultSupport.toResult((ResultSet)rs);
            rs.close();
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.ConnectionPool.releaseConnection(con);
        }
        return r;
    }

    public int findCount(String src, char match) {
        int count = 0;
        for (int index = 0; index < src.length(); ++index) {
            char c = src.charAt(index);
            if (c != match) continue;
            ++count;
        }
        return count;
    }

    public void log(String info) {
        System.out.println(info);
    }

    public String stringFromClob(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        Reader clobStream = null;
        try {
            clobStream = clob.getCharacterStream();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        StringBuilder suggestions = new StringBuilder();
        int nchars = 0;
        char[] buffer = new char[10];
        try {
            while ((nchars = clobStream.read(buffer)) != -1) {
                suggestions.append(buffer, 0, nchars);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException();
        }
        try {
            clobStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException();
        }
        return suggestions.toString();
    }

    public void addSQL(String sql) {
        if (sql.equals("")) {
            return;
        }
        if (this.m_SQLs == null) {
            this.m_SQLs = new ArrayList();
        }
        this.m_SQLs.add(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] rs = new int[]{};
        Connection conn = this.ConnectionPool.getConnection();
        if (conn == null) {
            return rs;
        }
        Statement statement = null;
        boolean defaultCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            int c = 0;
            if (this.m_SQLs != null && this.m_SQLs.size() > 0) {
                c = this.m_SQLs.size();
            }
            if (c > 0) {
                for (int i = 0; i < c; ++i) {
                    statement.addBatch(this.m_SQLs.get(c));
                }
                rs = statement.executeBatch();
                conn.commit();
            }
        }
        catch (Exception e) {
            conn.rollback();
            e.printStackTrace();
        }
        finally {
            conn.setAutoCommit(defaultCommit);
            if (statement != null) {
                statement.clearBatch();
                statement.close();
            }
            this.alearSQL();
            this.ConnectionPool.releaseConnection(conn);
        }
        return rs;
    }

    public void alearSQL() {
        if (this.m_SQLs == null) {
            this.m_SQLs = new ArrayList();
        } else {
            this.m_SQLs.clear();
        }
    }

    public String resultToString(Result rs) {
        StringBuilder sb = new StringBuilder();
        String[] cns = rs.getColumnNames();
        for (int i = 0; i < cns.length; ++i) {
            sb.append(cns[i]);
            sb.append("\t");
        }
        Object[][] oos = rs.getRowsByIndex();
        for (int i = 0; i < oos.length; ++i) {
            sb.append("\r\n");
            Object[] os = oos[i];
            for (int j = 0; j < os.length; ++j) {
                sb.append(this.objectToString(os[j]));
                sb.append("\t");
            }
        }
        return sb.toString();
    }

    public String objectToString(Object o) {
        if (o == null) {
            return "----";
        }
        return o.toString();
    }
}

