/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java;

import com.mapway.database2java.Config;
import com.mapway.database2java.IConfigure;
import com.mapway.database2java.database.GeneratorPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.itf.ISchema;
import com.mapway.database2java.model.mysql.MySQL_Schema2_gwt;
import com.mapway.database2java.model.postgre.PostgreSQLSchema;
import com.mapway.database2java.model.schema.TypeMapper;
import java.io.IOException;
import org.apache.commons.cli.ParseException;
import org.nutz.json.Json;
import org.nutz.lang.Strings;

public class MainApplication {
    public void execute(IConfigure configure) {
        this.gen(configure);
    }

    public static void main(String[] args) {
        Config config = new Config();
        config.help();
        try {
            config.parse(args);
        }
        catch (ParseException e) {
            config.help();
            System.exit(0);
        }
        System.out.println(Json.toJson((Object)config));
        MainApplication app = new MainApplication();
        app.gen(config);
    }

    public void gen(IConfigure config) {
        boolean b;
        GeneratorPool pool = new GeneratorPool(config.getDriver(), config.getJDBCURL(), config.getUser(), config.getPassword(), config.getPackage(), config.getPath(), config.getMaxConnections());
        ISchema schema = null;
        String mapper = config.getMapper();
        if (mapper.length() > 0) {
            TypeMapper tmap = TypeMapper.getInstance();
            String[] items = mapper.split(",");
            for (int i = 0; i < items.length; ++i) {
                String[] kv;
                String item = items[i];
                if (Strings.isBlank((CharSequence)(item = Strings.trim((CharSequence)item))) || (kv = item.split(":")).length != 2) continue;
                String k = kv[0];
                String v = kv[1];
                tmap.getOracle2JDBC().Add(k, v);
            }
        }
        Configure configure = new Configure();
        configure.setUseFieldStyle(config.getUseFieldStyle());
        configure.setUseDocument(config.getUseDocument());
        configure.setUseGwt(config.getUseGwt());
        configure.setUseNutz(config.getUseNutz());
        configure.setUseFieldIndex(config.getUseFieldIndex());
        configure.setSchema(config.getSchema());
        System.out.println(" out " + pool.getPath());
        configure.setPath(pool.getPath());
        configure.setPackage(pool.getPackage());
        configure.setGwtbase(pool.getGwtbase());
        if (config.getDriver().contains("mysql")) {
            configure.setDatabase("mysql");
            schema = new MySQL_Schema2_gwt(pool, configure);
        }
        if (config.getDriver().contains("postgresql")) {
            configure.setDatabase("postgresql");
            schema = new PostgreSQLSchema(pool, configure);
        }
        if (b = schema.fetchSchema()) {
            System.out.println("Database Connected and fetch successful");
            System.out.println("Export Path:" + configure.getPath());
            Configure conf = configure.copy();
            try {
                schema.exportSimpleBean(conf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("gen Simple OK!");
            return;
        }
        System.out.println("\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25");
    }
}

