/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.model.oracle;

import com.mapway.database2java.database.IConnectionPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.base.SchemaBase;
import com.mapway.database2java.model.oracle.Oracle_SQLClause;
import com.mapway.database2java.model.schema.Argument;
import com.mapway.database2java.model.schema.Arguments;
import com.mapway.database2java.model.schema.Column;
import com.mapway.database2java.model.schema.Columns;
import com.mapway.database2java.model.schema.ITable;
import com.mapway.database2java.model.schema.Pack;
import com.mapway.database2java.model.schema.Procedure;
import com.mapway.database2java.model.schema.Procedures;
import com.mapway.database2java.model.schema.Sequence;
import com.mapway.database2java.model.schema.Table;
import com.mapway.database2java.model.schema.Tables;
import com.mapway.database2java.model.schema.View;
import com.mapway.database2java.model.schema.Views;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.jsp.jstl.sql.Result;

public class Oracle_Schema2
extends SchemaBase {
    @Override
    public String getCopyright() {
        Date d = new Date();
        String s = "/*******************************************************************************\r\n \ufffd\ufffd\u077f\ufffd\u05be\u00fb\ufffd\ufffd\ufffd(For Oracle9i-10g Java)\r\n \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd  " + d.toString() + "\r\n" + " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd Program \ufffd\u6c7e(3.0)\r\n" + " \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\u017d\ufffd\ufffd\ufffd EMAIL:zhangjianshe@gmail.com PHONE:15910868681\r\n" + super.getHeader() + "/******************************************************************************/\r\n";
        return s;
    }

    public Oracle_Schema2(IConnectionPool pool, Configure configure) {
        super(pool, configure);
        this.setSQLClause(new Oracle_SQLClause(configure.getDatabase()));
    }

    @Override
    public boolean fetchSchema() {
        Result rs;
        super.fetchSchema();
        try {
            rs = this.a.execute(this.getSQLClause().getTableSQL());
            System.out.println(this.a.resultToString(rs));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        Object[][] b = rs.getRowsByIndex();
        String old = "";
        Table tab = null;
        Columns cols = null;
        for (int i = 0; i < rs.getRowCount(); ++i) {
            Object[] c = b[i];
            String tn = (String)c[1];
            String tc = (String)c[0];
            String cn = (String)c[2];
            String ct = (String)c[3];
            String cc = (String)c[7];
            if (!tn.equals(old)) {
                old = tn;
                tab = new Table();
                tab.setName(tn);
                tab.setComment(tc);
                cols = tab.getColumns();
                this.getTables().addTable(tab);
            }
            Column col = new Column();
            col.setName(cn);
            col.setDatabaseType(ct);
            col.setComment(cc);
            int l = 0;
            if (c[4] != null && c[4].getClass().getName().indexOf("Long") >= 0) {
                Long big = (Long)c[4];
                l = big.intValue();
            }
            col.setLength(l);
            col.setPK(this.isPK(tn, cn));
            cols.addColumn(col);
        }
        try {
            rs = this.a.execute(this.getSQLClause().getViewSQL());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        b = rs.getRowsByIndex();
        old = "";
        View view = null;
        cols = null;
        for (int i = 0; i < rs.getRowCount(); ++i) {
            Object[] c = b[i];
            String tn = (String)c[1];
            String tc = (String)c[0];
            String cn = (String)c[2];
            String ct = (String)c[3];
            String cc = (String)c[7];
            if (!tn.equals(old)) {
                old = tn;
                view = new View();
                view.setName(tn);
                view.setComment(tc);
                cols = view.getColumns();
                this.getViews().addView(view);
            }
            Column col = new Column();
            col.setName(cn);
            col.setDatabaseType(ct);
            col.setComment(cc);
            BigDecimal d = (BigDecimal)c[4];
            col.setLength(d.intValue());
            cols.addColumn(col);
        }
        try {
            rs = this.a.execute(this.getSQLClause().getProcedureSQL());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        b = rs.getRowsByIndex();
        String old_packname = "";
        String old_procname = "";
        String old_argument = "";
        int index = 0;
        Pack newPack = null;
        Procedure newProc = null;
        Argument newArg = null;
        for (int i = 0; i < b.length; ++i) {
            Object[] c = b[i];
            String packagename = (String)c[0];
            String procname = (String)c[1];
            String argname = (String)c[2];
            BigDecimal d = (BigDecimal)c[3];
            int seqposition = d.intValue();
            String property = (String)c[4];
            String datatype = (String)c[5];
            if (!packagename.equals(old_packname)) {
                old_packname = packagename;
                newPack = new Pack();
                newPack.setName(packagename);
                this.getPackages().addPack(newPack);
                old_procname = "";
            }
            if (!procname.equals(old_procname)) {
                old_procname = procname;
                newProc = new Procedure();
                newProc.setName(procname);
                newProc.setPackageName(newPack.getName());
                newPack.getProcedures().addProcedure(newProc);
                old_argument = "";
                index = 0;
            }
            if (seqposition == 0) {
                // empty if block
            }
            if (argname == null || argname.equals("")) {
                argname = "Return" + index++;
            }
            if (!argname.equals(old_argument)) {
                old_argument = argname;
                newArg = new Argument();
            }
            newArg.setName(argname);
            newArg.setProperty(property);
            newArg.setPosition(seqposition);
            newArg.setType(datatype);
            newProc.getArguments().AddArguemnt(newArg);
        }
        Result seq = null;
        try {
            seq = this.a.execute(this.getSQLClause().getSequence_SQL());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        Object[][] seqoo = seq.getRowsByIndex();
        for (int i = 0; i < seqoo.length; ++i) {
            Object[] seqo = seqoo[i];
            Sequence sequence = new Sequence();
            sequence.setName((String)seqo[0]);
            this.getSequences().addSequence(sequence);
        }
        return true;
    }

    public String exportTable(Table table, Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        Configure cf = conf.copy();
        cf.setPackage(conf.getPackage() + ".client.modle");
        this.writeJavaBean(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "\\client\\modle", table.getName() + "Obj.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaObjs(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "\\client\\modle", table.getName() + "Objs.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaInterface(table, sb, cf);
        this.writeToFile(cf.getFilePath() + "\\server\\database\\dao", "I" + table.getName() + "DAO.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaAccess(table, sb, cf);
        this.writeToFile(cf.getFilePath() + "\\server\\database\\dao\\impl", table.getName() + "DAOImpl.java", sb.toString());
        return "";
    }

    private void writeJavaInterface(Table table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ".server.database.dao" + ";\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac;
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import " + p + ".server.database.base.ExecuteResult;");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaName() + ";");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaNames() + ";");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u04ff\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public interface I" + table.getName() + "DAO" + " {\r\n");
        this.out(sb, "\tpublic Result execute(String sql) throws SQLException;");
        this.out(sb, "\tpublic ExecuteResult execute2Result(String sql) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\r\n" + table.getJavaName() + " findBy" + col.getName() + "(" + col.getJavaType() + " " + col.getName().toUpperCase() + ")throws SQLException;");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b);");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + " [" + col.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col.getName() + "( boolean b );");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values);");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\u027e\ufffd\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param boolean");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean deleteByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0221" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
        StringBuilder param = new StringBuilder();
        StringBuilder param2 = new StringBuilder();
        StringBuilder param3 = new StringBuilder();
        for (int i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            Column col2 = table.getColumns().getAt(i2);
            if (!col2.isPK()) continue;
            this.out(sb, "\t* @Param " + col2.getName().toLowerCase());
            param.append(col2.getJavaType() + " " + col2.getName().toLowerCase() + ",");
            param2.append("`" + col2.getName() + "`=? AND ");
            param3.append(col2.getName().toLowerCase() + ",");
        }
        if (param.length() > 1) {
            param.deleteCharAt(param.length() - 1);
        }
        if (param2.length() > 4) {
            param2.setLength(param2.length() - 4);
        }
        if (param3.length() > 1) {
            param3.deleteCharAt(param3.length() - 1);
        }
        if (table.hasPK()) {
            this.out(sb, "\t/**");
            this.out(sb, "\t* @return " + table.getJavaName());
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " selectByPK  (" + param.toString() + ") throws SQLException;");
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffdORACLE \ufffd\ufffd\ufffd\ufffd\u027e\ufffd\ufffd" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
            this.out(sb, "\t* @param " + param.toString());
            this.out(sb, "\t* @return boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic boolean deleteByPK(" + param.toString() + " ) throws SQLException;");
        }
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObject  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObjects  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\u00b6\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean updateObjectsByPK  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/  ");
        this.out(sb, "\tpublic boolean updateObjectByPK  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u0123\ufffd\ufffdSQL\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u013c\ufffd\u00bc  ");
        this.out(sb, "\t* <code>sqlTemplate=\"FIELDA =? ,FIELDB=? where FIELDC=?\";</code> ");
        this.out(sb, "\t* @param sqlTemplate ");
        this.out(sb, "\t* @param values  ");
        this.out(sb, "\t* @return boolean ");
        this.out(sb, "\t*/ ");
        this.out(sb, "\tpublic boolean updateBySQLTemplate  (String sqlTemplate,Object...values)  throws SQLException;");
        this.out(sb, "}");
    }

    private void writeJavaAccess(Table table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        Column col2;
        Column col3;
        int i2;
        this.out(sb, "package " + conf.getPackage() + ".server.database.dao.impl;\r\n");
        for (int i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            if (!table.getColumns().getAt(i3).getJavaType().equals("byte[]")) continue;
            this.out(sb, "import java.sql.Blob;");
            break;
        }
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.PreparedStatement;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac;
        this.out(sb, "import " + p + ".server.database.base.AccessBase;");
        this.out(sb, "import " + p + ".server.database.base.ExecuteResult;");
        this.out(sb, "import " + p + ".server.database.base.IConnectionPool;\r\n");
        this.out(sb, "import java.util.ArrayList;");
        this.out(sb, "import " + p + ".server.database.dao.I" + table.getName() + "DAO;\r\n");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaName() + ";\r\n");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaNames() + ";\r\n");
        this.out(sb, this.findColumnImport(table.getColumns()));
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaAccessName() + " extends AccessBase implements I" + table.getName() + "DAO{\r\n");
        this.out(sb, "\tpublic " + table.getJavaAccessName() + "(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t\tm_searched=new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tm_SearchedROWID=true;");
        this.out(sb, "\t\tresetSearched(true);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate boolean[] m_searched;\r\n");
        this.out(sb, "\tprivate boolean m_SearchedROWID;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_searched[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}");
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            col3 = table.getColumns().getAt(i2);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col3.getComment() + "\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " findBy" + col3.getName() + "(" + col3.getJavaType() + " " + col3.getName().toUpperCase() + ") throws SQLException{");
            this.out(sb, "\t\t" + table.getJavaNames() + " objs=null;");
            this.out(sb, "\t\tString where=\"where " + col3.getName() + "=? \";");
            this.out(sb, "\t\tobjs=this.selectByWhereTemplate(where," + col3.getName().toUpperCase() + ");");
            this.out(sb, "\t\tif(objs.size()>0){ ");
            this.out(sb, "\t\treturn objs.get(0);");
            this.out(sb, "\t\t} ");
            this.out(sb, "\t\treturn null; ");
            this.out(sb, "\t} ");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate2(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException");
        this.out(sb, "\t{");
        this.out(sb, "\t\t" + table.getJavaName() + " o=new " + table.getJavaName() + "();");
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            col3 = table.getColumns().getAt(i2);
            if (col3.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i2 + "]) o.set" + col3.getName() + "(bytesFromBlob(rs.getBlob(\"" + col3.getName() + "\")));");
                continue;
            }
            if (col3.getDatabaseType().equals("SDO_GEOMETRY") || col3.getDatabaseType().equals("MDSYS.SDO_GEOMETRY")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i2 + "]) {");
                this.out(sb, "\t\tSTRUCT st = (oracle.sql.STRUCT) rs.getObject(\"" + col3.getName() + "\");");
                this.out(sb, "\t\tJGeometry geom = JGeometry.load(st);");
                this.out(sb, "\t\to.set" + col3.getName() + "(geom);");
                this.out(sb, "}");
                continue;
            }
            if (col3.getDatabaseType().equals("NUMBER") || col3.getDatabaseType().equals("NUMERIC") || col3.getDatabaseType().equals("SMALLINT") || col3.getDatabaseType().equals("INTEGER") || col3.getDatabaseType().equals("BIGINT") || col3.getDatabaseType().equals("REAL") || col3.getDatabaseType().equals("FLOAT") || col3.getDatabaseType().equals("DOUBLE") || col3.getDatabaseType().equals("integer") || col3.getDatabaseType().equals("smallint") || col3.getDatabaseType().equals("mediumint") || col3.getDatabaseType().equals("int") || col3.getDatabaseType().equals("bigint") || col3.getDatabaseType().equals("double") || col3.getDatabaseType().equals("float") || col3.getDatabaseType().equals("enum") || col3.getDatabaseType().equals("set")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i2 + "])" + "{ \r\n\t\t\trs.get" + col3.getJavaType4() + "(\"" + col3.getName() + "\");" + "o.set" + col3.getName() + "(true==rs.wasNull()?null:rs.get" + col3.getJavaType4() + "(\"" + col3.getName() + "\"));\r\n\t\t}");
                continue;
            }
            this.out(sb, "\t\tif(true ==m_searched[" + i2 + "]) o.set" + col3.getName() + "(rs.get" + col3.getJavaType4() + "(\"" + col3.getName() + "\"));");
        }
        this.out(sb, "\t\tif(true ==m_SearchedROWID) o.setROWID(rs.getString(\"ROWID\"));");
        this.out(sb, "\t\to.resetChanged(false);");
        this.out(sb, "\t\treturn o;");
        this.out(sb, "\t}\r\n");
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            col3 = table.getColumns().getAt(i2);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col3.getComment() + " [" + col3.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col3.getName() + "( boolean b ){");
            this.out(sb, "\t\tm_searched[ " + i2 + " ] = b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd Oracle [ROWID] \ufffd\u01f7\ufffd\ufffd\u046f");
        this.out(sb, "\t* @Param boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setSearchedROWID(boolean b){");
        this.out(sb, "\t\tm_SearchedROWID=b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\u05b6\ufffd Oracle [ROWID] \ufffd\u01f7\ufffd\ufffd\u046f");
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean getSearchedROWID(){");
        this.out(sb, "\t\treturn m_SearchedROWID;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd");
        this.out(sb, "\t* @return String");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate String searchField(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            col3 = table.getColumns().getAt(i2);
            this.out(sb, "\t\tif( true == m_searched[" + i2 + "]){sb.append(\"\\\"" + col3.getName() + "\\\" ,\");}");
        }
        this.out(sb, "\t\tif( true == m_SearchedROWID){sb.append(\"\\\"ROWID\\\",\");}");
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsetSearchedROWID(false);");
        this.out(sb, "\t\tsql.append(\"SELECT * FROM (\");");
        this.out(sb, "\t\tsql.append(\"SELECT A.*, rownum r FROM (\");");
        this.out(sb, "\t\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\t\tsql.append(searchField());");
        this.out(sb, "\t\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tsql.append(\") A   WHERE rownum <= \");");
        this.out(sb, "\t\tsql.append(String.valueOf(end));");
        this.out(sb, "\t\tsql.append(\") B WHERE r > \");");
        this.out(sb, "\t\tsql.append(String.valueOf(start));");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tlong count=0;");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        if (table.hasPK()) {
            String key = "";
            for (int i4 = 0; i4 < table.getColumns().getCount(); ++i4) {
                Column col4 = table.getColumns().getAt(i4);
                if (!col4.isPK()) continue;
                key = col4.getName();
                break;
            }
            this.out(sb, "\t\tsql.append(\"count(" + key + ")\");");
        } else {
            this.out(sb, "\t\tsql.append(\"count(" + table.getColumns().getAt(0).getName() + ")\");");
        }
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return 0;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count1=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count1;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tif(rs.next()){");
        this.out(sb, "\t\t\t\tcount=rs.getLong(1);;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn count;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\u027e\ufffd\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param boolean");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean deleteByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"DELETE FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tboolean b=false;");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tb=statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tResult result=null;");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tresult=ResultSupport.toResult(rs);");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn result;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0221" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
        StringBuilder param = new StringBuilder();
        StringBuilder param2 = new StringBuilder();
        StringBuilder param3 = new StringBuilder();
        for (int i5 = 0; i5 < table.getColumns().getCount(); ++i5) {
            Column col5 = table.getColumns().getAt(i5);
            if (!col5.isPK()) continue;
            this.out(sb, "\t* @Param " + col5.getName().toLowerCase());
            param.append(col5.getJavaType() + " " + col5.getName().toLowerCase() + ",");
            param2.append("\\\"" + col5.getName() + "\\\"=? AND ");
            param3.append(col5.getName().toLowerCase() + ",");
        }
        if (param.length() > 1) {
            param.deleteCharAt(param.length() - 1);
        }
        if (param2.length() > 4) {
            param2.setLength(param2.length() - 4);
        }
        if (param3.length() > 1) {
            param3.deleteCharAt(param3.length() - 1);
        }
        if (table.hasPK()) {
            this.out(sb, "\t* @return " + table.getJavaName());
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " selectByPK  (" + param.toString() + ") throws SQLException{");
            this.out(sb, "\t\tStringBuilder sql = new StringBuilder();");
            this.out(sb, "\t\tsql.append(\"SELECT \");");
            this.out(sb, "\t\tsql.append(searchField());");
            this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" WHERE \"); ");
            this.out(sb, "\t\tsql.append(\"" + param2.toString() + "\" );");
            this.out(sb, "\t\t" + table.getJavaName() + " o = null;");
            this.out(sb, "\t\tConnection con = this.ConnectionPool.getConnection();");
            this.out(sb, "\t\tPreparedStatement statement=null;");
            this.out(sb, "\t\ttry{");
            this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
            int index = 1;
            for (int i6 = 0; i6 < table.getColumns().getCount(); ++i6) {
                col2 = table.getColumns().getAt(i6);
                if (!col2.isPK()) continue;
                this.out(sb, "\t\t\tstatement.set" + col2.getJavaType2() + "(" + index + "," + col2.getName().toLowerCase() + ");");
                ++index;
            }
            this.out(sb, "\t\t\tResultSet rs = statement.executeQuery();");
            this.out(sb, "\t\t\tif (rs.next()){");
            this.out(sb, "\t\t\t\to = this.mapRecord2Obj(rs);");
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\t\trs.close();");
            this.out(sb, "\t\t\tif(statement!=null) statement.close();");
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\tcatch (SQLException e){");
            this.out(sb, "\t\t\te.printStackTrace();");
            this.out(sb, "\t\t\tthrow e;");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\tfinally{");
            this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\treturn o;");
            this.out(sb, "\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffdORACLE \ufffd\ufffd\ufffd\ufffd\u027e\ufffd\ufffd" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
            this.out(sb, "\t* @param " + param.toString());
            this.out(sb, "\t* @return boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic boolean deleteByPK(" + param.toString() + " ) throws SQLException");
            this.out(sb, "\t{");
            this.out(sb, "\tString sql=\" WHERE " + param2.toString() + "\";");
            this.out(sb, "\tboolean b=deleteByWhereTemplate(sql," + param3.toString() + " );");
            this.out(sb, "\treturn b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdROWID\ufffd\ufffd\u0221" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " selectByROWID  (String rowid) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql = new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" WHERE ROWID=?\"); ");
        this.out(sb, "\t\t" + table.getJavaName() + " o = null;");
        this.out(sb, "\t\tConnection con = this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
        this.out(sb, "\t\t\tstatement.setString(1,rowid);");
        this.out(sb, "\t\t\tResultSet rs = statement.executeQuery();");
        this.out(sb, "\t\t\tif (rs.next()){");
        this.out(sb, "\t\t\t\to = this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\tcatch (SQLException e){");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn o;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdORACLE ROWID\u027e\ufffd\ufffd" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
        this.out(sb, "\t* @param rowid");
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean deleteByROWID  (String rowid ) throws SQLException{");
        this.out(sb, "\t\tString where=\"WHERE ROWID = ?\";");
        this.out(sb, "\t\tboolean b=deleteByWhereTemplate(where,rowid);");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObject  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"INSERT INTO \\\"" + table.getName() + "\\\" (\");");
        this.out(sb, "\t\tStringBuilder s1=new StringBuilder();");
        this.out(sb, "\t\tStringBuilder s2=new StringBuilder();");
        this.out(sb, "\t\tint index=1;");
        this.out(sb, "\t\tint index1=1;");
        this.out(sb, "\t\tArrayList<Integer> autoKeys=new ArrayList<Integer> ();");
        ArrayList<Integer> autoIndex = new ArrayList<Integer>();
        for (int i7 = 0; i7 < table.getColumns().getCount(); ++i7) {
            col2 = table.getColumns().getAt(i7);
            if (col2.isAuto()) {
                this.out(sb, "\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged(" + i7 + ")==true && " + table.getJavaName().toLowerCase() + ".get" + col2.getName() + "()!=null ){");
                this.out(sb, "\t\t\ts1.append(\"\\\"" + col2.getName() + "\\\",\");");
                this.out(sb, "\t\t\ts2.append(\" ? ,\");");
                this.out(sb, "\t\t\tindex1++;");
                this.out(sb, "\t\t}else{");
                this.out(sb, "\t\t\ts1.append(\"\\\"" + col2.getName() + "\\\",\");");
                this.out(sb, "\t\t\ts2.append(\" " + col2.getSequence() + ".nextval ,\");");
                this.out(sb, "autoKeys.add(index1++);");
                this.out(sb, "\t\t}");
                autoIndex.add(i7 + 1);
                continue;
            }
            this.out(sb, "\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged(" + i7 + ")==true){");
            this.out(sb, "\t\t\ts1.append(\"\\\"" + col2.getName() + "\\\",\");");
            this.out(sb, "\t\t\ts2.append(\" ? ,\");");
            this.out(sb, "\t\t\tindex1++;");
            this.out(sb, "\t\t}");
        }
        this.out(sb, "\t\ts1.deleteCharAt(s1.length()-1);");
        this.out(sb, "\t\ts2.deleteCharAt(s2.length()-1);");
        this.out(sb, "\t\ts2.append(\")\");");
        this.out(sb, "\t\tsql.append(s1.toString());");
        this.out(sb, "\t\tsql.append(\" ) VALUES ( \");");
        this.out(sb, "\t\tsql.append(s2.toString());");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        if (autoIndex.size() > 0) {
            this.out(sb, "\t\t\tint[] keys =new int[autoKeys.size()];");
            this.out(sb, "\t\tfor(int p=0;p<autoKeys.size();p++)");
            this.out(sb, "\t\t{");
            this.out(sb, "\t\t\tkeys[p]=autoKeys.get(p);");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString(),keys);");
        } else {
            this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
        }
        int cur = 0;
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.isAuto()) {
                this.out(sb, "\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged(" + i + ")==true && " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "()!=null){");
                this.out(sb, " statement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;}");
                continue;
            }
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\t\tBlob blob" + String.valueOf(cur) + "=oracle.sql.BLOB.createTemporary(con, true, oracle.sql.BLOB.DURATION_SESSION);");
                this.out(sb, "\t\t\tblob" + String.valueOf(cur) + ".setBytes(1, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());");
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.setBlob(index, blob" + String.valueOf(cur++) + ");index++;}");
                continue;
            }
            if (col.getDatabaseType().equals("MDSYS.SDO_GEOMETRY") || col.getDatabaseType().equals("SDO_GEOMETRY")) {
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){");
                this.out(sb, "\t\t\tSTRUCT str" + i + " = JGeometry.store(" + table.getJavaName().toLowerCase() + ".get" + col.getName() + "(), con);");
                this.out(sb, "\t\t\tstatement.setObject(index, str" + i + ");index++;}");
                continue;
            }
            this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;}");
        }
        this.out(sb, "\t\t\tstatement.executeUpdate();");
        if (autoIndex.size() > 0) {
            this.out(sb, "\t\t\t\tResultSet rs2=statement.getGeneratedKeys();");
            this.out(sb, "\t\t\t\tif(rs2.next()){");
            this.out(sb, "\t\t\t\t\tint index3=0;");
            for (int u = 0; u < table.getColumns().getCount(); ++u) {
                col = table.getColumns().getAt(u);
                if (!col.isAuto()) continue;
                this.out(sb, "\t\t\t" + table.getJavaName().toLowerCase() + ".set" + col.getName().toUpperCase() + "(rs2.get" + col.getJavaType4() + "(keys[index3++]));");
            }
            this.out(sb, "\t\t\t}else");
            this.out(sb, "\t\t\t{System.out.println(\"Error while fetch generated keys for table " + table.getName() + "\");}");
        }
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e){");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObjects  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tboolean b = false;");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getJavaNames().toLowerCase() + ".size();i++){");
        this.out(sb, "\t\t\tthis.insertObject(" + table.getJavaNames().toLowerCase() + ".get(i));");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tb=true;");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\u00b6\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean updateObjectsByPK  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tboolean b = false;");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getJavaNames().toLowerCase() + ".size();i++){");
        this.out(sb, "\t\t\tthis.updateObjectByPK(" + table.getJavaNames().toLowerCase() + ".get(i));");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tb=true;");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/  ");
        this.out(sb, "\tpublic boolean updateObjectByPK  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"UPDATE \\\"" + table.getName() + "\\\" SET \");");
        this.out(sb, "\t\tint index=1;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.isPK()) continue;
            this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ) sql.append(\"" + col.getName() + " =?,\");");
        }
        this.out(sb, "\t\t\tsql.deleteCharAt(sql.length()-1);");
        this.out(sb, "\t\t\tsql.append(\"  WHERE " + param2.toString() + "\");");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.isPK()) continue;
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\t\tBlob blob" + String.valueOf(cur) + "=oracle.sql.BLOB.createTemporary(con, true, oracle.sql.BLOB.DURATION_SESSION);");
                this.out(sb, "\t\t\tblob" + String.valueOf(cur) + ".setBytes(1, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());");
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.setBlob(index, blob" + String.valueOf(cur++) + ");index++;}");
                continue;
            }
            this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;}");
        }
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (!col.isPK()) continue;
            this.out(sb, "\t\t\tstatement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;");
        }
        this.out(sb, "\t\t\tb = statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e){");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u0123\ufffd\ufffdSQL\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u013c\ufffd\u00bc  ");
        this.out(sb, "\t* <code>sqlTemplate=\"FIELDA =? ,FIELDB=? where FIELDC=?\";</code> ");
        this.out(sb, "\t* @param sqlTemplate ");
        this.out(sb, "\t* @param values  ");
        this.out(sb, "\t* @return boolean ");
        this.out(sb, "\t*/ ");
        this.out(sb, "\tpublic boolean updateBySQLTemplate  (String sqlTemplate,Object...values)  throws SQLException{");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(\"UPDATE \\\"" + table.getName() + "\\\" SET \"+sqlTemplate);");
        this.out(sb, "\t\t\tint count=findCount(sqlTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tb=statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void writeJavaObjs(Table table, StringBuilder sb, Configure conf) {
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.util.ArrayList;");
        this.out(sb, "import java.util.Iterator;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaNames() + " extends ArrayList<" + table.getJavaName() + ">{\r\n\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + "()");
        this.out(sb, "\t{");
        this.out(sb, "\t\tsuper();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void writeImportJGeometry(StringBuilder imports) {
        imports.append("import oracle.spatial.geometry.JGeometry;\r\n");
        imports.append("import oracle.spatial.util.GeometryExceptionWithContext;\r\n");
        imports.append("import oracle.spatial.util.WKT;\r\n");
        imports.append("import oracle.sql.STRUCT;\r\n");
    }

    private String findColumnImport(Columns cols) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cols.getCount(); ++i) {
            Column col = cols.getAt(i);
            if (!col.getDatabaseType().equals("MDSYS.SDO_GEOMETRY") && !col.getDatabaseType().equals("SDO_GEOMETRY")) continue;
            this.writeImportJGeometry(sb);
        }
        return sb.toString();
    }

    private void writeJavaBean(Table table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " *  " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, this.findColumnImport(table.getColumns()));
        this.out(sb, "public class " + table.getJavaName() + " implements java.io.Serializable{");
        this.out(sb, "\tprivate boolean[] m_changed;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + "(){");
        this.out(sb, "\t\tm_changed = new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetChanged(false);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \u022b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param b");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void resetChanged(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_changed[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @param b Boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setChanged(int index,boolean b){");
        this.out(sb, "\t\tm_changed[index]=b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @return");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean getChanged(int index){");
        this.out(sb, "\t\treturn m_changed[index];");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\ufffd\u00bcROWID");
        this.out(sb, "\t* @return rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic String getROWID(){");
        this.out(sb, "\t   return this.ROWID;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u00fc\ufffd\u00bcROWID");
        this.out(sb, "\t* @param rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setROWID(String rowid){");
        this.out(sb, "\t\tthis.ROWID=rowid;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate String\tROWID;");
        this.out(sb, "\t/**");
        this.out(sb, "\t*\ufffd\ufffd\ufffd\u043b\ufffduid");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate static final long serialVersionUID = 1L;");
        this.out(sb, "\t/**");
        this.out(sb, "\t*\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043b\ufffduid");
        this.out(sb, "\t*/");
        this.out(sb, "\tstatic long getSerialVersionUID() {");
        this.out(sb, "\treturn serialVersionUID;");
        this.out(sb, "\t}");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\tprivate " + col.getJavaType() + " " + col.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + col.getJavaType() + " get" + col.getName() + "(){");
            this.out(sb, "\t\treturn " + col.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + col.getName() + "(" + col.getJavaType() + " " + col.getName() + "){");
            this.out(sb, "\t\tthis." + col.getName() + "=" + col.getName() + ";");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "\t\t}\r\n");
            if (!col.getDatabaseType().equals("MDSYS.SDO_GEOMETRY") && !col.getDatabaseType().equals("SDO_GEOMETRY")) continue;
            this.out(sb, "\tpublic String get" + col.getName() + "AsWKT(){");
            this.out(sb, "\t\tWKT wkt=new WKT();");
            this.out(sb, "try{");
            this.out(sb, "\t\treturn new String(wkt.fromJGeometry(" + col.getName() + "));");
            this.out(sb, "\t\t} catch (GeometryExceptionWithContext e) {");
            this.out(sb, "\t\te.printStackTrace();");
            this.out(sb, "\t\treturn \"\";");
            this.out(sb, "\t\t}");
            this.out(sb, "\t}");
            this.out(sb, "\tpublic void set" + col.getName() + "AsWKT(String wktString){");
            this.out(sb, "\t\tWKT wkt=new WKT();");
            this.out(sb, "\t\ttry{");
            this.out(sb, "\t\tthis." + col.getName() + "= wkt.toJGeometry(wktString.getBytes());");
            this.out(sb, "\t\t} catch (GeometryExceptionWithContext e) {");
            this.out(sb, "\t\te.printStackTrace();");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "}");
        }
        this.out(sb, "\tpublic void copyTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\t" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic void mergeTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif(this.getChanged(" + i + ")==true){" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";}");
        }
        this.out(sb, "\t}");
        this.out(sb, "}");
    }

    @Override
    public void exportViews(View table, Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        Configure cf = conf.copy();
        cf.setPackage(conf.getPackage() + ".client.modle");
        this.WriteViewBean(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "\\client\\modle", table.getName() + "Obj.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewObjs(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "\\client\\modle", table.getName() + "Objs.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewInterface(table, sb, cf);
        this.writeToFile(cf.getFilePath() + "\\server\\database\\dao", "I" + table.getName() + "DAO.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewAccess(table, sb, cf);
        this.writeToFile(cf.getFilePath() + "\\server\\database\\dao\\impl", table.getName() + "DAOImpl.java", sb.toString());
    }

    private void WriteViewInterface(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        String pac;
        this.out(sb, "package " + conf.getPackage() + ".server.database.dao;\r\n");
        String p = pac = conf.getPackage();
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import " + p + ".server.database.base.ExecuteResult;");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaName() + ";");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaNames() + ";");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u04ff\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public interface I" + table.getName() + "DAO" + " {\r\n");
        this.out(sb, "\tpublic Result execute(String sql) throws SQLException;");
        this.out(sb, "\tpublic ExecuteResult execute2Result(String sql) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\r\n" + table.getJavaName() + " findBy" + col.getName() + "(" + col.getJavaType() + " " + col.getName().toUpperCase() + ")throws SQLException;");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b);");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + " [" + col.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col.getName() + "( boolean b );");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values);");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t}");
    }

    private void WriteViewAccess(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ".server.database.dao.impl;\r\n");
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.PreparedStatement;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac;
        this.out(sb, "import " + p + ".server.database.base.AccessBase;");
        this.out(sb, "import " + p + ".server.database.base.ExecuteResult;");
        this.out(sb, "import " + p + ".server.database.base.IConnectionPool;\r\n");
        this.out(sb, "import " + p + ".server.database.dao.I" + table.getName() + "DAO;\r\n");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaName() + ";\r\n");
        this.out(sb, "import " + p + ".client.modle." + table.getJavaNames() + ";\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaAccessName() + "Impl extends AccessBase implements I" + table.getName() + "DAO{\r\n");
        this.out(sb, "\tpublic " + table.getJavaAccessName() + "Impl(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t\tm_searched=new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tm_SearchedROWID=false;");
        this.out(sb, "\t\tresetSearched(true);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate boolean[] m_searched;\r\n");
        this.out(sb, "\tprivate boolean m_SearchedROWID;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_searched[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + "\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " findBy" + col.getName() + "(" + col.getJavaType() + " " + col.getName().toUpperCase() + ") throws SQLException{");
            this.out(sb, "\t\t" + table.getJavaNames() + " objs=null;");
            this.out(sb, "\t\tString where=\"where " + col.getName() + "=? \";");
            this.out(sb, "\t\tobjs=this.selectByWhereTemplate(where," + col.getName().toUpperCase() + ");");
            this.out(sb, "\t\tif(objs.size()>0){ ");
            this.out(sb, "\t\treturn objs.get(0);");
            this.out(sb, "\t\t} ");
            this.out(sb, "\t\treturn null; ");
            this.out(sb, "\t} ");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate2(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException");
        this.out(sb, "\t{");
        this.out(sb, "\t\t" + table.getJavaName() + " o=new " + table.getJavaName() + "();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i + "]) o.set" + col.getName() + "(bytesFromBlob(rs.getBlob(\"" + col.getName() + "\")));");
                continue;
            }
            if (col.getDatabaseType().equals("SDO_GEOMETRY") || col.getDatabaseType().equals("MDSYS.SDO_GEOMETRY")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i + "]) {");
                this.out(sb, "\t\tSTRUCT st = (oracle.sql.STRUCT) rs.getObject(\"" + col.getName() + "\");");
                this.out(sb, "\t\tJGeometry geom = JGeometry.load(st);");
                this.out(sb, "\t\to.set" + col.getName() + "(geom);");
                this.out(sb, "}");
                continue;
            }
            if (col.getDatabaseType().equals("NUMBER") || col.getDatabaseType().equals("NUMERIC") || col.getDatabaseType().equals("SMALLINT") || col.getDatabaseType().equals("INTEGER") || col.getDatabaseType().equals("BIGINT") || col.getDatabaseType().equals("REAL") || col.getDatabaseType().equals("FLOAT") || col.getDatabaseType().equals("DOUBLE") || col.getDatabaseType().equals("integer") || col.getDatabaseType().equals("smallint") || col.getDatabaseType().equals("mediumint") || col.getDatabaseType().equals("int") || col.getDatabaseType().equals("bigint") || col.getDatabaseType().equals("double") || col.getDatabaseType().equals("float") || col.getDatabaseType().equals("enum") || col.getDatabaseType().equals("set")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i + "])" + "{ \r\n\t\t\trs.get" + col.getJavaType4() + "(\"" + col.getName() + "\");" + "o.set" + col.getName() + "(true==rs.wasNull()?null:rs.get" + col.getJavaType4() + "(\"" + col.getName() + "\"));\r\n\t\t}");
                continue;
            }
            this.out(sb, "\t\tif(true ==m_searched[" + i + "]) o.set" + col.getName() + "(rs.get" + col.getJavaType4() + "(\"" + col.getName() + "\"));");
        }
        this.out(sb, "\t\to.resetChanged(false);");
        this.out(sb, "\t\treturn o;");
        this.out(sb, "\t}\r\n");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + " [" + col.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col.getName() + "( boolean b ){");
            this.out(sb, "\t\tm_searched[ " + i + " ] = b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd");
        this.out(sb, "\t* @return String");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate String searchField(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif( true == m_searched[" + i + "]){sb.append(\"\\\"" + col.getName() + "\\\" ,\");}");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT * FROM (\");");
        this.out(sb, "\t\tsql.append(\"SELECT A.*, rownum r FROM (\");");
        this.out(sb, "\t\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\t\tsql.append(searchField());");
        this.out(sb, "\t\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tsql.append(\") A   WHERE rownum <= \");");
        this.out(sb, "\t\tsql.append(String.valueOf(end));");
        this.out(sb, "\t\tsql.append(\") B WHERE r > \");");
        this.out(sb, "\t\tsql.append(String.valueOf(start));");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tlong count=0;");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(\"count(" + table.getColumns().getAt(0).getName() + ")\");");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return 0;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count1=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count1;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tif(rs.next()){");
        this.out(sb, "\t\t\t\tcount=rs.getLong(1);;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn count;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tResult result=null;");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tresult=ResultSupport.toResult(rs);");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn result;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void WriteViewObjs(View table, StringBuilder sb, Configure conf) {
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.util.ArrayList;");
        this.out(sb, "import java.util.Iterator;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaNames() + " extends ArrayList<" + table.getJavaName() + ">{\r\n\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + "()");
        this.out(sb, "\t{");
        this.out(sb, "\t\tsuper();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void WriteViewBean(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        String s = conf.getPackage();
        int index = s.lastIndexOf(".");
        s = s.substring(0, index) + ".json";
        this.out(sb, this.findColumnImport(table.getColumns()));
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " *  " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaName() + "{");
        this.out(sb, "\tprivate boolean[] m_changed;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + "(){");
        this.out(sb, "\t\tm_changed = new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetChanged(false);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \u022b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param b");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void resetChanged(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_changed[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @param b Boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setChanged(int index,boolean b){");
        this.out(sb, "\t\tm_changed[index]=b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @return");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean getChanged(int index){");
        this.out(sb, "\t\treturn m_changed[index];");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\ufffd\u00bcROWID");
        this.out(sb, "\t* @return rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic String getROWID(){");
        this.out(sb, "\t   return this.ROWID;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u00fc\ufffd\u00bcROWID");
        this.out(sb, "\t* @param rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setROWID(String rowid){");
        this.out(sb, "\t\tthis.ROWID=rowid;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate String\tROWID;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\tprivate " + col.getJavaType() + " " + col.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + col.getJavaType() + " get" + col.getName() + "(){");
            this.out(sb, "\t\treturn " + col.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + col.getName() + "(" + col.getJavaType() + " " + col.getName() + "){");
            this.out(sb, "\t\tthis." + col.getName() + "=" + col.getName() + ";");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "\t\t}\r\n");
            if (!col.getDatabaseType().equals("MDSYS.SDO_GEOMETRY") && !col.getDatabaseType().equals("SDO_GEOMETRY")) continue;
            this.out(sb, "\tpublic String get" + col.getName() + "AsWKT(){");
            this.out(sb, "\tWKT wkt=new WKT();");
            this.out(sb, "\treturn String(wkt.fromJGeometry(g));");
            this.out(sb, "}");
            this.out(sb, "\tpublic void set" + col.getName() + "AsWKT(String wktString){");
            this.out(sb, "\tWKT wkt=new WKT();");
            this.out(sb, "\tthis." + col.getName() + "= wkt.toJGeometry(wktString.getBytes()));");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "}");
        }
        this.out(sb, "\tpublic void copyTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\t" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic void mergeTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif(this.getChanged(" + i + ")==true){" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";}");
        }
        this.out(sb, "\t}");
        this.out(sb, "}");
    }

    @Override
    public void exportProcedures(Configure confProcedure) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        this.out(sb, "package " + confProcedure.getPackage() + ".server.database.dao.impl;\r\n");
        this.out(sb, "import java.sql.CallableStatement;");
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import oracle.jdbc.OracleTypes;");
        this.out(sb, "import java.sql.SQLException;\r\n");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        this.out(sb, "import " + confProcedure.getPackage() + ".server.database.dao.IProcedures;\r\n");
        this.out(sb, "import " + confProcedure.getPackage() + ".server.database.base.AccessBase;");
        this.out(sb, "import " + confProcedure.getPackage() + ".server.database.base.ExecuteResult;");
        this.out(sb, "import " + confProcedure.getPackage() + ".server.database.base.IConnectionPool;\r\n");
        StringBuilder imports = new StringBuilder();
        StringBuilder t1 = new StringBuilder();
        StringBuilder t2 = new StringBuilder();
        for (int i = 0; i < this.getPackages().getCount(); ++i) {
            Pack pack = this.getPackages().getAt(i);
            Procedures procs = pack.getProcedures();
            for (int j = 0; j < procs.getCount(); ++j) {
                Procedure proc = procs.getAt(j);
                imports.append("\r\nimport " + confProcedure.getPackage() + ".modle.Arg_" + proc.getName() + ";");
                this.exportProcedureArgument(proc, confProcedure);
                this.exportProcedure(proc, confProcedure, t1);
                this.exportProcedureInterface(proc, confProcedure, t2);
                System.out.println("Export Database PL/SQL Package -Procedure " + proc.getName());
            }
        }
        this.out(sb, imports.toString());
        this.out(sb, "public class  ProceduresImpl extends AccessBase implements IProcedures{\r\n");
        this.out(sb, "\tpublic ProceduresImpl(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tString errMessage=\"\";");
        this.out(sb, "\tpublic String getErrMessage() {");
        this.out(sb, "\t\treturn errMessage;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic void setErrMessage(String errMessage) {");
        this.out(sb, "\t\tthis.errMessage = errMessage;");
        this.out(sb, "\t}\r\n");
        this.out(sb, t1.toString());
        this.out(sb, "}");
        this.out(sb1, "package " + confProcedure.getPackage() + ".server.database.dao;\r\n");
        this.out(sb1, imports.toString());
        this.out(sb1, "public interface  IProcedures{\r\n");
        this.out(sb1, t2.toString());
        this.out(sb1, "}");
        this.writeToFile(confProcedure.getFilePath() + "\\server\\database\\dao\\impl", "ProceduresImpl.java", sb.toString());
        this.writeToFile(confProcedure.getFilePath() + "\\server\\database\\dao", "IProcedures.java", sb1.toString());
    }

    private void exportProcedureArgument(Procedure func, Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, "package " + conf.getPackage() + ".client.modle;");
        this.out(sb, "\r\n");
        this.out(sb, this.findImport(func.getArguments()));
        this.out(sb, "public class Arg_" + func.getName() + "{");
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            this.out(sb, "\tprivate " + arg.getJavaType() + " " + arg.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + arg.getName() + " " + arg.getJavaType());
            if (arg.getProperty().equals("IN")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            } else if (arg.getProperty().equals("OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\u05b5");
            } else if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd");
            }
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + arg.getJavaType() + " get" + arg.getName() + "(){");
            this.out(sb, "\t\treturn " + arg.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + arg.getName() + " " + arg.getJavaType());
            if (arg.getProperty().equals("IN")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            } else if (arg.getProperty().equals("OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\u05b5");
            } else if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd");
            }
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + arg.getName() + "(" + arg.getJavaType() + " " + arg.getName() + "){");
            this.out(sb, "\t\tthis." + arg.getName() + "=" + arg.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            if (!arg.getJavaType().equals("MDSYS.SDO_GEOMETRY") && !arg.getJavaType().equals("SDO_GEOMETRY")) continue;
            this.out(sb, "\tpublic String get" + arg.getName() + "AsWKT(){");
            this.out(sb, "\tWKT wkt=new WKT();");
            this.out(sb, "\treturn String(wkt.fromJGeometry(g));");
            this.out(sb, "}");
            this.out(sb, "\tpublic void set" + arg.getName() + "AsWKT(String wktString){");
            this.out(sb, "\tWKT wkt=new WKT();");
            this.out(sb, "\tthis." + arg.getName() + "= wkt.toJGeometry(wktString.getBytes()));");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "}");
        }
        this.out(sb, "}");
        this.writeToFile(conf.getFilePath() + "\\client\\modle", "Arg_" + func.getName() + ".java", sb.toString());
    }

    private void exportProcedureInterface(Procedure func, Configure conf, StringBuilder body) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tpublic   boolean " + func.getName() + "(Arg_" + func.getName() + " arg);");
        body.append(sb.toString());
    }

    private void exportProcedure(Procedure func, Configure conf, StringBuilder body) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tpublic final  boolean " + func.getName() + "(Arg_" + func.getName() + " arg)");
        this.out(sb, "\t{");
        this.out(sb, "\t\tboolean b=false;");
        String head = "";
        String que = "";
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            if (arg.getPosition() == 0) {
                head = " ?:= ";
                continue;
            }
            que = que + "?,";
        }
        if (que.length() > 1) {
            que = que.substring(0, que.length() - 1);
        }
        String sche = "";
        sche = func.getPackageName().equals("") ? "" : func.getPackageName() + ".";
        String sql = "{call " + head + " " + sche + func.getName() + "(" + que + ")}";
        this.out(sb, "\t\tString sql=\"" + sql + "\";");
        this.out(sb, "\t\tConnection con= this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tCallableStatement cstm=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tcstm= con.prepareCall(sql);");
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            if (arg.getProperty().equals("IN")) {
                this.out(sb, "\t\t\tcstm.set" + arg.getJavaType2() + "(" + (i + 1) + ",arg.get" + arg.getName() + "());");
                continue;
            }
            if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t\t\tcstm.set" + arg.getJavaType2() + "(" + (i + 1) + ",arg.get" + arg.getName() + "());");
                this.out(sb, "\t\t\tcstm.registerOutParameter(" + (i + 1) + ", " + arg.getJavaType3() + ");");
                continue;
            }
            if (!arg.getProperty().equals("OUT")) continue;
            this.out(sb, "\t\t\tcstm.registerOutParameter(" + (i + 1) + ", " + arg.getJavaType3() + ");");
        }
        this.out(sb, "\t\t\tb=cstm.execute();");
        boolean hasREF = false;
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t\t\targ.set" + arg.getName() + "(cstm.get" + arg.getJavaType4() + "(" + (i + 1) + "));");
                continue;
            }
            if (!arg.getProperty().equals("OUT")) continue;
            System.out.println("argument  " + arg.getName() + " " + arg.getType());
            if (arg.getType().equals("REF CURSOR")) {
                if (!hasREF) {
                    this.out(sb, "\t\t\tResultSet rs=null;");
                    this.out(sb, "\t\t\tResult r=null;");
                    hasREF = true;
                }
                this.out(sb, "\t\t\trs=(ResultSet)cstm.getObject(" + (i + 1) + ");");
                this.out(sb, "\t\t\tr=ResultSupport.toResult(rs);");
                this.out(sb, "\t\t\trs.close();");
                this.out(sb, "\t\t\targ.set" + arg.getName() + "(r);");
                continue;
            }
            this.out(sb, "\t\t\targ.set" + arg.getName() + "(cstm.get" + arg.getJavaType4() + "(" + (i + 1) + "));");
        }
        this.out(sb, "\t\t\tcstm.close();");
        this.out(sb, "\t\t\tb=true;");
        this.out(sb, "\t\t} catch (SQLException e) {");
        this.out(sb, "\t\t\tsetErrMessage(e.getMessage());");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        body.append(sb.toString());
    }

    private String findImport(Arguments arguments) {
        StringBuilder imports = new StringBuilder();
        for (int i = 0; i < arguments.getCount(); ++i) {
            Argument arg = arguments.getAt(i);
            if (arg.getJavaType().equals("Result")) {
                imports.append("import javax.servlet.jsp.jstl.sql.Result;\r\nimport javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
                continue;
            }
            if (!arg.getJavaType().equals("JGeometry")) continue;
            imports.append("import oracle.spatial.geometry.JGeometry;\r\n");
            imports.append("import oracle.spatial.util.GeometryExceptionWithContext;\r\n");
            imports.append("import oracle.spatial.util.WKT;\r\n");
            imports.append("import oracle.sql.STRUCT;\r\n");
        }
        return imports.toString();
    }

    @Override
    public void exportSpringConfigure(Configure conf) {
        StringBuilder sb = new StringBuilder();
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\">\r\n\t<bean id=\"MyPool\" class=\"" + conf.getPackage() + ".base.MyPool\"\r\n" + "\tfactory-method=\"getInstance\">\r\n" + "\t<constructor-arg>\r\n" + "\t\t<value>Oracle</value>\r\n" + "\t</constructor-arg>\r\n" + "\t</bean>\r\n";
        sb.append(header);
        Tables ts = this.getTables();
        for (int i = 0; i < ts.getCount(); ++i) {
            ITable t = ts.getAt(i);
            sb.append("\t<bean id=\"" + t.getName() + "DAO\" scope=\"prototype\"" + "\tclass=\"" + conf.getPackage() + ".dao.oracle.impl." + t.getJavaAccessName() + "\">\r\n" + "\t\t<constructor-arg ref=\"MyPool\"></constructor-arg>\r\n" + "\t</bean>\r\n");
        }
        Views vs = this.getViews();
        for (int i = 0; i < vs.getCount(); ++i) {
            View t = vs.getAt(i);
            sb.append("\t<bean id=\"" + t.getName() + "DAO\" scope=\"prototype\"" + "\tclass=\"" + conf.getPackage() + ".dao.oracle.impl." + t.getJavaAccessName() + "Impl\">" + "\t\t<constructor-arg ref=\"MyPool\"></constructor-arg>" + "\t</bean>");
        }
        sb.append("</beans>");
        this.writeToFile(conf.getFilePath() + "\\server\\database", "bean_dao_oracle.xml", sb.toString());
    }
}

