/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.model.mysql;

import com.mapway.database2java.database.IConnectionPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.base.SchemaBase;
import com.mapway.database2java.model.mysql.MySQL_SQLClause;
import com.mapway.database2java.model.schema.Column;
import com.mapway.database2java.model.schema.Columns;
import com.mapway.database2java.model.schema.ITable;
import com.mapway.database2java.model.schema.Table;
import com.mapway.database2java.model.schema.View;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.jsp.jstl.sql.Result;

public class MySQL_Schema
extends SchemaBase {
    @Override
    public String getCopyright() {
        Date d = new Date();
        String s = "/*******************************************************************************\r\n(For MySQL5.1 Java)\r\n " + d.toString() + "\r\n" + " (3.0)\r\n" + " EMAIL:zhangjianshe@gmail.com PHONE:15910868681\r\n";
        s = s + super.getHeader();
        s = s + "/******************************************************************************/\r\n";
        return s;
    }

    public MySQL_Schema(IConnectionPool pool, Configure configure) {
        super(pool, configure);
        this.setSQLClause(new MySQL_SQLClause(configure.getDatabase()));
    }

    @Override
    public boolean fetchSchema() {
        Long big;
        int l;
        Column col;
        Result rs;
        super.fetchSchema();
        try {
            rs = this.a.execute(this.getSQLClause().getTableSQL());
            System.out.println(this.a.resultToString(rs));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        Object[][] b = rs.getRowsByIndex();
        String old = "";
        Table tab = null;
        Columns cols = null;
        for (int i = 0; i < rs.getRowCount(); ++i) {
            Object[] c = b[i];
            String tn = (String)c[1];
            String tc = (String)c[0];
            String cn = (String)c[2];
            String ct = (String)c[3];
            String cc = (String)c[7];
            String extra = (String)c[8];
            if (!tn.equals(old)) {
                old = tn;
                tab = new Table();
                tab.setName(tn.toUpperCase());
                tab.setComment(tc);
                cols = tab.getColumns();
                this.getTables().addTable(tab);
            }
            col = new Column();
            col.setName(cn.toUpperCase());
            col.setDatabaseType(ct);
            col.setComment(cc);
            l = 0;
            if (c[4] != null && c[4].getClass().getName().indexOf("Long") >= 0) {
                big = (Long)c[4];
                l = big.intValue();
            }
            col.setLength(l);
            if (extra != null && extra.indexOf("auto_increment") >= 0) {
                col.setAuto(true);
            } else {
                col.setAuto(false);
            }
            col.setPK(this.isPK(tn, cn));
            cols.addColumn(col);
        }
        try {
            rs = this.a.execute(this.getSQLClause().getViewSQL());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        b = rs.getRowsByIndex();
        old = "";
        View view = null;
        cols = null;
        for (int i = 0; i < rs.getRowCount(); ++i) {
            Object[] c = b[i];
            String tn = (String)c[1];
            String tc = (String)c[0];
            String cn = (String)c[2];
            String ct = (String)c[3];
            String cc = (String)c[7];
            if (!tn.equals(old)) {
                old = tn;
                view = new View();
                view.setName(tn.toUpperCase());
                view.setComment(tc);
                cols = view.getColumns();
                this.getViews().addView(view);
            }
            col = new Column();
            col.setName(cn.toUpperCase());
            col.setDatabaseType(ct);
            col.setComment(cc);
            l = 0;
            if (c[4] != null && c[4].getClass().getName().indexOf("Long") >= 0) {
                big = (Long)c[4];
                l = big.intValue();
            }
            col.setLength(l);
            cols.addColumn(col);
        }
        return true;
    }

    @Override
    public String exportTable(ITable table, Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaBean(table, sb, conf);
        this.writeToFile(conf.getFilePath(), table.getName() + "Obj.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaObjs(table, sb, conf);
        this.writeToFile(conf.getFilePath(), table.getName() + "Objs.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaAccess(table, sb, conf);
        this.writeToFile(conf.getFilePath(), table.getName() + "Access.java", sb.toString());
        return "";
    }

    private void writeJavaBean(ITable table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " *  " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        String s = conf.getPackage();
        int index = s.lastIndexOf(".");
        s = s.substring(0, index) + ".json";
        this.out(sb, "import " + s + ".JSONHelper;");
        this.out(sb, "public class " + table.getJavaName() + " implements java.io.Serializable{");
        this.out(sb, "\tprivate boolean[] m_changed;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + "(){");
        this.out(sb, "\t\tm_changed = new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetChanged(false);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \u022b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param b");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void resetChanged(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_changed[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @param b Boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setChanged(int index,boolean b){");
        this.out(sb, "\t\tm_changed[index]=b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @return");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean getChanged(int index){");
        this.out(sb, "\t\treturn m_changed[index];");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t*\ufffd\ufffd\ufffd\u043b\ufffduid");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate static final long serialVersionUID = 1L;");
        this.out(sb, "\t/**");
        this.out(sb, "\t*\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043b\ufffduid");
        this.out(sb, "\t*/");
        this.out(sb, "\tstatic long getSerialVersionUID() {");
        this.out(sb, "\treturn serialVersionUID;");
        this.out(sb, "\t}");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\tprivate " + col.getJavaType() + " " + col.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + col.getName() + "  " + col.getComment() + "  " + col.getDatabaseType());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + col.getJavaType() + " get" + col.getName() + "(){");
            this.out(sb, "\t\treturn " + col.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + col.getName() + "  " + col.getComment() + "  " + col.getDatabaseType());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + col.getName() + "(" + col.getJavaType() + " " + col.getName() + "){");
            this.out(sb, "\t\tthis." + col.getName() + "=" + col.getName() + ";");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "\t\t}\r\n");
        }
        this.out(sb, "\tpublic void copyTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\t" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic void mergeTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif(this.getChanged(" + i + ")==true){" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";}");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"----\":this.get" + col.getName() + "().toString());");
            this.out(sb, "\t\tsb.append(\" | \");");
        }
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tsb.append(\"{\");");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(\"" + col.getName() + ":\");");
            if (col.getJavaType().equals("String")) {
                this.out(sb, "\t\tsb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(JSONHelper.escape(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
                this.out(sb, "\t\tsb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.math.BigDecimal")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Boolean")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Byte")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Short")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Integer")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Float")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Double")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Date")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.sql.Time")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("Long")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Timestamp")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString().substring(0,19));");
                this.out(sb, "sb.append(\"\\\"\");");
            }
            this.out(sb, "\t\tsb.append(\",\");");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\tsb.append(\"}\");");
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void writeJavaObjs(ITable table, StringBuilder sb, Configure conf) {
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.util.ArrayList;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaNames() + "{\r\n\r\n");
        this.out(sb, "\tArrayList<" + table.getJavaName() + "> ObjList;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + "()");
        this.out(sb, "\t{");
        this.out(sb, "\t\tObjList=new ArrayList<" + table.getJavaName() + ">();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @return ArrayList<" + table.getJavaName() + ">");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic ArrayList<" + table.getJavaName() + "> getObjList()");
        this.out(sb, "\t{");
        this.out(sb, "\t\treturn this.ObjList;");
        this.out(sb, "\t}");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @return int");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\u0431\ufffd\ufffd\ufffd\ufffd\u077c\ufffd\u00bc\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic int getCount()");
        this.out(sb, "\t{");
        this.out(sb, "\t\treturn this.ObjList.size();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @param index");
        this.out(sb, "\t * @return " + table.getJavaName());
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\u0431\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd index \ufffd\ufffd\u00bc");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaName() + " getAt(int index)");
        this.out(sb, "\t{");
        this.out(sb, "\t\treturn this.ObjList.get(index);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u057c\ufffd\u00bc");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void clear()");
        this.out(sb, "\t{");
        this.out(sb, "\t\t this.ObjList.clear();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @param " + table.getJavaName() + " " + table.getJavaName().toLowerCase());
        this.out(sb, "\t * \ufffd\ufffd\u04fc\ufffd\u00bc");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void add(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + ")");
        this.out(sb, "\t{");
        this.out(sb, "\t\t this.ObjList.add(" + table.getJavaName().toLowerCase() + ");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tfor(int i=0;i<this.ObjList.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.ObjList.get(i).toString());");
        this.out(sb, "\t\t\tsb.append(\"\\r\\n\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdJSON\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tif(this.ObjList.size()>0)");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\t\tsb.append(\"[\");");
        this.out(sb, "\t\tfor(int i=0;i<this.ObjList.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.ObjList.get(i).toJSONString());");
        this.out(sb, "\t\t\tsb.append(\",\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\t\tsb.append(\"]\");");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t\telse");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\t\treturn \"[]\";");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void writeJavaAccess(ITable table, StringBuilder sb, Configure conf) {
        int i;
        Column col;
        int i2;
        Column col2;
        int i3;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        for (int i4 = 0; i4 < table.getColumns().getCount(); ++i4) {
            if (!table.getColumns().getAt(i4).getJavaType().equals("byte[]")) continue;
            this.out(sb, "import java.sql.Blob;");
            break;
        }
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.PreparedStatement;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac.substring(0, pos);
        pos = p.lastIndexOf(46);
        p = p.substring(0, pos);
        this.out(sb, "import " + p + ".base.AccessBase;");
        this.out(sb, "import " + p + ".base.ExecuteResult;");
        this.out(sb, "import " + p + ".base.IConnectionPool;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaAccessName() + " extends AccessBase {\r\n");
        this.out(sb, "\tpublic " + table.getJavaAccessName() + "(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t\tm_searched=new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetSearched(true);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate boolean[] m_searched;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_searched[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate2(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException");
        this.out(sb, "\t{");
        this.out(sb, "\t\t" + table.getJavaName() + " o=new " + table.getJavaName() + "();");
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            if (col2.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]) o.set" + col2.getName() + "(bytesFromBlob(rs.getBlob(\"" + col2.getName() + "\")));");
                continue;
            }
            this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]) o.set" + col2.getName() + "(rs.get" + col2.getJavaType2() + "(\"" + col2.getName() + "\"));");
        }
        this.out(sb, "\t\to.resetChanged(false);");
        this.out(sb, "\t\treturn o;");
        this.out(sb, "\t}\r\n");
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col2.getComment() + " [" + col2.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col2.getName() + "( boolean b ){");
            this.out(sb, "\t\tm_searched[ " + i3 + " ] = b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd");
        this.out(sb, "\t* @return String");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate String searchField(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            if (col2.getDatabaseType().equals("geometry")) {
                this.out(sb, "\t\tif( true == m_searched[" + i3 + "]){sb.append(\"astext(" + col2.getName() + ") " + col2.getName() + ",\");}");
                continue;
            }
            this.out(sb, "\t\tif( true == m_searched[" + i3 + "]){sb.append(\"`" + col2.getName() + "`,\");}");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tif(whereTemplate==null )whereTemplate=\"\";");
        this.out(sb, "\t\t    sql.append(\"select \");");
        this.out(sb, "\t\t    sql.append(searchField());");
        this.out(sb, "\t\t    sql.append(\" from `\");");
        this.out(sb, "\t\t    sql.append(\"" + table.getName() + "` \"); ");
        this.out(sb, "\t\t    sql.append(whereTemplate);");
        this.out(sb, "\t\t    sql.append(\" limit \");");
        this.out(sb, "\t\t    sql.append(start);");
        this.out(sb, "\t\t    sql.append(\",\");");
        this.out(sb, "\t\t    sql.append(end);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tlong count=0;");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        if (table.hasPK()) {
            String key = "";
            for (int i5 = 0; i5 < table.getColumns().getCount(); ++i5) {
                Column col3 = table.getColumns().getAt(i5);
                if (!col3.isPK()) continue;
                key = col3.getName();
                break;
            }
            this.out(sb, "\t\tsql.append(\"count(" + key + ")\");");
        } else {
            this.out(sb, "\t\tsql.append(\"count(" + table.getColumns().getAt(0).getName() + ")\");");
        }
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return 0;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count1=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count1;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tif(rs.next()){");
        this.out(sb, "\t\t\t\tcount=rs.getLong(1);;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn count;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\u027e\ufffd\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param boolean");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean deleteByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"DELETE FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tboolean b=false;");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tb=statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tResult result=null;");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tresult=ResultSupport.toResult(rs);");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn result;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0221" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
        StringBuilder param = new StringBuilder();
        StringBuilder param2 = new StringBuilder();
        StringBuilder param3 = new StringBuilder();
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            Column col4 = table.getColumns().getAt(i2);
            if (!col4.isPK()) continue;
            this.out(sb, "\t* @Param " + col4.getName().toLowerCase());
            param.append(col4.getJavaType() + " " + col4.getName().toLowerCase() + ",");
            param2.append("`" + col4.getName() + "`=? AND ");
            param3.append(col4.getName().toLowerCase() + ",");
        }
        if (param.length() > 1) {
            param.deleteCharAt(param.length() - 1);
        }
        if (param2.length() > 4) {
            param2.setLength(param2.length() - 4);
        }
        if (param3.length() > 1) {
            param3.deleteCharAt(param3.length() - 1);
        }
        if (table.hasPK()) {
            this.out(sb, "\t* @return " + table.getJavaName());
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " selectByPK  (" + param.toString() + ") throws SQLException{");
            this.out(sb, "\t\tStringBuilder sql = new StringBuilder();");
            this.out(sb, "\t\tsql.append(\"SELECT \");");
            this.out(sb, "\t\tsql.append(searchField());");
            this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` WHERE \"); ");
            this.out(sb, "\t\tsql.append(\"" + param2.toString() + "\" );");
            this.out(sb, "\t\t" + table.getJavaName() + " o = null;");
            this.out(sb, "\t\tConnection con = this.ConnectionPool.getConnection();");
            this.out(sb, "\t\tPreparedStatement statement=null;");
            this.out(sb, "\t\ttry{");
            this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
            int index = 1;
            for (int i6 = 0; i6 < table.getColumns().getCount(); ++i6) {
                col = table.getColumns().getAt(i6);
                if (!col.isPK()) continue;
                this.out(sb, "\t\t\tstatement.set" + col.getJavaType2() + "(" + index + "," + col.getName().toLowerCase() + ");");
                ++index;
            }
            this.out(sb, "\t\t\tResultSet rs = statement.executeQuery();");
            this.out(sb, "\t\t\tif (rs.next()){");
            this.out(sb, "\t\t\t\to = this.mapRecord2Obj(rs);");
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\t\trs.close();");
            this.out(sb, "\t\t\tif(statement!=null) statement.close();");
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\tcatch (SQLException e){");
            this.out(sb, "\t\t\te.printStackTrace();");
            this.out(sb, "\t\t\tthrow e;");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\tfinally{");
            this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\treturn o;");
            this.out(sb, "\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffdORACLE \ufffd\ufffd\ufffd\ufffd\u027e\ufffd\ufffd" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
            this.out(sb, "\t* @param " + param.toString());
            this.out(sb, "\t* @return boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic boolean deleteByPK(" + param.toString() + " ) throws SQLException");
            this.out(sb, "\t{");
            this.out(sb, "\tString sql=\" WHERE " + param2.toString() + "\";");
            this.out(sb, "\tboolean b=deleteByWhereTemplate(sql," + param3.toString() + " );");
            this.out(sb, "\treturn b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObject  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"INSERT INTO `" + table.getName() + "` (\");");
        this.out(sb, "\t\tStringBuilder s1=new StringBuilder();");
        this.out(sb, "\t\tStringBuilder s2=new StringBuilder();");
        this.out(sb, "\t\tint index=1;");
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            Column col5 = table.getColumns().getAt(i2);
            this.out(sb, "\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged(" + i2 + ")==true){");
            this.out(sb, "\t\t\ts1.append(\"`" + col5.getName() + "`,\");");
            if (col5.getDatabaseType().equals("geometry")) {
                this.out(sb, "\t\t\ts2.append(\" geomfromtext(?) ,\");");
            } else {
                this.out(sb, "\t\t\ts2.append(\" ? ,\");");
            }
            this.out(sb, "\t\t}");
        }
        this.out(sb, "\t\ts1.deleteCharAt(s1.length()-1);");
        this.out(sb, "\t\ts2.deleteCharAt(s2.length()-1);");
        this.out(sb, "\t\ts2.append(\")\");");
        this.out(sb, "\t\tsql.append(s1.toString());");
        this.out(sb, "\t\tsql.append(\" ) VALUES ( \");");
        this.out(sb, "\t\tsql.append(s2.toString());");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
        int cur = 0;
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\t\tBlob blob" + String.valueOf(cur) + "=oracle.sql.BLOB.createTemporary(con, true, oracle.sql.BLOB.DURATION_SESSION);");
                this.out(sb, "\t\t\tblob" + String.valueOf(cur) + ".setBytes(1, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());");
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.setBlob(index, blob" + String.valueOf(cur++) + ");index++;}");
                continue;
            }
            this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;}");
        }
        this.out(sb, "\t\t\tb = statement.execute();");
        if (table.hasAuto()) {
            this.out(sb, "\t\t\tResultSet rs=statement.getGeneratedKeys();");
            this.out(sb, "\t\t\twhile(rs.next())");
            this.out(sb, "\t\t\t{");
            this.out(sb, "\t\t\t int index1=1;");
            for (i = 0; i < table.getColumns().getCount(); ++i) {
                col = table.getColumns().getAt(i);
                if (!col.isAuto()) continue;
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==false ){ " + table.getJavaName().toLowerCase() + ".set" + col.getName() + "(rs.get" + col.getJavaType2() + "(index1++));}");
            }
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\t\trs=null;");
        }
        this.out(sb, "\t\t\tif(statement!=null);");
        this.out(sb, "    {");
        this.out(sb, "    \tstatement.close();");
        this.out(sb, "    \tstatement=null;");
        this.out(sb, "    }");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e){");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObjects  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tboolean b = false;");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getJavaNames().toLowerCase() + ".getCount();i++){");
        this.out(sb, "\t\t\tthis.insertObject(" + table.getJavaNames().toLowerCase() + ".getAt(i));");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tb=true;");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\u00b6\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean updateObjectsByPK  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tboolean b = false;");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getJavaNames().toLowerCase() + ".getCount();i++){");
        this.out(sb, "\t\t\tthis.updateObjectByPK(" + table.getJavaNames().toLowerCase() + ".getAt(i));");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tb=true;");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/  ");
        this.out(sb, "\tpublic boolean updateObjectByPK  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"UPDATE `" + table.getName() + "` SET \");");
        this.out(sb, "\t\tint index=1;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (!col.isPK()) {
                System.out.println("\tCOLUMN " + i + ":" + col.isPK() + ":" + col.getName());
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ) sql.append(\"" + col.getName() + " =?,\");");
            }
            System.out.println("COLUMN " + i + ":" + col.isPK() + ":" + col.getName());
        }
        this.out(sb, "\t\t\tsql.deleteCharAt(sql.length()-1);");
        this.out(sb, "\t\t\tsql.append(\"  WHERE " + param2.toString() + "\");");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.isPK()) continue;
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\t\tBlob blob" + String.valueOf(cur) + "=oracle.sql.BLOB.createTemporary(con, true, oracle.sql.BLOB.DURATION_SESSION);");
                this.out(sb, "\t\t\tblob" + String.valueOf(cur) + ".setBytes(1, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());");
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.setBlob(index, blob" + String.valueOf(cur++) + ");index++;}");
                continue;
            }
            this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;}");
        }
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (!col.isPK()) continue;
            this.out(sb, "\t\t\tstatement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;");
        }
        this.out(sb, "\t\t\tb = statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e){");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u0123\ufffd\ufffdSQL\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u013c\ufffd\u00bc  ");
        this.out(sb, "\t* <code>sqlTemplate=\"FIELDA =? ,FIELDB=? where FIELDC=?\";</code> ");
        this.out(sb, "\t* @param sqlTemplate ");
        this.out(sb, "\t* @param values  ");
        this.out(sb, "\t* @return boolean ");
        this.out(sb, "\t*/ ");
        this.out(sb, "\tpublic boolean updateBySQLTemplate  (String sqlTemplate,Object...values)  throws SQLException{");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(\"UPDATE `" + table.getName() + "` SET \"+sqlTemplate);");
        this.out(sb, "\t\t\tint count=findCount(sqlTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tb=statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    @Override
    public void exportViews(View at, Configure confView) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewBean(at, sb, confView);
        this.writeToFile(confView.getFilePath(), at.getName() + "Obj.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewObjs(at, sb, confView);
        this.writeToFile(confView.getFilePath(), at.getName() + "Objs.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewAccess(at, sb, confView);
        this.writeToFile(confView.getFilePath(), at.getName() + "Access.java", sb.toString());
    }

    private void WriteViewAccess(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.PreparedStatement;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac.substring(0, pos);
        pos = p.lastIndexOf(46);
        p = p.substring(0, pos);
        this.out(sb, "import " + p + ".base.AccessBase;");
        this.out(sb, "import " + p + ".base.ExecuteResult;");
        this.out(sb, "import " + p + ".base.IConnectionPool;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaAccessName() + " extends AccessBase {\r\n");
        this.out(sb, "\tpublic " + table.getJavaAccessName() + "(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t\tm_searched=new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tm_SearchedROWID=true;");
        this.out(sb, "\t\tresetSearched(true);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate boolean[] m_searched;\r\n");
        this.out(sb, "\tprivate boolean m_SearchedROWID;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_searched[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate2(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException");
        this.out(sb, "\t{");
        this.out(sb, "\t\t" + table.getJavaName() + " o=new " + table.getJavaName() + "();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif(true ==m_searched[" + i + "]) o.set" + col.getName() + "(rs.get" + col.getJavaType2() + "(\"" + col.getName() + "\"));");
        }
        this.out(sb, "\t\tif(true ==m_SearchedROWID) o.setROWID(rs.getString(\"ROWID\"));");
        this.out(sb, "\t\to.resetChanged(false);");
        this.out(sb, "\t\treturn o;");
        this.out(sb, "\t}\r\n");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + " [" + col.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col.getName() + "( boolean b ){");
            this.out(sb, "\t\tm_searched[ " + i + " ] = b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd");
        this.out(sb, "\t* @return String");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate String searchField(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif( true == m_searched[" + i + "]){sb.append(\"`" + col.getName() + "` ,\");}");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM \\\"" + table.getName() + "\\\" \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\t    sql.append(\"select \");");
        this.out(sb, "\t\t    sql.append(searchField());");
        this.out(sb, "\t\t    sql.append(\" from `\");");
        this.out(sb, "\t\t    sql.append(\"" + table.getName() + "` \"); ");
        this.out(sb, "\t\t    sql.append(whereTemplate);");
        this.out(sb, "\t\t    sql.append(\" limit \");");
        this.out(sb, "\t\t    sql.append(start);");
        this.out(sb, "\t\t    sql.append(\",\");");
        this.out(sb, "\t\t    sql.append(end);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tlong count=0;");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(\"count(" + table.getColumns().getAt(0).getName() + ")\");");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return 0;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count1=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count1;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tif(rs.next()){");
        this.out(sb, "\t\t\t\tcount=rs.getLong(1);;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn count;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tResult result=null;");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tresult=ResultSupport.toResult(rs);");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn result;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void WriteViewObjs(View table, StringBuilder sb, Configure conf) {
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.util.ArrayList;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaNames() + "{\r\n\r\n");
        this.out(sb, "\tArrayList<" + table.getJavaName() + "> ObjList;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + "()");
        this.out(sb, "\t{");
        this.out(sb, "\t\tObjList=new ArrayList<" + table.getJavaName() + ">();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @return ArrayList<" + table.getJavaName() + ">");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic ArrayList<" + table.getJavaName() + "> getObjList()");
        this.out(sb, "\t{");
        this.out(sb, "\t\treturn this.ObjList;");
        this.out(sb, "\t}");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @return int");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\u0431\ufffd\ufffd\ufffd\ufffd\u077c\ufffd\u00bc\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic int getCount()");
        this.out(sb, "\t{");
        this.out(sb, "\t\treturn this.ObjList.size();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @param index");
        this.out(sb, "\t * @return " + table.getJavaName());
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\u0431\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd index \ufffd\ufffd\u00bc");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaName() + " getAt(int index)");
        this.out(sb, "\t{");
        this.out(sb, "\t\treturn this.ObjList.get(index);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u057c\ufffd\u00bc");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void clear()");
        this.out(sb, "\t{");
        this.out(sb, "\t\t this.ObjList.clear();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * @param " + table.getJavaName() + " " + table.getJavaName().toLowerCase());
        this.out(sb, "\t * \ufffd\ufffd\u04fc\ufffd\u00bc");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void add(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + ")");
        this.out(sb, "\t{");
        this.out(sb, "\t\t this.ObjList.add(" + table.getJavaName().toLowerCase() + ");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tfor(int i=0;i<this.ObjList.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.ObjList.get(i).toString());");
        this.out(sb, "\t\t\tsb.append(\"\\r\\n\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdJSON\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tif(this.ObjList.size()>0)");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\t\tsb.append(\"[\");");
        this.out(sb, "\t\tfor(int i=0;i<this.ObjList.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.ObjList.get(i).toJSONString());");
        this.out(sb, "\t\t\tsb.append(\",\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\t\tsb.append(\"]\");");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t\telse");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\t\treturn \"[]\";");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void WriteViewBean(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        String s = conf.getPackage();
        int index = s.lastIndexOf(".");
        s = s.substring(0, index) + ".json";
        this.out(sb, "import " + s + ".JSONHelper;");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " *  " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaName() + "{");
        this.out(sb, "\tprivate boolean[] m_changed;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + "(){");
        this.out(sb, "\t\tm_changed = new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetChanged(false);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \u022b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param b");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void resetChanged(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_changed[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @param b Boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setChanged(int index,boolean b){");
        this.out(sb, "\t\tm_changed[index]=b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @return");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean getChanged(int index){");
        this.out(sb, "\t\treturn m_changed[index];");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\ufffd\u00bcROWID");
        this.out(sb, "\t* @return rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic String getROWID(){");
        this.out(sb, "\t   return this.ROWID;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u00fc\ufffd\u00bcROWID");
        this.out(sb, "\t* @param rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setROWID(String rowid){");
        this.out(sb, "\t\tthis.ROWID=rowid;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate String\tROWID;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\tprivate " + col.getJavaType() + " " + col.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + col.getJavaType() + " get" + col.getName() + "(){");
            this.out(sb, "\t\treturn " + col.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + col.getName() + "(" + col.getJavaType() + " " + col.getName() + "){");
            this.out(sb, "\t\tthis." + col.getName() + "=" + col.getName() + ";");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "\t\t}\r\n");
        }
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"----\":this.get" + col.getName() + "().toString());");
            this.out(sb, "\t\tsb.append(\" | \");");
        }
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic void copyTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\t" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic void mergeTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif(this.getChanged(" + i + ")==true){" + table.getJavaName().toLowerCase() + "." + col.getName() + " = " + "this." + col.getName() + ";}");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tsb.append(\"{\");");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(\"" + col.getName() + ":\");");
            if (col.getJavaType().equals("String")) {
                this.out(sb, "\t\tsb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(JSONHelper.escape(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
                this.out(sb, "\t\tsb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.math.BigDecimal")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Boolean")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Byte")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Short")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Integer")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Float")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Double")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Date")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.sql.Time")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("Long")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Timestamp")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString().substring(0,19));");
                this.out(sb, "sb.append(\"\\\"\");");
            }
            this.out(sb, "\t\tsb.append(\",\");");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\tsb.append(\"}\");");
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }
}

