/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.database;

import com.mapway.database2java.database.IConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class MyPool
implements IConnectionPool {
    private int checkedOut;
    private Vector freeConnections = new Vector();
    private String driverName;
    private String passwd;
    private String username;
    private String jdbcURL;
    private String database;
    private int maxConnections;
    private static MyPool m_poolOracle;
    private static MyPool m_poolMySQL;
    private String path;
    private String pack;
    private String gwt_modle;
    private String gwt_dao;
    private String gwt_base;
    public final String DT_MYSQL = "MySQL";
    public final String DT_ORACLE = "Oracle";
    String netPath;

    public String getGwt_base() {
        return this.gwt_base;
    }

    public void setGwt_base(String gwt_base) {
        this.gwt_base = gwt_base;
    }

    public static synchronized MyPool getInstance(String database) {
        return MyPool.getInstance(database, "database");
    }

    public static synchronized MyPool getInstance() {
        return m_poolMySQL;
    }

    public static synchronized MyPool getInstance(String database, String configurefile) {
        if (database == null || database.equals("")) {
            database = "Oracle";
        }
        if (database.equals("Oracle")) {
            if (m_poolOracle == null) {
                m_poolOracle = new MyPool("Oracle", configurefile);
            }
            return m_poolOracle;
        }
        if (database.equals("MySQL")) {
            if (m_poolMySQL == null) {
                m_poolMySQL = new MyPool("MySQL", configurefile);
            }
        } else if (database.equals("MySQL2") && m_poolMySQL == null) {
            m_poolMySQL = new MyPool("MySQL2", configurefile);
        }
        return m_poolMySQL;
    }

    public MyPool(String drivername, String jdbcurl, String username, String password, String packagename, String path, int connectionSize) {
        this.driverName = drivername;
        this.jdbcURL = jdbcurl;
        this.username = username;
        this.passwd = password;
        this.pack = packagename;
        this.path = path;
        this.maxConnections = connectionSize;
        try {
            Class.forName(this.driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        m_poolMySQL = this;
    }

    public MyPool(String databaseType, ResourceBundle rb) {
        this.init(databaseType, rb);
    }

    public MyPool(String database, String configurefile) {
        if (database == null) {
            database = "Oracle";
        }
        Locale locale = Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle(configurefile, locale);
        this.init(database, rb);
    }

    private void init(String databaseType, ResourceBundle rb) {
        this.driverName = rb.getString(this.database + "_driver");
        this.jdbcURL = rb.getString(this.database + "_dataurl");
        this.username = rb.getString(this.database + "_user");
        this.passwd = rb.getString(this.database + "_password");
        this.pack = rb.getString(this.database + "_package");
        this.path = rb.getString(this.database + "_path");
        this.database = rb.getString(this.database + "_database");
        this.netPath = rb.getString(this.database + "_netpath");
        this.gwt_modle = rb.getString("gwt_modle");
        this.gwt_dao = rb.getString("gwt_dao");
        this.gwt_base = rb.getString("gwt_base");
        this.maxConnections = Integer.valueOf(rb.getString(this.database + "_maxconnections"));
        try {
            Class.forName(this.driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void log(String msg) {
        System.out.println(msg);
    }

    @Override
    public synchronized void releaseConnection(Connection con) {
        this.freeConnections.addElement(con);
        --this.checkedOut;
        this.notifyAll();
    }

    @Override
    public synchronized Connection getConnection() {
        Connection con = null;
        if (this.freeConnections.size() > 0) {
            con = (Connection)this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            try {
                if (con.isClosed()) {
                    this.log("\ufffd\ufffd\ufffd\ufffd\ufffd\u04f3\ufffd\u027e\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u0427\ufffd\ufffd\ufffd\ufffd");
                    con = this.getConnection();
                }
            }
            catch (SQLException e) {
                this.log("\ufffd\ufffd\ufffd\ufffd\ufffd\u04f3\ufffd\u027e\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u0427\ufffd\ufffd\ufffd\ufffd");
                con = this.getConnection();
            }
        } else if (this.maxConnections == 0 || this.checkedOut < this.maxConnections) {
            con = this.createConnection();
        }
        if (con != null) {
            ++this.checkedOut;
        }
        return con;
    }

    public synchronized Connection getConnection(long timeout) {
        Connection con;
        long startTime = new Date().getTime();
        while ((con = this.getConnection()) == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (new Date().getTime() - startTime < timeout) continue;
            return null;
        }
        return con;
    }

    public synchronized void close() {
        Enumeration allConnections = this.freeConnections.elements();
        while (allConnections.hasMoreElements()) {
            Connection con = (Connection)allConnections.nextElement();
            try {
                con.close();
                this.log("\ufffd\u0631\ufffd\ufffd\ufffd\ufffd\u04f3\ufffd\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            catch (SQLException e) {
                this.log("\ufffd\u07b7\ufffd\ufffd\u0631\ufffd\ufffd\ufffd\ufffd\u04f3\ufffd\ufffd\u0435\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
        }
        this.freeConnections.removeAllElements();
    }

    private Connection createConnection() {
        Connection con = null;
        try {
            con = this.username == null ? DriverManager.getConnection(this.jdbcURL.replace("$database", this.database)) : DriverManager.getConnection(this.jdbcURL.replace("$database", this.database), this.username, this.passwd);
            this.log("\ufffd\ufffd\ufffd\u04f3\u0634\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\u00b5\ufffd\ufffd\ufffd\ufffd\ufffd@" + this.jdbcURL.replace("$database", this.database) + ":" + this.username + ":" + this.passwd);
        }
        catch (SQLException e) {
            this.log("\ufffd\u07b7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdURL\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd: " + this.jdbcURL.replace("$database", this.database));
            this.log("\u052d\ufffd\ufffd " + e.getMessage());
            return null;
        }
        return con;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public MyPool(String driverName, String passwd, String username, String jdbcURL) {
        this.driverName = driverName;
        this.passwd = passwd;
        this.username = username;
        this.jdbcURL = jdbcURL;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setPackage(String pack) {
        this.pack = pack;
    }

    @Override
    public String getNetPath() {
        return this.netPath;
    }

    public void setNetPath(String netPath) {
        this.netPath = netPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPackage() {
        return this.pack;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public String getGwtbase() {
        return this.gwt_base;
    }
}

