/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java;

import com.mapway.database2java.Config;
import com.mapway.database2java.database.GeneratorPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.itf.ISchema;
import com.mapway.database2java.model.mysql.MySQL_Schema2_gwt;
import com.mapway.database2java.model.schema.Tables;
import com.mapway.database2java.model.schema.Views;
import org.apache.commons.cli.ParseException;

public class MainApplication {
    public static void main(String[] args) {
        boolean b;
        Config config = new Config();
        config.help();
        try {
            config.parse(args);
        }
        catch (ParseException e) {
            config.help();
            System.exit(0);
        }
        System.out.println(config.getDriver());
        System.out.println(config.getJDBCURL());
        System.out.println(config.getMaxConnections());
        System.out.println(config.getPackage());
        System.out.println(config.getPath());
        System.out.println(config.getSchema());
        System.out.println(config.getUser());
        System.out.println(config.getPassword());
        GeneratorPool pool = new GeneratorPool(config.getDriver(), config.getJDBCURL(), config.getUser(), config.getPassword(), config.getPackage(), config.getPath(), config.getMaxConnections());
        ISchema schema = null;
        Configure configure = new Configure();
        configure.setSchema(config.getSchema());
        System.out.println(" out " + pool.getPath());
        configure.setPath(pool.getPath());
        configure.setPackage(pool.getPackage());
        configure.setGwtbase(pool.getGwtbase());
        if (config.getDriver().contains("mysql")) {
            configure.setDatabase("mysql");
            schema = new MySQL_Schema2_gwt(pool, configure);
        }
        if (b = schema.fetchSchema()) {
            System.out.println("Database Connected and fetch successful");
            System.out.println("Export Path:" + configure.getPath());
            if (config.getNutz().equals("1")) {
                Configure conf = configure.copy();
                schema.exportJavaBean(conf);
                System.out.println("gen NUTZ OK!");
                return;
            }
            Configure conf = configure.copy();
            conf.setPackage(conf.getGwtbase());
            schema.exportProcedures(conf);
            Configure confTable = configure.copy();
            Tables tables = schema.getTables();
            System.out.println("Export Database tables ...");
            for (int j = 0; j < tables.getCount(); ++j) {
                schema.exportTable(tables.getAt(j), confTable);
                System.out.println("Export Database tables " + tables.getAt(j).getName());
            }
            confTable = configure.copy();
            confTable.setPackage(configure.getPackage());
            Views views = schema.getViews();
            System.out.println("Export Database views ...");
            for (int j = 0; j < views.getCount(); ++j) {
                schema.exportViews(views.getAt(j), confTable);
                System.out.println("Export Database view" + tables.getAt(j).getName());
            }
            Configure confjson = configure.copy();
            confjson.setPackage(confjson.getPackage() + ".shared.modle");
            System.out.println("Export JSON Helper");
            schema.exportJSONTools(confjson);
            Configure confbase = configure.copy();
            schema.exportGwtModule(confbase);
            confbase.setPackage(confbase.getPackage() + ".server.database.base");
            schema.exportPoolInterface(confbase);
            schema.exportAccessBase(confbase);
            schema.exportExecuteResult(confbase);
            Configure confSpring = configure.copy();
            schema.exportSpringConfigure(confSpring);
            schema.exportDwrConfigure(confSpring);
        } else {
            System.out.println("Error connect to the database");
        }
    }
}

