package cn.majingjing.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * String processing tools
 *
 * @author JingjingMa
 * @date 2019/8/19 16:00
 */
public class StringUtils {

    /**
     * Escape string
     *
     * @param message will be escape string
     * @return string of escaped
     */
    public static String xssFilter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder();
        for (char c : content) {
            switch (c) {
                case '<':
                    result.append("&lt;");
                    break;
                case '>':
                    result.append("&gt;");
                    break;
                case '&':
                    result.append("&amp;");
                    break;
                case '"':
                    result.append("&quot;");
                    break;
                default:
                    result.append(c);
            }
        }
        return result.toString();
    }

    /**
     * hump to underline
     *
     * @param name string
     * @return string
     */
    public static String toUnderscoreName(String name) {
        if (MyUtils.isEmpty(name)) {
            return "";
        } else {
            StringBuilder result = new StringBuilder();
            result.append(name.substring(0, 1).toLowerCase());

            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                String slc = s.toLowerCase();
                if (!s.equals(slc)) {
                    result.append("_").append(slc);
                } else {
                    result.append(s);
                }
            }

            return result.toString();
        }
    }

    /**
     * underline to hump
     *
     * @param name string
     * @return string
     */
    public static String toHumpName(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() <= 1) {
            return name.toLowerCase();
        }
        StringBuilder dst = new StringBuilder();
        boolean beUpCase = false;
        for (int i = 0; i < name.length(); i++) {
            String tmp = name.substring(i, i + 1);
            if ("_".equals(tmp)) {
                beUpCase = true;
                continue;
            }
            if (beUpCase) {
                dst.append(tmp.toUpperCase());
            } else {
                dst.append(tmp.toLowerCase());
            }
            beUpCase = false;
        }
        return dst.toString();

    }

    /**
     * Truncate the string from the beginning
     * @param s str
     * @param len trunc length
     * @return string of truncated
     */
    public static String subPrefix(String s, int len) {
        if (null != s && s.length() > len) {
            return s.substring(0, len);
        }
        return s;
    }

    /**
     * Truncate the string from the end
     * @param s str
     * @param len trunc length
     * @return string of truncated
     */
    public static String subSuffix(String s, int len) {
        if (null != s && s.length() > len) {
            return s.substring(s.length() - len);
        }
        return s;
    }

    /**
     * Filter all tags that start with <and end with>
     */
    private static Pattern HTML2TEXT_PATTERN = Pattern.compile("<([^>]*)>");

    /**
     * html to text
     *
     * @param str html content
     * @return text
     */
    public static String html2text(String str) {
        Matcher matcher = HTML2TEXT_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

}
